PRO VRML_POLY, lun, vlist, plist, $
                         Transform=Transform, $
                         AmbientColor=kamb, Diffusecolor = kdiff, $
                         EmissiveColor = color, Transparency = ktran, $
                         SpecularColor = kspec, shininess = ns, $
                         MaterialIndices=materialindices, $
                         VertexColor=vertexcolor, $
                         Solid=solid

; vlist - Vertex List (3,nvert) of x,y,z coords for nvert vertices
; plist - Polygon list describing NPOLY polygons
; Transform - A (4,4) matrix (as in !P.T) containing the transform to 
; AmbientColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; DiffuseColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; EmissiveColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; Transparency - An n-element array of transparency.  In range of 0...255
; SpecularColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; Shininess - An n-element array of shininess factor.  In range of 0...255
; MaterialIndices - An NPOLY array of indices into above material property 
;          arrays in range 0...n-1.  Defaults to the case for n==NPOLY
; /VertexColor - Material colors are per-vertex rather than per-polygon
; /Solid - Sets the shape hints to indicate that this is a Solid shape 
;          (it encloses a volume)

   ON_ERROR,2
   
   PRINTF, lun, 'Separator {'

   PRINTF, lun, 'ShapeHints { vertexOrdering COUNTERCLOCKWISE'

   IF KEYWORD_SET(solid) THEN $
     PRINTF, lun, 'shapeType SOLID'

   PRINTF, lun, '}'

   IF N_ELEMENTS(transform) EQ 16 THEN $
     VRML_WRITE_Transform, lun, transform
               
   VRML_WRITE_Material, lun, $
                   AmbientColor=kamb, Diffusecolor = kdiff, $
                   EmissiveColor = color, Transparency = ktran, $
                   SpecularColor = kspec, shininess = ns

   IF KEYWORD_SET(vertexcolor) THEN BEGIN
     materialbinding = 'PER_VERTEX'
   ENDIF ELSE BEGIN
     materialbinding = 'PER_FACE'
   ENDELSE

   IF N_ELEMENTS(materialindices) NE 0 THEN BEGIN
      materialbinding = materialbinding + '_INDEXED'
   ENDIF
   
   PRINTF, lun, 'MaterialBinding { value ', materialbinding, ' }'

   ; Coordinates - the polygon Vertices

   PRINTF, lun, 'Coordinate3 {'
   VRML_WRITE_MFVec3f, lun, 'point', vlist
   PRINTF, lun, '}' ; Coordinate3

   ; Indexed Face Set - The polygon and material indices

   PRINTF, lun, 'IndexedFaceSet {'

   npolys = POLY_COUNT( plist )

   faces = plist   ; copy the array
   j = 0L
   FOR i = 0L, npolys-1 DO BEGIN
      len = plist(j)
      k = j + len
      faces(j) = plist(j+1L:k)
      faces(k) = -1L
      j = k + 1L
   ENDFOR

   VRML_WRITE_MFLong, lun, 'coordIndex', faces

   faces=0  ; free memory

   IF N_ELEMENTS(materialindices) NE 0 THEN $
     VRML_WRITE_MFLong, lun, 'materialIndex', materialindices

   PRINTF, lun, '}' ; IndexedFaceSet

   ; Reset to defaults

   PRINTF, lun, 'MaterialBinding { value DEFAULT }'

   ; Reset default shape hints

   PRINTF, lun, 'ShapeHints { }'
   PRINTF, lun, '}' ; Separator - end of Object

END
