; VRML_OPEN and VRML Utility routines

PRO VRML_WRITE_MFVec3f, lun, tag, vec
   ; vec should be a (3,n)

   PRINTF, lun, tag, ' ['
   n = N_ELEMENTS(vec(0, *))
   PRINTF, lun, vec, Format = '((3F,:,","))'
   PRINTF, lun, ']'

END

PRO VRML_WRITE_MFColor, lun, tag, col
   ; col is a (3,n) array of RGB colors in range of 0...255
   ; If just a scalar or (n) element array then assumed to be greyscale

   IF SIZE(col, /NDim) LE 1 THEN BEGIN
      IF N_ELEMENTS(col) EQ 3 THEN BEGIN      ; assume just RGB
         VRML_WRITE_MFVec3f, lun, tag, col/255.
      ENDIF ELSE BEGIN
         VRML_WRITE_MFVec3f, lun, tag, TRANSPOSE([[col],[col],[col]])/255.
      ENDELSE
   ENDIF ELSE BEGIN
      VRML_WRITE_MFVec3f, lun, tag, col/255.
   ENDELSE

END

PRO VRML_WRITE_MFFloat, lun, tag, val
   ; val should be n-element array of floats
   
   PRINTF, lun, tag, ' ['
   n = N_ELEMENTS(val)
   PRINTF, lun, val, Format = '((F,:,","))'
   PRINTF, lun, ']'

END

PRO VRML_WRITE_MFLong, lun, tag, val
   ; val should be n-element array of Long Ints
   
   PRINTF, lun, tag, ' ['
   n = N_ELEMENTS(val)
   PRINTF, lun, val, Format = '(5(I,:,",",$))'
   PRINTF, lun,']'

END

PRO VRML_WRITE_Transform, lun, transform
   ; transform should be 4x4 matrix
   PRINTF, lun, 'MatrixTransform { matrix ', TRANSPOSE(transform), ' }'
END         

PRO VRML_WRITE_Material, lun, $
                         AmbientColor=kamb, Diffusecolor = kdiff, $
                         EmissiveColor = color, Transparency = ktran, $
                         SpecularColor = kspec, shininess = ns
   
; AmbientColor - A (3,n) array of RGB colors.  If just n-element array, taken
;          to be Greyscale.  In range of 0...255
; DiffuseColor - A (3,n) array of RGB colors.  If just n-element array, taken
;          to be Greyscale.  In range of 0...255
; EmissiveColor - A (3,n) array of RGB colors.  If just n-element array, taken
;          to be Greyscale.  In range of 0...255
; Transparency - Scalar transparency factor.  In range of 0...255
; SpecularColor - A (3,n) array of RGB colors.  If just n-element array, taken
;          to be Greyscale.  In range of 0...255
; Shininess - Scalar shininess factor.  In range of 0...255

   PRINTF, lun, 'Material {'
   
   IF N_ELEMENTS(kamb) NE 0 THEN $
     VRML_WRITE_MFColor, lun, 'ambientColor', kamb
   
   IF N_ELEMENTS(kdiff) NE 0 THEN $
     VRML_WRITE_MFColor, lun, 'diffuseColor', kdiff

   IF N_ELEMENTS(color) NE 0 THEN $
     VRML_WRITE_MFColor, lun, 'emissiveColor', color
   
   IF N_ELEMENTS(ktran) NE 0 THEN $
     VRML_WRITE_MFFloat, lun, 'transparency', ktran/255.
   
   IF N_ELEMENTS(kspec) NE 0 THEN $
     VRML_WRITE_MFColor, lun, 'specularColor', kspec
   
   IF N_ELEMENTS(ns) NE 0 THEN $
     VRML_WRITE_MFFloat, lun, 'shininess', ns/255.
   
   PRINTF, lun, '}'   ; Material
END

PRO VRML_WRITE_Texture, lun, image

   IF N_ELEMENTS(image) EQ 0 THEN BEGIN
      ; no image - just reset to default texturing
      PRINTF, lun, 'Texture2 { }'
      RETURN
   ENDIF

   PRINTF, lun, 'Texture2 { wrapS CLAMP wrapT CLAMP'

; image is either a (w,h) or a (c,w,h) image - greyscale or true color
; Range 0...255

   dims = SIZE(image, /Dimensions)
   ndims = SIZE(image, /NDim)

   IF ndims EQ 2 THEN BEGIN
      dims = [ 1L, dims ]
      img = image
   ENDIF ELSE BEGIN
      img = REFORM(LONG(image(0,*,*)))
      FOR i=1, dims(0)-1 DO BEGIN
         img = img * 256L + image(i,*,*)
      ENDFOR
   ENDELSE

   PRINTF, lun, 'image ', dims(1), dims(2), dims(0)
   PRINTF, lun, img

   PRINTF, lun, '}'  ; Texture2

END

;;;;;;;;;;;;;;;;;;;;;;;;;;;;; MAIN ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

PRO VRML_OPEN, lun, Get_Lun=get_lun, filename, $
               Comment=comment

   ON_ERROR,2

   IF NOT PARAM_PRESENT(wrl_file) THEN wrl_file = 'wave.wrl'

   OPENW, lun, Get_Lun=get_lun, filename
   
   PRINTF, lun, '#VRML V1.0 ascii'
   PRINTF, lun, ''
   PRINTF, lun, 'Info { string "Written by PV-WAVE  '+ SYSTIME() +'" }'

   IF N_ELEMENTS(comment) NE 0 THEN $
     PRINTF, lun, 'Info { string "' + STRSUBST(comment,'"','\\"') +'" }'

END
