PRO VRML_LINE, lun, x, y, z, $st, $
                         Transform=Transform, $
                         AmbientColor=kamb, Diffusecolor = kdiff, $
                         EmissiveColor = color, Transparency = ktran, $
                         SpecularColor = kspec, shininess = ns, $
                         MaterialIndices=materialindices

; x,y,z - Coordinates of the polyline.  Z is optional and defaults to 0
; Transform - A (4,4) matrix (as in !P.T) containing the transform to 
; AmbientColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; DiffuseColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; EmissiveColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; Transparency - An n-element array of transparency.  In range of 0...255
; SpecularColor - A (3,n) array of RGB color.  If n-element, taken 
;          to be Greyscale.  In range of 0...255
; Shininess - An n-element array of shininess factor.  In range of 0...255
; MaterialIndices - An NPOLY array of indices into above material property 
;          arrays in range 0...n-1.  Defaults to the case for n==NPOLY

   ON_ERROR,2
   
   PRINTF, lun, 'Separator {'

   IF N_ELEMENTS(transform) EQ 16 THEN $
     VRML_WRITE_Transform, lun, transform
               
   VRML_WRITE_Material, lun, $
                   AmbientColor=kamb, Diffusecolor = kdiff, $
                   EmissiveColor = color, Transparency = ktran, $
                   SpecularColor = kspec, shininess = ns

   materialbinding = 'PER_VERTEX'

   IF N_ELEMENTS(materialindices) NE 0 THEN BEGIN
      materialbinding = materialbinding + '_INDEXED'
   ENDIF
   
   PRINTF, lun, 'MaterialBinding { value ', materialbinding, ' }'

   n = N_ELEMENTS(x)
   IF NOT PARAM_PRESENT(z) THEN $
     z = FLTARR(n)

   IF N_ELEMENTS(y) NE n OR N_ELEMENTS(z) NE n THEN $
     MESSAGE, 'Unequal number of x, y, z points'

   vlist = TRANSPOSE( [ [x],[y],[z] ] )

   ; Coordinates - the polyline Vertices

   PRINTF, lun, 'Coordinate3 {'
   VRML_WRITE_MFVec3f, lun, 'point', vlist
   PRINTF, lun, '}' ; Coordinate3

   vlist=0  ; free memory

   PRINTF, lun, 'IndexedLineSet {'

   VRML_WRITE_MFLong, lun, 'coordIndex', LINDGEN(n)

   IF N_ELEMENTS(materialindices) NE 0 THEN $
     VRML_WRITE_MFLong, lun, 'materialIndex', materialindices

   PRINTF, lun, '}' ; IndexedLineSet

   ; Reset to defaults

   PRINTF, lun, 'MaterialBinding { value DEFAULT }'

   PRINTF, lun, '}' ; Separator - end of Object

END
