PRO VRML_LIGHT, lun, position, $
               Color=color, Intensity=intens

; position - Position of the point light
; Color - 3-element array of RGB light color in range 0...255
;         Defaults to white
; Intensity - Light intensity in range 0...1 Default 1

   ON_ERROR,2

   IF N_ELEMENTS(position) NE 3 THEN MESSAGE, 'Bad position'

   PRINTF, lun, 'PointLight { location ', position

   IF N_ELEMENTS(color) EQ 3 THEN $
     PRINTF, lun, 'color ', color/255.

   IF N_ELEMENTS(intens) NE 0 THEN $
     PRINTF, lun, 'intensity ', intens

   PRINTF, lun, '}'

END
