PRO VRML_CUBE, lun,      Center=center, Widths=widths, Rotation=rotation, $
                         Transform=Transform, $
                         Texture_Image=texture_image, $
                         AmbientColor=kamb, Diffusecolor = kdiff, $
                         EmissiveColor = color, Transparency = ktran, $
                         SpecularColor = kspec, shininess = ns

; Widths - Cube widths - either a scalar (a cube) or a 3-element array 
;          of widths in (x,y,z).   Default is 2.0
; Rotation - A 3-element array of rotations about (x,y,z) in Degrees.
;          Rotations are performed in order X, Y, Z.
; Center - 3-element (x,y,z) array with the center of the object.  
;          Default is [0,0,0]
; Transform - A (4,4) matrix (as in !P.T) containing the transform to 
;          apply to the object.  Applied after Center and Rotation
; Texture_Image - A Texture image to apply to the object.
;          Four options:
;             (w,h) or (1,w,h) - Greyscale image
;             (2,w,h) - Greyscale in (0,*,*) plus transparency in (1,*,*)
;             (3,w,h) - True color image (red, green, blue)
;             (4,w,h) - True Color plus transparency in (3,*,*)
;          Image is wrapped copmpletely around object (CLAMPed)
;          Image values and Transparencies lie in range of 0...255
; AmbientColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; DiffuseColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; EmissiveColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; Transparency - Scalar transparency factor.  In range of 0...255
; SpecularColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; Shininess - Scalar shininess factor.  In range of 0...255
   
   ON_ERROR,2

   PRINTF, lun, 'Separator {'

   IF N_ELEMENTS(transform) EQ 16 THEN $
     VRML_WRITE_Transform, lun, transform
               
   IF N_ELEMENTS(center) EQ 3 THEN $
     PRINTF, lun, 'Translation { translation ', center, ' }'

   IF N_ELEMENTS(rotation) EQ 3 THEN BEGIN
      PRINTF, lun, 'Rotation { rotation  1 0 0 ', rotation(0) *!Dtor, ' }'
      PRINTF, lun, 'Rotation { rotation  0 1 0 ', rotation(1) *!Dtor, ' }'
      PRINTF, lun, 'Rotation { rotation  0 0 1 ', rotation(2) *!Dtor, ' }'
   ENDIF

   VRML_WRITE_Texture, lun, texture_image

   VRML_WRITE_Material, lun, $
                   AmbientColor=kamb, Diffusecolor = kdiff, $
                   EmissiveColor = color, Transparency = ktran, $
                   SpecularColor = kspec, shininess = ns

   CASE N_ELEMENTS(widths) OF
     1:  sz = [ widths, widths, widths ]
     3:  sz = widths
     ELSE:  sz = [ 2., 2., 2. ]
   ENDCASE

   PRINTF, lun, 'Cube { width ', sz(0), ' height ', sz(1), ' depth ', sz(2), ' }'

   PRINTF, lun, '}' ; Separator - end of Object

END
