PRO VRML_CONE, lun,      Center=center, Radius=radius, Height=height, $
                         Orientation=orient, $
                         Transform=Transform, $
                         Texture_Image=texture_image, $
                         AmbientColor=kamb, Diffusecolor = kdiff, $
                         EmissiveColor = color, Transparency = ktran, $
                         SpecularColor = kspec, shininess = ns

; Radius - Cone radius.  Default is 1.0
; Height - Cone height.  Default is 2.0
; Orientation - A 3-element vector specifying the orientation of 
;          the cone (in the direction of the apex).   Default 
;          orientation is with the cone axis along Y, with apex at +Y.
; Center - 3-element (x,y,z) array with the center of the object.  
;          Default is [0,0,0]
; Transform - A (4,4) matrix (as in !P.T) containing the transform to 
;          apply to the object.
; Texture_Image - A Texture image to apply to the object.
;          Four options:
;             (w,h) or (1,w,h) - Greyscale image
;             (2,w,h) - Greyscale in (0,*,*) plus transparency in (1,*,*)
;             (3,w,h) - True color image (red, green, blue)
;             (4,w,h) - True Color plus transparency in (3,*,*)
;          Image is wrapped copmpletely around object (CLAMPed)
;          Image values and Transparencies lie in range of 0...255
; AmbientColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; DiffuseColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; EmissiveColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; Transparency - Scalar transparency factor.  In range of 0...255
; SpecularColor - A 3-element array of RGB color.  If scalar, taken 
;          to be Greyscale.  In range of 0...255
; Shininess - Scalar shininess factor.  In range of 0...255
   
   ON_ERROR,2

   PRINTF, lun, 'Separator {'

   IF N_ELEMENTS(transform) EQ 16 THEN $
     VRML_WRITE_Transform, lun, transform
               
   IF N_ELEMENTS(center) EQ 3 THEN $
     PRINTF, lun, 'Translation { translation ', center, ' }'

   IF N_ELEMENTS(orient) EQ 3 THEN BEGIN
      ; rotation angle is dot product of normalized orient with y-axis
      ; Axis of rotation is cross product of y-axis with orient

      align = [0.,1.,0.]   ; alignment of object - must be a unit vector
      ang = ACOS( TOTAL( align * orient / SQRT( TOTAL( orient^2 ) ) ) )
      axis = CROSSP( align, orient ) 
      PRINTF, lun, 'Rotation { rotation ', axis, ang, ' }'
   ENDIF

   VRML_WRITE_Texture, lun, texture_image

   VRML_WRITE_Material, lun, $
                   AmbientColor=kamb, Diffusecolor = kdiff, $
                   EmissiveColor = color, Transparency = ktran, $
                   SpecularColor = kspec, shininess = ns

   IF N_ELEMENTS(radius) EQ 0 THEN radius=1.0
   IF N_ELEMENTS(height) EQ 0 THEN height=2.0

   PRINTF, lun, 'Cone { bottomRadius ', radius(0), ' height ', height(0), ' }'

   PRINTF, lun, '}' ; Separator - end of Object

END
