PRO VRML_CAMERA, lun, position, $
               LookAt=lookat, ViewAngle=viewang, FocalLength=focal

; position - position of the camera
; LookAt - 3-element array (x,y,z) of a location to look at.  Used to 
;          calculate the camera orientation.  Defaults to 0,0,0
; ViewAngle - The viewing angle (field of view)  in degrees  Default 45
; FocalLength - Camera focal length.  Default 5

   ON_ERROR,2

   IF N_ELEMENTS(position) NE 3 THEN MESSAGE, 'Bad position'

   PRINTF, lun, 'PerspectiveCamera { position ', position

   IF N_ELEMENTS(viewang) NE 0 THEN $
     PRINTF, lun, 'heightAngle ', viewang(0) *!Dtor

   IF N_ELEMENTS(focal) NE 0 THEN $
     PRINTF, lun, 'focalDistance ', focal(0)

   IF N_ELEMENTS(lookat) NE 3 THEN $
        lookat = [0.,0.,0.]

   ; LookAt is a location to look at - so calculate the orientation

   align = [0.,0.,-1.]   ; alignment of object - must be a unit vector

   orient = lookat - position
   ang = ACOS( TOTAL( align * orient / SQRT( TOTAL( orient^2 ) ) ) )
   axis = CROSSP( align, orient )

   PRINTF, lun, 'orientation ', axis, ang, ' }'

END
