pro xplot, indx, colr, lines, x=xflag, y=yflag, z=zflag
COMMON vrml_axes_common, xr, yr, zr, t3d, tx, ty, tz
set_plot,'x'

!P.T = t3d
!P.T3D = 1
!X = tx
!Y = ty
!Z = tz
colr(WHERE(colr EQ 1)) = 255

IF KEYWORD_SET(xflag) THEN BEGIN
   lines(*,0) = (xr(1)-xr(0))*1.25*(lines(*,0)-0.1)+xr(0)

   lines(*,1) = lines(*,1) - 0.1
   miny = lines(0,1)
   lines(*,1) = lines(*,1) * (!Y.CRANGE(1)-!Y.CRANGE(0)) 
   lines(*,1) = lines(*,1) + (miny - lines(0,1))
ENDIF

IF KEYWORD_SET(yflag) THEN BEGIN
   lines(*,0) = lines(*,0) - 0.1
   minx = lines(0,0)
   lines(*,0) = lines(*,0) * (!X.CRANGE(1)-!X.CRANGE(0))
   lines(*,0) = lines(*,0) + (minx - lines(0,0))

   lines(*,1) = (yr(1)-yr(0))*1.25*(lines(*,1)-0.1)+yr(0)
ENDIF

IF KEYWORD_SET(zflag) THEN BEGIN
   lines(*,0) = lines(*,0) - 0.1
   minx = lines(0,0)
   lines(*,0) = lines(*,0) * (!X.CRANGE(1)-!X.CRANGE(0))
   lines(*,0) = lines(*,0) + (minx - lines(0,0))

   lines(*,1) = (zr(1)-zr(0))*1.25*(lines(*,1)-0.1)+zr(0)
ENDIF

FOR i=0,N_ELEMENTS(indx)-2 DO BEGIN
   IF KEYWORD_SET(zflag) THEN BEGIN
      x = lines(indx(i):indx(i+1)-1, 0)
      y = REPLICATE(!Y.CRANGE(1), N_ELEMENTS(x))
      z = lines(indx(i):indx(i+1)-1, 1)
      PLOTS, x, y, z, Color = colr(i)
   ENDIF ELSE BEGIN
      x = lines(indx(i):indx(i+1)-1, 0)
      y = lines(indx(i):indx(i+1)-1, 1)
      z = REPLICATE(!Z.CRANGE(0), N_ELEMENTS(x))
      PLOTS, x, y, z, Color = colr(i)
   ENDELSE

ENDFOR
!P.T3D = 0

empty
set_plot,'hp'
end


PRO VRML_AXES, data, ax=ax, az=az
COMMON vrml_axes_common, xr, yr, zr, t3d, tx, ty, tz

IF N_ELEMENTS(ax) EQ 0 THEN ax = 40
IF N_ELEMENTS(az) EQ 0 THEN az = 40

data = dist(4)
set_plot,'x'
window,xsize=500,ysize=500
tek_color

SET_PLOT, 'HP'
s = 9.8425196
device,file='temp.hp',xoff=0,yoff=0,xsize=s,ysize=s,/inch

SURFACE, data, /NODATA, /SAVE, ax=ax, az=az
xr  = !X.CRANGE
yr  = !Y.CRANGE
zr  = !Z.CRANGE
tx = !X
ty = !Y
tz = !Z
t3d = !P.t
!P.T3D = 0
DEVICE, /CLOSE

!P.CHARSIZE=1.5

; X Axes
SET_PLOT, 'HP'
device,file='temp.hp',xoff=0,yoff=0,xsize=s,ysize=s,/inch
PLOT,[0,1],/nodata,ystyle=4,xstyle=8,xrange=xr,position=[.1,.1,.9,.9]
EMPTY
DEVICE, /CLOSE
ParseLines,'temp.hp', indx, colr, lines
xplot, indx, colr, lines, /X

; Y Axes
SET_PLOT, 'HP'
device,file='temp.hp',xoff=0,yoff=0,xsize=s,ysize=s,/inch
PLOT,[0,1],/nodata,xstyle=4,ystyle=8,yrange=yr,position=[.1,.1,.9,.9]
EMPTY
DEVICE, /CLOSE
ParseLines,'temp.hp', indx, colr, lines
xplot, indx, colr, lines, /Y

; Z Axes
SET_PLOT, 'HP'
device,file='temp.hp',xoff=0,yoff=0,xsize=s,ysize=s,/inch
PLOT,[0,1],/nodata,xstyle=4,ystyle=8,yrange=zr,position=[.1,.1,.9,.9]
EMPTY
DEVICE, /CLOSE
ParseLines,'temp.hp', indx, colr, lines
xplot, indx, colr, lines, /Z

set_plot,'x'
SURFACE, data, /NODATA, /SAVE, ax=ax, az=az, color=2, /noerase
END
