; $Id: pie_chart2.pro,v 1.1 1993/05/27 13:52:58 sue Exp $
;+
; NAME: COMP_ARC
;
; PURPOSE: For a given center,radius,angle and number of steps compute 
;	   the points to draw the coressponding arc.
;
; CATEGORY: Business
;
; CALLING SEQUENCE:
;   arc = COMP_ARC (Xcent,Ycent,Radius,N_sides,Begin_ang,Angle)
;
; INPUTS:
; 	Xcent ,	Ycent	flt	: coordinates of the center of the arc
;	Radius		flt	: radius of the arc
;	N_sides		int 	: number of facettes of the arc
;	Begin_ang	flt	: start angle in radian
;	Angle		flt	: value angle in radian
;
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	arc	flt((N_sides+1)(2)   : x,y coordinates that describes the arc
;
; MODIFICATION HISTORY:
;      Original version: F Briandet, PVI France, October 1992
;-
FUNCTION COMP_ARC,Xcent,Ycent,Radius,N_sides,Begin_ang,Angle
;
sides = dblarr(n_sides + 1,2) ; Create x,y coordinate array for vertices.
; 
cur_angle = double(begin_ang)
angle_inc = angle/double(n_sides)
xc = double(xcent)
yc = double(ycent)
r1 = double(radius)
FOR index = 0, n_sides DO BEGIN ; Create the arc.
   sides(index,0) = xc + (r1 * (COS(cur_angle))) ; X coord. 
   sides(index,1) = yc + (r1 * (SIN(cur_angle))) ; Y coord.  
   cur_angle = angle_inc + cur_angle ; Move on to next vertex.
ENDFOR
;
RETURN ,sides
END 
; 
;----------------------------------------------------------------------------
PRO PIE_CHART2 , Data, Xcentre,Ycentre,Radius,device=device, $
    label=tlabel,font=tfont,tposition=tposition,tcolor=tcolor,tperct=tperct, $
    tvalue=tvalue,tborder=tborder,tbord_color=tborder_color,shade=pshade,$
    color=pcolor,explode=pexplode,charsize=tcharsize
;+
; NAME: PIE_CHART2
;
; PURPOSE: Draw a Pie_chart at specified position (normal or device)
;	   whith colors and text labels
;	   support also exploded slices and shadows
;
; CATEGORY: Business
;
; CALLING SEQUENCE:
;   PIE_CHART2 , Data, Xcentre,Ycentre,Radius, $
;   device=device,label=tlabel,font=tfont,tposition=tposition,tcolor=tcolor, $
;   tperct=tperct,tvalue=tvalue,tborder=tborder,tbord_color=tborder_color, $
;   shade=pshade,color=pcolor, explode=pexplode,charsize=tcharsize
;
; INPUTS:
;	Data [n_vals]: 	array of datas to be display as a pie_chart
;			( 30 values maxi. < 15 recommanded)
;	Xcentre,Ycentre : position of the center of the pie	
;			  (normal coordinates by default)
;	Radius :	size of the radius of the pie 
;			(normal coordinates by default)
;
; KEYWORD PARAMETERS:
;	device (0/1)	: using device coordinates (def: normal)
;	label  str[n_vals] : text label associated to each slice (def : none)
;	font   str 	: font to use for the labels (def: current)
;       charsize flt		: size of the labels (def : !P.charsize)
;	tposition  int[n_vals]	: position of the labels
;			  	  0 : intern, 1 : extern, 2 : extern align
;				  (def : 1 = extern)
;	tcolor  int[n_vals]	: color for the label of each slice
;	tperct  (0/1)	: display the % of each slice  (def: no display)
;	tvalue  (0/1)	: display the value of each slice  (def: no display)
;	tborder  (0/1)	: display a border around the label (def: no border)
;	tbord_color  	: color index for the label border (def: current color)
;	shade  flt	: display a shade under the pie_chart (def : 0.)
;			  specifie the % of displacement for the center of the
;			  shadow pie (direction is 315 degree)
;	color  int[n_vals]	: color index for each part	
;	explode	flt[n_vals]	: % of explode  for each slice (def : no expl )
;
; EXAMPLE:
;	data = fltarr(4)
;	data(0) = 32
;	data(1) = 22
;	data(2) = 11
;	data(3) = 35
;	; creating labels
;	strg = strarr(4)
;	strg(0)='Renault'
;	strg(1)='Peugeot'
;	strg(2)='Citroen'
;	strg(3)='Others'
;	title = '!18French automobile market shares'
;	; Create the window
;	window,/free,xsize=800,ysize=800
;	; Initialize a white background
;	loadct,13
;	!p.color=0
;	!p.background=!d.n_colors-1
;	erase,!P.background
;	; plot the chart
;	pie_chart2,data,.5,.5,.25,/tperc,explode=[.05,0,0,.1],shade=0.04, $
;	tpos=[1,1,1,1],/tborder,color=[60,120,140,200],label=strg,font='3',$
;	charsize=1.5
;	xyouts , .5,.9,title,charsize=3,charthick=2,align=.5,/normal,color=0
;
; RESTRICTIONS:
;	Display only 30 values maxi 
;	If the part is to small do not display the associated label
;	Datas representing less than 0.1 % of the whole are not displayed
;	(an informational message is then displayed)
;
; MODIFICATION HISTORY:
;      Original version: F Briandet, PVI France, October 1992
;-
; If error return to caller
on_error,2
; 
; test if input parameters are all there and valid
IF n_params() ne 4 THEN message,'Invalid number of arguments'
d_size = size(data)
IF d_size(0) ne 1 THEN message,'DATA argument must be 1 dimension array'
IF d_size(1) GT 30 THEN message ,'more then 30 elements in DATA'
;
; compute the number of slices
nb_slices =  d_size(1)
;
; Initialize some constants
cur_color = !P.color;
back_color = !P.background
step_p_deg = 3			; number of step to draw a degree
ex_min = .001			; value to be exclude if < to given %
shade_angle = 7. * !pi / 4.	; angle of the shadow ceter (315 degree)
nb_lab_elt = 0			; number of elements in a label
lab_dist = .1			; distance of the label to the pie
tick_size = .2			; size of the tickmark for an external label
; test the keywords
IF n_elements(pcolor) eq 0 THEN pcolor = indgen(nb_slices)+2 $
ELSE $
    IF (size(pcolor))(1) ne nb_slices THEN $
	message,'COLOR integer array must be the same size as DATA'  
IF n_elements(pexplode) eq 0 THEN pexplode = fltarr(nb_slices) $
ELSE $
    IF ((size(pexplode))(1) gt nb_slices) OR (max(pexplode) GT 1.) $
    THEN $
	message,'EXPLODE float array greater then DATA or explode factor greater then 1.'  
IF n_elements(pshade) eq 0 THEN pshade = 0. $
ELSE $
    IF (pshade lt 0.) OR (pshade GT 1.) $
    THEN $
        message,'SHADE float value smaller then 0. or greater then 1.'  $
     ELSE $
     BEGIN	; compute the offset to draw the shadow
        junk_var = comp_arc(xcentre,ycentre,radius*pshade,1,shade_angle,0.)
        x_shade_delta = junk_var(0,0) - xcentre  
        y_shade_delta = junk_var(0,1) - ycentre 
     ENDELSE
;
IF n_elements(tlabel) eq 0 THEN tlabel_bool = 0 $
ELSE BEGIN
    IF (size(tlabel))(1) ne nb_slices THEN $
	message,'LABEL string array must be the same size as DATA'  $
    ELSE $
    BEGIN
         tlabel_bool = 1
         nb_lab_elt = nb_lab_elt + 1
    ENDELSE
ENDELSE
IF n_elements(tperct) eq 0 THEN tperct = 0 $
ELSE nb_lab_elt = nb_lab_elt + 1
IF n_elements(tvalue) eq 0 THEN tvalue = 0 $
ELSE nb_lab_elt = nb_lab_elt + 1
;    if some test display requested, test the text relative keywords
IF (nb_lab_elt GT 0) THEN $
BEGIN
    IF n_elements(tfont) eq 0 THEN tfont = ''
    IF n_elements(tcharsize) eq 0 THEN tcharsize=(!P.charsize > 1.)
    IF n_elements(tposition) eq 0 THEN tposition = intarr(nb_slices) + 1 $
    ELSE $
        IF (size(tposition))(1) ne nb_slices THEN $
  	   message,'TPOSITION integer array must be the same size as DATA'
    IF n_elements(tcolor) eq 0 THEN tcolor = intarr(nb_slices) + cur_color $
    ELSE $
        IF (size(tcolor))(1) ne nb_slices THEN $
   	   message,'TCOLOR integer array must be the same size as DATA' 
    IF n_elements(tborder) eq 0 THEN tborder = 0
    IF n_elements(tborder_color) eq 0 THEN tborder_color = cur_color
ENDIF
IF n_elements(device) eq 0 THEN $
BEGIN 
    device = 0
    normal = 1
    label_high = !D.y_ch_size * tcharsize / float (!D.y_size)
ENDIF ELSE $
BEGIN
    normal = 0
    label_high = !D.y_ch_size * tcharsize 
ENDELSE;
;  Compute the total size ,the % ,the global geometry of each slice
;  Compute the label angle,position of each slice
tt = double(total(data))
percent = fltarr(nb_slices)
; label parameters
label_angle = fltarr(nb_slices)
label_align = fltarr(nb_slices)
label_pos_x = fltarr(nb_slices)
label_pos_y = fltarr(nb_slices)
label_tickm_x = fltarr(nb_slices,3)
label_tickm_y = fltarr(nb_slices,3)
; parameters to store the geomtry of the slices
path_index = intarr(nb_slices,2)
x_path=dblarr(1)
y_path=dblarr(1)
i_start_path=1
;
begin_angle = 0.
cumul_angle = 0
FOR i=0, (nb_slices-1) DO $
BEGIN 
     percent(i) = float(data(i)/tt)	; percent of each slice
     angle = 2.*!pi * percent(i)+cumul_angle	; angle of each slice
     ; eliminate the too small values
     IF ( percent(i) le ex_min ) THEN BEGIN	
         junk_var= 'Value '+strtrim(string(data(i)),2)+' at index('+ $
		     strtrim(string(i),2)+') to small to be displayed'
         message,junk_var,/info
         cumul_angle = angle  
     ENDIF ELSE $
     BEGIN
         cumul_angle = 0.
         nb_step = fix(360. * step_p_deg * percent(i))
         label_angle(i) = begin_angle+(angle/2)
         ; compute the exploded center if one
         IF (pexplode(i) NE 0.) THEN $
         BEGIN		
             junk_var = comp_arc(xcentre,ycentre,radius*pexplode(i),1,label_angle(i),0.)
             xc = junk_var(0,0)
             yc = junk_var(0,1)
	     ; explode center using given % of the radius
         ENDIF ELSE $
         BEGIN
            xc = xcentre & yc = ycentre
         ENDELSE
         ; compute the shape of the slice
         junk_var = comp_arc(xc,yc,radius,nb_step,begin_angle, angle)     
	 ;
	 ; store the geometry of the slices 
         path_index(i,0) = i_start_path
         x_path = [x_path,xc,junk_var(*,0),xc] 
         y_path = [y_path,yc,junk_var(*,1),yc] 
         i_start_path = i_start_path + (size(junk_var))(1)+2
         path_index(i,1) = i_start_path - 1
         ;
         ; compute the label thick (extern) and the label position
         IF (nb_lab_elt GT 0) THEN $
         BEGIN
            CASE tposition(i) OF
            0 : BEGIN		; internal position 
                   label_tickm_x(i,*) = 0
                   label_tickm_y(i,*) = 0
                   r_pos = 1.-tick_size
                   junk_var = comp_arc(xc,yc,radius*r_pos,1,label_angle(i),0.)
                   label_pos_x(i) = junk_var(0,0)
                   label_pos_y(i) = junk_var(0,1)
                   ; compute the alignement
	           label_align(i) = abs((cos(label_angle(i)) + 1) /2.)
		   ;compute the global offset for the whole text block	
                   junk_var = ((label_high * nb_lab_elt)/2.) * sin(label_angle(i))
		   ; compute the offset inside the text block 
                   junk_var = junk_var + ((label_high * (nb_lab_elt-2))/2.)
                   END
            1 : BEGIN		; external position 
                   r_pos = 1.+lab_dist
                   junk_var = comp_arc(xc,yc,radius*r_pos,1,label_angle(i),0.)
                   label_tickm_x(i,0) = junk_var(0,0)
                   label_tickm_y(i,0) = junk_var(0,1)
                   r_pos = r_pos + tick_size
                   junk_var = comp_arc(xc,yc,radius*r_pos,1,label_angle(i),0.)
                   label_tickm_x(i,1:2) = junk_var(0,0)
                   label_tickm_y(i,1:2) = junk_var(0,1)
                   r_pos = r_pos + lab_dist
                   junk_var = comp_arc(xc,yc,radius*r_pos,1,label_angle(i),0.)
                   label_pos_x(i) = junk_var(0,0)
                   label_pos_y(i) = junk_var(0,1)
                   ; compute the alignement
	           label_align(i) = abs((cos(label_angle(i)) - 1.) /2.)
		   ;compute the global offset for the whole text block	
                   junk_var = ((label_high * nb_lab_elt)/2.) * sin(label_angle(i))
		   ; compute the offset inside the text block 
                   junk_var = junk_var + ((label_high * (nb_lab_elt-2))/2.)
                   label_pos_y(i) = label_pos_y(i) + junk_var 
                END
            2 : BEGIN		; external aligned position
                   r_pos = 1.+lab_dist
                   junk_var = comp_arc(xc,yc,radius*r_pos,1,label_angle(i),0.)
                   label_tickm_x(i,0) = junk_var(0,0)
                   label_tickm_y(i,0) = junk_var(0,1)
                   r_pos = r_pos + tick_size
                   junk_var = comp_arc(xc,yc,radius*r_pos,1,label_angle(i),0.)
                   label_tickm_x(i,1) = junk_var(0,0)
                   label_tickm_y(i,1:2) = junk_var(0,1)
                   r_pos = r_pos + (2. * lab_dist)
                   junk_var = comp_arc(xc,yc,radius*r_pos,1,0.,!PI)
                   IF ( cos(label_angle(i)) LE 0.) THEN $
                   BEGIN
                      label_tickm_x(i,2) = junk_var(1,0) 
                      label_pos_x(i) = label_tickm_x(i,2) - (radius * lab_dist)
	              label_align(i) = 1.
                   ENDIF ELSE $
                   BEGIN
                      label_tickm_x(i,2) = junk_var(0,0) 
                      label_pos_x(i) = label_tickm_x(i,2) + (radius * lab_dist)
	              label_align(i) = 0.
                   ENDELSE
                   label_pos_y(i) = label_tickm_y(i,2) + ((label_high * (nb_lab_elt-2))/2.)
                END
            ENDCASE    
         ENDIF
         ;
         ; increment the angle  
         begin_angle = begin_angle + angle
     ENDELSE
ENDFOR


;
;	Draw the pie chart	
;plot the shadow if requested
IF (pshade NE 0.) THEN $
   FOR i=0, (nb_slices-1) DO $
   BEGIN
       IF ( percent(i) gt ex_min ) THEN $
       BEGIN	
           bi=path_index(i,0)
           ei=path_index(i,1)
           POLYFILL,x_path(bi:ei)+x_shade_delta,y_path(bi:ei)+y_shade_delta,  $
                     color=cur_color,device=device,normal=normal
       ENDIF
    ENDFOR
; plot the slice
FOR i=0, (nb_slices-1) DO $
BEGIN
   IF ( percent(i) gt ex_min ) THEN $
   BEGIN	
       bi=path_index(i,0)
       ei=path_index(i,1)
      
POLYFILL,x_path(bi:ei),y_path(bi:ei),color=pcolor(i),device=device,normal=normal
       PLOTS,x_path(bi:ei),y_path(bi:ei),color=cur_color,device=device,normal=normal
   ENDIF 
ENDFOR
; plot the labels
IF (nb_lab_elt GT 0) THEN $
BEGIN
    IF ( tfont NE '' ) THEN xyouts,0,0,'!'+strtrim(string(tfont),2),/dev
    FOR i=0, (nb_slices-1) DO $
    BEGIN
        IF ( percent(i) gt ex_min ) THEN $
        BEGIN
            PLOTS,label_tickm_x(i,*),label_tickm_y(i,*),color=cur_color, $
                  device=device,normal=normal
            r_pos = label_pos_y(i)
            bord_width = 0
            IF ( tlabel_bool NE 0 ) THEN $
            BEGIN
               XYOUTS,label_pos_x(i), r_pos,tlabel(i),color=tcolor(i),$
                    device=device,normal=normal,align = label_align(i),$
                     charsize=tcharsize,width=width
               bord_width = bord_width > width    
               r_pos = r_pos - label_high
            ENDIF
            IF ( tvalue NE 0 ) THEN $
            BEGIN
               XYOUTS,label_pos_x(i), r_pos,strtrim(string(data(i)),2), $
                      color=tcolor(i),device=device,normal=normal, $
                      align=label_align(i), charsize=tcharsize,width = width
               bord_width = bord_width > width    
               r_pos = r_pos - label_high
            ENDIF
            IF ( tperct NE 0 ) THEN $
	    BEGIN
                XYOUTS,label_pos_x(i), r_pos, $
                      strtrim(string((100. * percent(i)),format='(F5.2)'),2)+'%', $
                      color=tcolor(i),device=device,normal=normal, $
                      align = label_align(i), charsize=tcharsize,width = width
                bord_width = bord_width > width    
            ENDIF
            ; plot a border around the labels if requested
            IF (tborder NE 0) THEN $
            BEGIN
                xyouts,0,0,' ',/dev,charsize=tcharsize,width=white_sp
		bord_width = bord_width +  (2. * white_sp ) 
                IF device NE 0 THEN $
                BEGIN
                    bord_width = bord_width * !D.x_size
                    white_sp = white_sp * !D.x_size
                ENDIF
                IF label_align(i) GT .5 THEN $
		   bord_or = label_pos_x(i) + white_sp $
                ELSE $
                   bord_or = label_pos_x(i) - white_sp 
                x_border = [bord_or,bord_or+bord_width,bord_or+bord_width, $
                           bord_or, bord_or]
                x_border = x_border -(bord_width * label_align(i)) 
                bord_high = label_pos_y(i) + label_high
                r_pos = r_pos - (label_high/2.)
                y_border = [r_pos,r_pos,bord_high,bord_high,r_pos]
                POLYFILL,x_border,y_border,color=back_color,device=device, $
                         normal=normal
                PLOTS,x_border,y_border,color=tborder_color,device=device, $
                         normal=normal
                ; replot the label in the border
                r_pos = label_pos_y(i)
                IF ( tlabel_bool NE 0 ) THEN $
                BEGIN
                   XYOUTS,label_pos_x(i), r_pos,tlabel(i),color=tcolor(i),$
                   
device=device,normal=normal,charsize=tcharsize,align = label_align(i)
                   r_pos = r_pos - label_high
                ENDIF
                IF ( tvalue NE 0 ) THEN $
                BEGIN
                   XYOUTS,label_pos_x(i), r_pos,strtrim(string(data(i)),2), $
                      color=tcolor(i),device=device,normal=normal, $
                      charsize=tcharsize,align=label_align(i)
                   r_pos = r_pos - label_high
                ENDIF
                IF ( tperct NE 0 ) THEN $
                   XYOUTS,label_pos_x(i), r_pos, $
                      strtrim(string((100. * percent(i)),format='(F5.2)'),2)+'%', $
                      color=tcolor(i),device=device,normal=normal, $
                      charsize=tcharsize,align = label_align(i)
             ENDIF	
        ENDIF
    ENDFOR
ENDIF

END
