/*                                                
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 *
 * -----------------------------------------------------------------------
 *
 * surfanim.java
 *
 * This demonstration code shows how the JWAVE class WaveSurfAnim can be used
 * to produce animated surface plots of either sample data created within the
 * jave code, or from user provided data.
 *
 * The format for user provided data must be comma separated values, 
 * with any number of values per line.  The data can be in the
 * form of X/Y/Z triplets (the total numer of values must then of 
 * course be divisible by three).  If triplets are used then the 
 * FAST_GRID3 procedure in PV-WAVE will be used to grid them and
 * the resulting 2D grid passed to the SHADE_SURF procedure.
 *
 * The data can also be in the form of a NxM array or grid.  In this case
 * the first two values in the data must represent the number of rows and
 * columns.  For example a 2x3 array of data could look like this:
 *
 *   2, 3, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0 
 *
 * If this code is run as an applet, it will display a scrolled text
 * field in which you can enter your own data.  If the code is run
 * as an application (using the "java" command provided with the 
 * Java JDK from Sun for instance), you instead can enter or browse 
 * for a path/filename containing your data.
 *
 * The JWAVE classes allow you access to all PV-WAVE keyword parameters,
 * and an "Options" dialog is provided in this demo to allow you to 
 * change a few of them.  See the documentation for the JWAVE classes for 
 * complete descriptions of the parameters supported.
 *
 */

import java.io.*;
import netscape.application.*;
import netscape.util.*;
import VisualNumerics.wave.*;

public class surfanim extends Application implements Target {
    
    /** This method gets called to initialize an application. We'll take
      * this opportunity to set up the View hierarchy.
      */
   public void init() {
        super.init();   

   // Change the color of the background view to be the standard
   // application lightGray.
   mainRootView().setColor(Color.lightGray);

   // Plot Title   
   TextField titleField = new TextField(143, 5, 200, 30);
   titleField.setBorder(null);
   titleField.setEditable(false);
   titleField.setBackgroundColor(Color.lightGray);
   titleField.setFont(Font.fontNamed("Helvetica", Font.BOLD, 14));
   titleField.setStringValue("WaveSurfAnim Example");
   mainRootView().addSubview(titleField);

   // Create the Plot component
   surf = new WaveSurfAnim( 125, 40, 200, 150 );
   
   // This demo can be run as both an applet or an application,
   // using either a PV-WAVE based server on the internet,
   // or a local PV-WAVE process with no network communication.
   //
   // When run as an applet, two parameters can be specified in 
   // the <APPLET> tag in the HTML document that starts this applet.  
   // You could use either (but not both) of these parameters:
   //
   //    <PARAM NAME="Server" VALUE="http://vrml.boulder.vni.com.:9000">
   // or
   //    <PARAM NAME="LocalServer" VALUE="C:\java\waveserver">
   //
   // The "Server" parameter specifies the URL of the server
   // which has a "waveserver" script in its cgi-bin directory.
   // Communications with the PV-WAVE graphic server is
   // performed through this cgi script.
   //
   // The "LocalServer" parameter specifies a local directory 
   // which a PV-WAVE process running the "LocalServer" procedure
   // uses to communicate with the applet via files.
   //
   // WHAT THIS ALL MEANS
   // 
   // Here are the two ways you can run this demo as provided:
   //
   // - By using a browser to access the provided HTML file.
   //   This will run the demo as an applet, using our PV-WAVE
   //   server in Boulder, Colorado.  Because an applet can not
   //   read local files on a client, you will not be able to
   //   plot your own data from a file, but for demonstration
   //   purposes you can enter comma separated ASCII data in
   //   a text widget.  You can get the same behavior with
   //   the appletviewer provided with the Java JDK from Sun:
   //
   //      appletviewer bar3d.html
   //
   // - By downloading the JWAVE SDK and running as an application:
   //
   //      java bar3d
   //
   //   This will still use the PV-WAVE server in Boulder, CO,
   //   but you will be able to read comma separated ASCII files
   //   of your own.
   //
   // You can modify the HTML file to use the "LocalServer" parameter
   // instead, so that you do not need a web server or internet 
   // connection to run the demo.  You need to start a PV-WAVE
   // server as a separate process on your machine in order to
   // do this.  See the JWAVE SDK for instructions on configuring
   // and running a local server.
   //      
   
   // Get the parameters from the applet tags
   java.applet.Applet applet = AWTCompatibility.awtApplet();
   String server  = applet.getParameter("Server");
   String lserver = applet.getParameter("LocalServer");

   // Use the parameters if provided else default
   if (server != null) {
      surf.setServer(server);
   } else if (lserver != null) {
      surf.setLocalServer(lserver);
   } else {
      surf.setServer( "http://vrml.boulder.vni.com.:9000" );
   }
         
   mainRootView().addSubview(surf);

   // Slider control
   //TextField sliderField1 = new TextField(25, 340, 90, 20);
   TextField sliderField1 = new TextField(25, 200, 90, 20);
   sliderField1.setBorder(null);
   sliderField1.setEditable(false);
   sliderField1.setBackgroundColor(Color.lightGray);
   sliderField1.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   sliderField1.setStringValue("Reverse");
   mainRootView().addSubview(sliderField1);   

   slider = new Slider(90, 200, 270, 20);
   slider.setTarget(this);
   slider.setCommand("AnimRate");
   slider.setLimits(-100,100);
   slider.setValue(54);
   mainRootView().addSubview(slider);   
   slider.draw();

   TextField sliderField2 = new TextField(380, 200, 50, 20);
   sliderField2.setBorder(null);
   sliderField2.setEditable(false);
   sliderField2.setBackgroundColor(Color.lightGray);
   sliderField2.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   sliderField2.setStringValue("Forward");
   mainRootView().addSubview(sliderField2);   
   
   // Create label and popup selection for data to plot
   TextField labelField1 = new TextField(25, 230, 100, 25);
   labelField1.setBorder(null);
   labelField1.setEditable(false);
   labelField1.setBackgroundColor(Color.lightGray);
   labelField1.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   labelField1.setStringValue("Data to plot:");
   mainRootView().addSubview(labelField1);
   
   dataPopup = new Popup(100, 230, 250, 25);
   dataPopup.addItem("Random data",         "DataType");
   dataPopup.addItem("NxM array",           "DataType");
   dataPopup.addItem("X/Y/Z data triplets", "DataType");
   dataPopup.setTarget(this);
   dataPopup.setCommand("DataType");
   mainRootView().addSubview(dataPopup);

   // We can prompt for the actual data to be plotted in a text
   // widget if this code is run as an applet, but if it is run
   // as an application we can prompt for a local file to be read.
   if (isApplet()) {

      // Create label and scrolled text view for data input
      TextField labelField2 = new TextField(25, 265, 90, 25);
      labelField2.setBorder(null);
      labelField2.setEditable(false);
      labelField2.setBackgroundColor(Color.lightGray);
      labelField2.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      labelField2.setStringValue("Enter data:");
      mainRootView().addSubview(labelField2);

      scrollView = new ContainerView(0, 0, 250, 5000);
      scrollView.setBorder(null);      
      dataField = new TextView(0, 0, 250, 100);
      dataField.setEditable(false);
      dataField.setBackgroundColor(Color.lightGray);
      dataField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      dataField.setString("");
      scrollView.addSubview(dataField);
      ScrollGroup sgView = new ScrollGroup(100, 265, 250, 34);
      sgView.setBorder(new BezelBorder().groovedBezel());
      sgView.setContentView(scrollView);
      mainRootView().addSubview(sgView);
   
   } else {

      // Create label, filename text component, and button to
      // invoke a file browser
      TextField labelField2 = new TextField(25, 265, 90, 25);
      labelField2.setBorder(null);
      labelField2.setEditable(false);
      labelField2.setBackgroundColor(Color.lightGray);
      labelField2.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      labelField2.setStringValue("Filename:");
      mainRootView().addSubview(labelField2);

      fileField = new TextField(100, 270, 250, 25);
      fileField.setBorder(new BezelBorder().groovedBezel());
      fileField.setEditable(false);
      fileField.setBackgroundColor(Color.lightGray);
      fileField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      fileField.setStringValue("");
      mainRootView().addSubview(fileField);

      browseButton = new Button(360, 265, 65, 25);
      browseButton.setTitle("Browse...");
      browseButton.setTarget(this);
      browseButton.setCommand("Browse");
      mainRootView().addSubview(browseButton);
   
   }

   // Create plot button to draw graph
   plotButton = new Button(25, 315, 65, 25);
   plotButton.setTitle("Plot");
   plotButton.setTarget(this);
   plotButton.setCommand("Plot");
   mainRootView().addSubview(plotButton);

   // Create button to invoke new window with plot option
   optionButton = new Button(100, 315, 65, 25);
   optionButton.setTitle("Options...");
   optionButton.setTarget(this);
   optionButton.setCommand("Options");
   mainRootView().addSubview(optionButton);
   
   // Create a text field for status messages
   statusField = new TextField(25, 350, 400, 25);
   statusField.setBorder(null);
   statusField.setEditable(false);
   statusField.setBorder(new BezelBorder().groovedBezel());
   statusField.setBackgroundColor(Color.lightGray);
   statusField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   statusField.setStringValue("");
   mainRootView().addSubview(statusField);
   
   }
    
    /** Method to dispatch all commands.
      */
    public void performCommand(String command, Object arg) {
    if      (command.equals("DataType")) DataType(arg);
    else if (command.equals("Browse"))   Browse(arg);
    else if (command.equals("Plot"))     Plot(arg);
    else if (command.equals("Options"))  Options(arg);
    else if (command.equals("ColTbl"))   ColTbl(arg);
    else if (command.equals("Frames"))   Frames(arg);
    else if (command.equals("AnimRate")) AnimRate(arg);
    }

   void AnimRate(Object arg)
   {  int val = slider.value();
      int dir = DrawingSequence.FORWARD_LOOP;
      if (val <= 0) dir = DrawingSequence.BACKWARD_LOOP;
      val = 100 - Math.abs(val);
      
      // Add some non-linearity to the slider rate
      if      (val >= 80) val = val * 4;
      else if (val >= 60) val = val * 3;
      else if (val >= 40) val = val * 2;
      else if (val <= 5)  val = 5; 

      // Change the animation rate
      if (animloaded) {
         surf.stop();
         //System.out.println("AmimRate Change: "+ slider.value()+"  "+val);
         surf.setFrameRate(val);
         surf.setPlaybackMode(dir);
         if (Math.abs(slider.value()) >= 4) surf.start();
      }
   }


    /** This method is invoked when the Data Popup is pressed.
      */
    public void DataType(Object arg) {
       
       // Save the data type selected
       datatype = dataPopup.selectedIndex();
       
       // Make the file/data field editable/non-editable as
       // appropriate.
       if (!isApplet()) {
          if (datatype >= 1) {
             fileField.setBackgroundColor(Color.white);
             if (!fileField.isEditable()) fileField.setEditable(true);
          } else {
             fileField.setBackgroundColor(Color.lightGray);
             if ( fileField.isEditable()) {
                fileField.cancelEditing();
                fileField.setEditable(false);
             }
          }
          fileField.draw();
       } else {
          if (datatype >= 1) {
             dataField.setBackgroundColor(Color.white);
             scrollView.setBackgroundColor(Color.white);
             if (!dataField.isEditable()) dataField.setEditable(true);
          } else {
             dataField.setBackgroundColor(Color.lightGray);
             scrollView.setBackgroundColor(Color.lightGray);
             if ( dataField.isEditable()) {
                dataField.setEditable(false);
             }
          }
          dataField.draw();
       }
    } 

    /** This method is invoked when the Data Popup is pressed.
      * It invokes a modal FileChooser dialog.
      */
    public void Browse(Object arg) {
       FileChooser fc = new FileChooser(mainRootView(), 
          "Select ASCII data file", FileChooser.LOAD_TYPE);
       fc.showModally();
       if (fc != null) fileField.setStringValue(fc.file());
    }
    
    /** This method is invoked when the Plot button is pressed.
      */
    public void Plot(Object arg) {
    
         int xsize;
         int ysize;
    
         // Reset and set some default attributes of the plot component
         surf.reset();
         surf.setXTitle( "X Axes" );
         surf.setYTitle( "Y Axes" );
         surf.setZTitle( "Z Axes" );
         surf.LOADCT(coltbl);
         surf.setFrames(frames);
         surf.setFrameRate(300);
         animloaded = true;
                  
         // Set the data for the plot component and create plot   
         switch (datatype)
         {   
             // Random data
             case 0: {  double[] data = new double[100];
                        for(int i =0; i<100; i++) data[i]=Math.random();
                        surf.setGrid(false);
                        surf.setZ( data, 10, 10 );
                        showStatus("Calling PV-WAVE ...");
                        surf.plot();
                        surf.start();
                        showStatus("");
                        break;
                     }
             
             // NxM Array
             case 1: {  Vector vdata = new Vector();
             
                        // For an applet read from the text widget
                        if (isApplet()) {
                              try {
                                 StreamTokenizer strm = new StreamTokenizer(
                                    new StringBufferInputStream(dataField.string()));
                                 strm.wordChars(0, ' ');
                                 strm.whitespaceChars(',', ',');
                                 int tok;
                                 
                                 // Get array size
                                 tok = strm.nextToken();
                                 xsize = (int) strm.nval;
                                 tok = strm.nextToken();
                                 ysize = (int) strm.nval;
                                 
                                 while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                    if (tok == strm.TT_NUMBER) {
                                       vdata.addElement(new Double(strm.nval));
                                    }
                                 }
                              } catch (IOException e) {
                                 System.err.println(e);
                                 return;
                              }
                              
                              // Set the Y data and plot the data
                              surf.setZ( vdata, xsize, ysize );
                              showStatus("Calling PV-WAVE ...");
                              surf.plot();
                              surf.start();
                              showStatus("");
                              break;
                              
                        } else {
                      
                           // For an application read the data from a file
                           if (!fileField.stringValue().equals("")) {
                              File dataFile = new File(fileField.stringValue());
                              if (dataFile.exists()) {
                                 try {
                                    StreamTokenizer strm = new StreamTokenizer(
                                       new FileInputStream(fileField.stringValue()));
                                    strm.wordChars(0, ' ');
                                    strm.whitespaceChars(',', ',');
                                    int tok;
                                    
                                    // Get array size
                                    tok = strm.nextToken();
                                    xsize = (int) strm.nval;
                                    tok = strm.nextToken();
                                    ysize = (int) strm.nval;
                                    
                                    while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                       if (tok == strm.TT_NUMBER) {
                                          vdata.addElement(new Double(strm.nval));
                                       }
                                    }
                                 } catch (IOException e) {
                                    System.err.println(e);
                                    return;
                                 }
                              
                                 // Set the Y data and plot the data
                                 surf.setZ( vdata, xsize, ysize );                              
                                 showStatus("Calling PV-WAVE ...");
                                 surf.plot();
                                 surf.start();
                                 showStatus("");
                              }
                           } else {
                              showStatus("Invalid filename entered: "+fileField.stringValue());
                           }
                           break;
                        }
                     }
                     
             // XYZ Data values
             case 2: {  Vector vxdata = new Vector();
                        Vector vydata = new Vector();
                        Vector vzdata = new Vector();
                        
                        // For an applet read from the text widget
                        if (isApplet()) {
                              try {
                                 StreamTokenizer strm = new StreamTokenizer(
                                    new StringBufferInputStream(dataField.string()));
                                 strm.wordChars(0, ' ');
                                 strm.whitespaceChars(',', ',');
                                 int tok;
                                 int cnt = 0;                                 
                                 while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                    if (tok == strm.TT_NUMBER) {
                                       switch (cnt % 3) {
                                          case 0: {  vxdata.addElement(new Double(strm.nval));
                                                     break;
                                                  } 
                                          case 1: {  vydata.addElement(new Double(strm.nval));
                                                     break;
                                                  } 
                                          case 2: {  vzdata.addElement(new Double(strm.nval));
                                                     break;
                                                  } 
                                       }
                                       cnt ++;
                                    }
                                 }
                              } catch (IOException e) {
                                 System.err.println(e);
                                 return;
                              }
                              
                              // Set the X and Y data and plot the data                        
                              surf.setGrid( true );
                              surf.setX( vxdata );
                              surf.setY( vydata );
                              surf.setZ( vzdata );
                              showStatus("Calling PV-WAVE ...");
                              surf.plot();
                              surf.start();
                              showStatus("");
                              break;
                              
                        } else {
                         
                           // For an application read the data from a file
                           if (!fileField.stringValue().equals("")) {
                              File dataFile = new File(fileField.stringValue());
                              if (dataFile.exists()) {
                                 try {
                                    StreamTokenizer strm = new StreamTokenizer(
                                       new FileInputStream(fileField.stringValue()));
                                    strm.wordChars(0, ' ');
                                    strm.whitespaceChars(',', ',');
                                    int tok;
                                    int cnt = 0;
                                    while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                       if (tok == strm.TT_NUMBER) {
                                          switch (cnt %3) {
                                             case 0: vxdata.addElement(new Double(strm.nval)); 
                                             case 1: vydata.addElement(new Double(strm.nval)); 
                                             case 2: vzdata.addElement(new Double(strm.nval)); 
                                          }
                                          cnt ++;
                                       }
                                    }
                                 } catch (IOException e) {
                                    System.err.println(e);
                                    return;
                                 }
                                                         
                                 // Set the X and Y data and plot the data
                                 surf.setGrid( true );
                                 surf.setX( vxdata );
                                 surf.setY( vydata );
                                 surf.setZ( vzdata );                              
                                 showStatus("Calling PV-WAVE ...");
                                 surf.plot();
                                 surf.start();
                                 showStatus("");
                              }
                           } else {
                              showStatus("Invalid filename entered: "+fileField.stringValue());
                           }
                           break;
                        }
                     }
         }
    }

    /** This method is invoked when the Data Popup is pressed.
      * It creates a dialog to allow a few of the attributes associated
      * with this plot type to be modified.
      */
    public void Options(Object arg) {
    
       // Don't create a new window if one is already displayed
       if ((window == null) || (!window.isVisible())) {
       
       window = new InternalWindow(40, 40, 250, 100);

       window.setTitle("Attributes");
       window.setResizable(true);
       window.setCloseable(true);

       // Reset settings
       coltbl  = "BLUE/WHITE";
       frames  = 12;

       // Color Table

       TextField coltblField = new TextField(5, 5, 100, 24);
       coltblField.setBorder(null);
       coltblField.setEditable(false);
       coltblField.setBackgroundColor(Color.lightGray);
       coltblField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       coltblField.setStringValue("Color Table");
       window.addSubview(coltblField);
       
       coltblPopup = new Popup(100, 5, 140, 24);
       coltblPopup.addItem("B-W LINEAR", "ColTbl");
       coltblPopup.addItem("BLUE/WHITE", "ColTbl");
       coltblPopup.addItem("GRN-RED-BLU-WHT", "ColTbl");
       coltblPopup.addItem("RED TEMPERATURE", "ColTbl");
       coltblPopup.addItem("PRISM", "ColTbl");
       coltblPopup.addItem("WAVE SPECIAL", "ColTbl");
       coltblPopup.selectItemAt(1);
       coltblPopup.setTarget(this);
       coltblPopup.setCommand("ColTbl");
       window.addSubview(coltblPopup);

       // Frames

       TextField framesField = new TextField(5, 35, 100, 24);
       framesField.setBorder(null);
       framesField.setEditable(false);
       framesField.setBackgroundColor(Color.lightGray);
       framesField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       framesField.setStringValue("# Frames");
       window.addSubview(framesField);
       
       framesPopup = new Popup(100, 35, 140, 24);
       framesPopup.addItem("4", "Frames");
       framesPopup.addItem("8", "Frames");
       framesPopup.addItem("12", "Frames");
       framesPopup.addItem("16", "Frames");
       framesPopup.addItem("32", "Frames");
       framesPopup.selectItemAt(2);
       framesPopup.setTarget(this);
       framesPopup.setCommand("Frames");
       window.addSubview(framesPopup);

       window.contentView().layoutView(0, 0);
       window.show();
    }
    }

    /** Method to change plot attribute
      */
    public void ColTbl(Object arg) {
         coltbl = coltblPopup.selectedItem().title();
    }
    
    /** Method to change plot attribute
      */
    public void Frames(Object arg) {
         frames = framesPopup.selectedIndex() * 4 + 4;
    }
    
    /** Update the text displayed in the status field
      */
    public void showStatus(String status) {
    statusField.setStringValue(status);
    }

    /** Main method required when run as an application
      * rather than an applet.
      */
    public static void main(String args[]) {
        surfanim app;
        ExternalWindow mainWindow;
        Size size;

        app = new surfanim();
        mainWindow = new ExternalWindow();
        size = mainWindow.windowSizeForContentSize(450, 500);
        mainWindow.sizeTo(size.width, size.height);
        mainWindow.show();
        app.setMainRootView(mainWindow.rootView());

        app.run();
    }

TextField  titleField;
WaveSurfAnim surf;
Slider     slider;
boolean    animloaded=false;
Popup      dataPopup;
int        datatype=0;
TextView   dataField;
ContainerView scrollView;
TextField  fileField;
Button     browseButton;
Button     optionButton;
Button     plotButton;
TextField  statusField;
InternalWindow window;
Popup      coltblPopup;
Popup      framesPopup;
String     coltbl = "BLUE/WHITE";
int        frames = 12;

}
