/*                                                
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 *
 * -----------------------------------------------------------------------
 *
 * simple.java
 *
 * This demonstration code shows how the JWAVE class WavePlot can be used
 * to produce a line plot of random data created within the java
 * code.  It is a fairly minimal example of usnig JWAVE classes within
 * an IFC applet.
 *
 */

import netscape.application.*;
import VisualNumerics.wave.*;

public class simple extends Application implements Target {
    
   public void init() {
        super.init();   

   // Create the Plot component
   plot = new WavePlot( 25, 30, 400, 300 );
   
   // This demo can be run as both an applet or an application,
   // using either a PV-WAVE based server on the internet,
   // or a local PV-WAVE process with no network communication.
   //
   // When run as an applet, two parameters can be specified in 
   // the <APPLET> tag in the HTML document that starts this applet.  
   // You could use either (but not both) of these parameters:
   //
   //    <PARAM NAME="Server" VALUE="http://vrml.boulder.vni.com.:9000">
   // or
   //    <PARAM NAME="LocalServer" VALUE="C:\java\waveserver">
   //
   // The "Server" parameter specifies the URL of the server
   // which has a "waveserver" script in its cgi-bin directory.
   // Communications with the PV-WAVE graphic server is
   // performed through this cgi script.
   //
   // The "LocalServer" parameter specifies a local directory 
   // which a PV-WAVE process running the "LocalServer" procedure
   // uses to communicate with the applet via files.
   //
   // WHAT THIS ALL MEANS
   // 
   // Here are the two ways you can run this demo as provided:
   //
   // - By using a browser to access the provided HTML file.
   //   This will run the demo as an applet, using our PV-WAVE
   //   server in Boulder, Colorado.  Because an applet can not
   //   read local files on a client, you will not be able to
   //   plot your own data from a file, but for demonstration
   //   purposes you can enter comma separated ASCII data in
   //   a text widget.  You can get the same behavior with
   //   the appletviewer provided with the Java JDK from Sun:
   //
   //      appletviewer bar3d.html
   //
   // - By downloading the JWAVE SDK and running as an application:
   //
   //      java bar3d
   //
   //   This will still use the PV-WAVE server in Boulder, CO,
   //   but you will be able to read comma separated ASCII files
   //   of your own.
   //
   // You can modify the HTML file to use the "LocalServer" parameter
   // instead, so that you do not need a web server or internet 
   // connection to run the demo.  You need to start a PV-WAVE
   // server as a separate process on your machine in order to
   // do this.  See the JWAVE SDK for instructions on configuring
   // and running a local server.
   //      
   
   // Get the parameters from the applet tags
   java.applet.Applet applet = AWTCompatibility.awtApplet();
   String server  = applet.getParameter("Server");
   String lserver = applet.getParameter("LocalServer");

   // Use the parameters if provided else default
   if (server != null) {
      plot.setServer(server);
   } else if (lserver != null) {
      plot.setLocalServer(lserver);
   } else {
      plot.setServer( "http://vrml.boulder.vni.com.:9000" );
   }

   // Set some default attributes of the plot component
   plot.reset();
   plot.setTitle( "Simple Plot Test" );
   plot.setSubtitle( "Random Data" );
   plot.TEK_COLOR();
   plot.setBackground("blue");
   plot.setColor("white");
   plot.setRegion( .01, .05, .95, .95 );
   plot.setYRange( 0.0, 1.0);
   plot.setXTitle( "X Axes" );
   plot.setYTitle( "Y Axes" );   
   mainRootView().addSubview(plot);

   // Create plot button to draw graph
   Button plotButton = new Button(25, 350, 65, 25);
   plotButton.setTitle("Plot");
   plotButton.setTarget(this);
   plotButton.setCommand("Plot");
   mainRootView().addSubview(plotButton);
   }
    
    /** Method to dispatch commands.
      */
    public void performCommand(String command, Object arg) {
    if (command.equals("Plot")) Plot(arg);
    }

    /** This method is invoked when the Plot button is pressed.
      */
    public void Plot(Object arg) {
    
         // Create some random data and associate it with the plot component
         double[] data = new double[50];
         for(int i =0; i<50; i++) data[i]=Math.random();
         plot.setY( data );
         
         // Create the plot
         plot.plot();
    }

WavePlot   plot;
}
