/*                                                
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 *
 * -----------------------------------------------------------------------
 *
 * pie.java
 *
 * This demonstration code shows how the JWAVE class WavePie can be used
 * to produce pie charts of either sample data created within the java
 * code, or from user provided data.
 *
 * The format for user provided data must be comma separated values, 
 * with any number of values per line.
 *
 * If this code is run as an applet, it will display a scrolled text
 * field in which you can enter your own data.  If the code is run
 * as an application (using the "java" command provided with the 
 * Java JDK from Sun for instance), you instead can enter or browse 
 * for a path/filename containing your data.
 *
 * The JWAVE classes allow you access to all PV-WAVE keyword parameters,
 * and an "Options" dialog is provided in this demo to allow you to 
 * change a few of them.  See the documentation for the JWAVE classes for 
 * complete descriptions of the parameters supported.
 *
 */

import java.io.*;
import netscape.application.*;
import netscape.util.*;
import VisualNumerics.wave.*;

public class pie extends Application implements Target {
    
    /** This method gets called to initialize an application. We'll take
      * this opportunity to set up the View hierarchy.
      */
   public void init() {
        super.init();   

   // Change the color of the background view to be the standard
   // application lightGray.
   mainRootView().setColor(Color.lightGray);

   // Plot Title   
   TextField titleField = new TextField(170, 5, 200, 30);
   titleField.setBorder(null);
   titleField.setEditable(false);
   titleField.setBackgroundColor(Color.lightGray);
   titleField.setFont(Font.fontNamed("Helvetica", Font.BOLD, 14));
   titleField.setStringValue("WavePie Example");
   mainRootView().addSubview(titleField);

   // Create the Plot component
   pie = new WavePie( 75, 30, 300, 300 );
   
   // This demo can be run as both an applet or an application,
   // using either a PV-WAVE based server on the internet,
   // or a local PV-WAVE process with no network communication.
   //
   // When run as an applet, two parameters can be specified in 
   // the <APPLET> tag in the HTML document that starts this applet.  
   // You could use either (but not both) of these parameters:
   //
   //    <PARAM NAME="Server" VALUE="http://vrml.boulder.vni.com.:9000">
   // or
   //    <PARAM NAME="LocalServer" VALUE="C:\java\waveserver">
   //
   // The "Server" parameter specifies the URL of the server
   // which has a "waveserver" script in its cgi-bin directory.
   // Communications with the PV-WAVE graphic server is
   // performed through this cgi script.
   //
   // The "LocalServer" parameter specifies a local directory 
   // which a PV-WAVE process running the "LocalServer" procedure
   // uses to communicate with the applet via files.
   //
   // WHAT THIS ALL MEANS
   // 
   // Here are the two ways you can run this demo as provided:
   //
   // - By using a browser to access the provided HTML file.
   //   This will run the demo as an applet, using our PV-WAVE
   //   server in Boulder, Colorado.  Because an applet can not
   //   read local files on a client, you will not be able to
   //   plot your own data from a file, but for demonstration
   //   purposes you can enter comma separated ASCII data in
   //   a text widget.  You can get the same behavior with
   //   the appletviewer provided with the Java JDK from Sun:
   //
   //      appletviewer bar3d.html
   //
   // - By downloading the JWAVE SDK and running as an application:
   //
   //      java bar3d
   //
   //   This will still use the PV-WAVE server in Boulder, CO,
   //   but you will be able to read comma separated ASCII files
   //   of your own.
   //
   // You can modify the HTML file to use the "LocalServer" parameter
   // instead, so that you do not need a web server or internet 
   // connection to run the demo.  You need to start a PV-WAVE
   // server as a separate process on your machine in order to
   // do this.  See the JWAVE SDK for instructions on configuring
   // and running a local server.
   //      
   
   // Get the parameters from the applet tags
   java.applet.Applet applet = AWTCompatibility.awtApplet();
   String server  = applet.getParameter("Server");
   String lserver = applet.getParameter("LocalServer");

   // Use the parameters if provided else default
   if (server != null) {
      pie.setServer(server);
   } else if (lserver != null) {
      pie.setLocalServer(lserver);
   } else {
      pie.setServer( "http://vrml.boulder.vni.com.:9000" );
   }
         
   mainRootView().addSubview(pie);

   // Create label and popup selection for data to plot
   TextField labelField1 = new TextField(25, 350, 100, 25);
   labelField1.setBorder(null);
   labelField1.setEditable(false);
   labelField1.setBackgroundColor(Color.lightGray);
   labelField1.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   labelField1.setStringValue("Data to plot:");
   mainRootView().addSubview(labelField1);
   
   dataPopup = new Popup(100, 350, 250, 25);
   dataPopup.addItem("Random data", "DataType");
   dataPopup.addItem("Slice values", "DataType");
   dataPopup.setTarget(this);
   dataPopup.setCommand("DataType");
   mainRootView().addSubview(dataPopup);

   // We can prompt for the actual data to be plotted in a text
   // widget if this code is run as an applet, but if it is run
   // as an application we can prompt for a local file to be read.
   if (isApplet()) {

      // Create label and scrolled text view for data input
      TextField labelField2 = new TextField(25, 385, 90, 25);
      labelField2.setBorder(null);
      labelField2.setEditable(false);
      labelField2.setBackgroundColor(Color.lightGray);
      labelField2.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      labelField2.setStringValue("Enter data:");
      mainRootView().addSubview(labelField2);

      scrollView = new ContainerView(0, 0, 250, 5000);
      scrollView.setBorder(null);      
      dataField = new TextView(0, 0, 250, 100);
      dataField.setEditable(false);
      dataField.setBackgroundColor(Color.lightGray);
      dataField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      dataField.setString("");
      scrollView.addSubview(dataField);
      ScrollGroup sgView = new ScrollGroup(100, 385, 250, 34);
      sgView.setBorder(new BezelBorder().groovedBezel());
      sgView.setContentView(scrollView);
      mainRootView().addSubview(sgView);
   
   } else {

      // Create label, filename text component, and button to
      // invoke a file browser
      TextField labelField2 = new TextField(25, 385, 90, 25);
      labelField2.setBorder(null);
      labelField2.setEditable(false);
      labelField2.setBackgroundColor(Color.lightGray);
      labelField2.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      labelField2.setStringValue("Filename:");
      mainRootView().addSubview(labelField2);

      fileField = new TextField(100, 390, 250, 25);
      fileField.setBorder(new BezelBorder().groovedBezel());
      fileField.setEditable(false);
      fileField.setBackgroundColor(Color.lightGray);
      fileField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      fileField.setStringValue("");
      mainRootView().addSubview(fileField);

      browseButton = new Button(360, 385, 65, 25);
      browseButton.setTitle("Browse...");
      browseButton.setTarget(this);
      browseButton.setCommand("Browse");
      mainRootView().addSubview(browseButton);
   
   }

   // Create plot button to draw graph
   plotButton = new Button(25, 435, 65, 25);
   plotButton.setTitle("Plot");
   plotButton.setTarget(this);
   plotButton.setCommand("Plot");
   mainRootView().addSubview(plotButton);

   // Create button to invoke new window with plot option
   optionButton = new Button(100, 435, 65, 25);
   optionButton.setTitle("Options...");
   optionButton.setTarget(this);
   optionButton.setCommand("Options");
   mainRootView().addSubview(optionButton);
   
   // Create a text field for status messages
   statusField = new TextField(25, 470, 400, 25);
   statusField.setBorder(null);
   statusField.setEditable(false);
   statusField.setBorder(new BezelBorder().groovedBezel());
   statusField.setBackgroundColor(Color.lightGray);
   statusField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   statusField.setStringValue("");
   mainRootView().addSubview(statusField);
   
   }
    
    /** Method to dispatch all commands.
      */
    public void performCommand(String command, Object arg) {
    if      (command.equals("DataType")) DataType(arg);
    else if (command.equals("Browse"))   Browse(arg);
    else if (command.equals("Plot"))     Plot(arg);
    else if (command.equals("Options"))  Options(arg);
    else if (command.equals("BgColor"))  BgColor(arg);
    else if (command.equals("Position")) Position(arg);
    else if (command.equals("Percent"))  Percent(arg);
    else if (command.equals("Value"))    Value(arg);
    }

    /** This method is invoked when the Data Popup is pressed.
      */
    public void DataType(Object arg) {
       
       // Save the data type selected
       datatype = dataPopup.selectedIndex();
       
       // Make the file/data field editable/non-editable as
       // appropriate.
       if (!isApplet()) {
          if (datatype >= 1) {
             fileField.setBackgroundColor(Color.white);
             if (!fileField.isEditable()) fileField.setEditable(true);
          } else {
             fileField.setBackgroundColor(Color.lightGray);
             if ( fileField.isEditable()) {
                fileField.cancelEditing();
                fileField.setEditable(false);
             }
          }
          fileField.draw();
       } else {
          if (datatype >= 1) {
             dataField.setBackgroundColor(Color.white);
             scrollView.setBackgroundColor(Color.white);
             if (!dataField.isEditable()) dataField.setEditable(true);
          } else {
             dataField.setBackgroundColor(Color.lightGray);
             scrollView.setBackgroundColor(Color.lightGray);
             if ( dataField.isEditable()) {
                dataField.setEditable(false);
             }
          }
          dataField.draw();
       }
    } 

    /** This method is invoked when the Data Popup is pressed.
      * It invokes a modal FileChooser dialog.
      */
    public void Browse(Object arg) {
       FileChooser fc = new FileChooser(mainRootView(), 
          "Select ASCII data file", FileChooser.LOAD_TYPE);
       fc.showModally();
       if (fc != null) fileField.setStringValue(fc.file());
    }
    
    /** This method is invoked when the Plot button is pressed.
      */
    public void Plot(Object arg) {

         // Reset and set some default attributes of the plot component
         pie.reset();
         pie.setTitle( "WavePie Test" );
         pie.TEK_COLOR();
         pie.setBackground(bgcolor);
         pie.setCharsize( 0.8 );
         pie.setShade( 0.10 );

         // Set pie radius
         if (position == 0) {
            pie.setRadius( 0.35 );       
         } else {
            pie.setRadius( 0.20 );
         }
         
         // Set flags to draw percent and value annotations
         // for each pie slice
         if (percent == 0) pie.setTPerct(true);
         if (value   == 0) pie.setTValue(true);
                      
         // Set the data for the plot component and create plot   
         switch (datatype)
         {   
             // Random data
             case 0: {  
                        int[] data = new int[6];
                        for(int i =0; i<6; i++) {
                           double tmp = Math.random()*20 + 1;
                           data[i] = (int) tmp;
                        }
                        pie.setX( data );
                        
                        // Set pie slice colors
                        int[] cols = new int[6];
                        for (int i=0; i<6; i++) cols[i]=i+2;
                        pie.setColor( cols );
                        
                        // Set pie label positions
                        int[] labs = new int[6];
                        for (int i=0; i<6; i++) labs[i]=position;
                        pie.setTPosition(labs);

                        // Set pie label colors
                        int[] tcol = new int[6];
                        for (int i=0; i<6; i++) tcol[i]=0;
                        pie.setTColor( tcol );   
                        
                        // Explode a couple of slices for fun
                        double[] expl = new double[6];
                        for (int i=0; i<6; i++) expl[i]=0.0;
                        expl[0] = 0.2;
                        expl[3] = 0.3;
                        pie.setExplode(expl);                       
                        
                        showStatus("Calling PV-WAVE ...");
                        pie.plot();
                        showStatus("");
                        break;
                     }
                     
             // Slice values
             case 1: {  Vector vdata = new Vector();
             
                        // For an applet read from the text widget
                        if (isApplet()) {
                              try {
                                 StreamTokenizer strm = new StreamTokenizer(
                                    new StringBufferInputStream(dataField.string()));
                                 strm.wordChars(0, ' ');
                                 strm.whitespaceChars(',', ',');
                                 int tok;
                                 while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                    if (tok == strm.TT_NUMBER) {
                                       vdata.addElement(new Double(strm.nval));
                                    }
                                 }
                              } catch (IOException e) {
                                 System.err.println(e);
                                 return;
                              }
                              
                              // Set the data and plot the data
                              pie.setX( vdata );
                              
                              // Set pie slice colors 
                              int ndata = vdata.size();
                              int[] cols = new int[ndata];
                              for (int i=0; i<ndata; i++) cols[i]=i+2;
                              pie.setColor( cols );
                              
                              // Set pie label positions
                              int[] labs = new int[ndata];
                              for (int i=0; i<ndata; i++) labs[i]=position;
                              pie.setTPosition(labs);

                              // Set pie label colors
                              int[] tcol = new int[ndata];
                              for (int i=0; i<ndata; i++) tcol[i]=0;
                              pie.setTColor(tcol);                              
                              
                              showStatus("Calling PV-WAVE ...");
                              pie.plot();
                              showStatus("");
                              break;
                              
                        } else {
                      
                           // For an application read the data from a file
                           if (!fileField.stringValue().equals("")) {
                              File dataFile = new File(fileField.stringValue());
                              if (dataFile.exists()) {
                                 try {
                                    StreamTokenizer strm = new StreamTokenizer(
                                       new FileInputStream(fileField.stringValue()));
                                    strm.wordChars(0, ' ');
                                    strm.whitespaceChars(',', ',');
                                    int tok;
                                    while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                       if (tok == strm.TT_NUMBER) {
                                          vdata.addElement(new Double(strm.nval));
                                       }
                                    }
                                 } catch (IOException e) {
                                    System.err.println(e);
                                    return;
                                 }
                              
                                 // Set the data and plot the data                              
                                 pie.setX( vdata );
                                 
                                 // Set pie slice colors                        
                                 int ndata = vdata.size();
                                 int[] cols = new int[ndata];
                                 for (int i=0; i<ndata; i++) cols[i]=i+2;
                                 pie.setColor( cols );
                                 
                                 // Set pie label positions
                                 int[] labs = new int[ndata];
                                 for (int i=0; i<ndata; i++) labs[i]=position;
                                 pie.setTPosition(labs);
                                 
                                 // Set pie label colors
                                 int[] tcol = new int[ndata];
                                 for (int i=0; i<ndata; i++) tcol[i]=0;
                                 pie.setTColor(tcol);                              
                                                               
                                 showStatus("Calling PV-WAVE ...");
                                 pie.plot();
                                 showStatus("");
                              }
                           } else {
                              showStatus("Invalid filename entered: "+fileField.stringValue());
                           }
                           break;
                        }
                     }
         }
    }

    /** This method is invoked when the Data Popup is pressed.
      * It creates a dialog to allow a few of the attributes associated
      * with this plot type to be modified.
      */
    public void Options(Object arg) {
    
       // Don't create a new window if one is already displayed
       if ((window == null) || (!window.isVisible())) {
       
       window = new InternalWindow(40, 40, 250, 160);

       window.setTitle("Attributes");
       window.setResizable(true);
       window.setCloseable(true);

       // Reset settings
       bgcolor = "white";
       position= 1;
       percent = 0;
       value   = 0;

       // Background color

       TextField bgcolorField = new TextField(5, 5, 125, 24);
       bgcolorField.setBorder(null);
       bgcolorField.setEditable(false);
       bgcolorField.setBackgroundColor(Color.lightGray);
       bgcolorField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       bgcolorField.setStringValue("Background");
       window.addSubview(bgcolorField);
       
       bgcolorPopup = new Popup(125, 5, 110, 24);
       bgcolorPopup.addItem("black", "BgColor");
       bgcolorPopup.addItem("green", "BgColor");
       bgcolorPopup.addItem("red", "BgColor");
       bgcolorPopup.addItem("blue", "BgColor");
       bgcolorPopup.addItem("lightGray", "BgColor");
       bgcolorPopup.addItem("white", "BgColor");
       bgcolorPopup.addItem("cyan", "BgColor");
       bgcolorPopup.addItem("magenta", "BgColor");
       bgcolorPopup.addItem("yellow", "BgColor");
       bgcolorPopup.addItem("darkGray", "BgColor");
       bgcolorPopup.addItem("orange", "BgColor");
       bgcolorPopup.addItem("gray", "BgColor");
       bgcolorPopup.addItem("pink", "BgColor");
       bgcolorPopup.selectItemAt(5);       
       bgcolorPopup.setTarget(this);
       bgcolorPopup.setCommand("BgColor");
       window.addSubview(bgcolorPopup);

       // Label Position

       TextField positionField = new TextField(5, 35, 125, 24);
       positionField.setBorder(null);
       positionField.setEditable(false);
       positionField.setBackgroundColor(Color.lightGray);
       positionField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       positionField.setStringValue("Label Position");
       window.addSubview(positionField);
       
       positionPopup = new Popup(125, 35, 110, 24);
       positionPopup.addItem("Internal", "Position");
       positionPopup.addItem("External", "Position");
       positionPopup.addItem("External Allign", "Position");
       positionPopup.selectItemAt(1);
       positionPopup.setTarget(this);
       positionPopup.setCommand("Position");
       window.addSubview(positionPopup);

       // Percent

       TextField percentField = new TextField(5, 65, 125, 24);
       percentField.setBorder(null);
       percentField.setEditable(false);
       percentField.setBackgroundColor(Color.lightGray);
       percentField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       percentField.setStringValue("Display Percents");
       window.addSubview(percentField);
       
       percentPopup = new Popup(125, 65, 110, 24);
       percentPopup.addItem("Yes", "Percent");
       percentPopup.addItem("No", "Percent");
       percentPopup.setTarget(this);
       percentPopup.setCommand("Percent");
       window.addSubview(percentPopup);

       // Value

       TextField valueField = new TextField(5, 95, 125, 24);
       valueField.setBorder(null);
       valueField.setEditable(false);
       valueField.setBackgroundColor(Color.lightGray);
       valueField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       valueField.setStringValue("Display Values");
       window.addSubview(valueField);
       
       valuePopup = new Popup(125, 95, 110, 24);
       valuePopup.addItem("Yes", "Value");
       valuePopup.addItem("No", "Value");
       valuePopup.setTarget(this);
       valuePopup.setCommand("Value");
       window.addSubview(valuePopup);

       window.contentView().layoutView(0, 0);
       window.show();
    }
    }

    /** Method to change plot attribute
      */
    public void BgColor(Object arg) {
         bgcolor = bgcolorPopup.selectedItem().title();
    }

    /** Method to change plot attribute
      */
    public void Position(Object arg) {
         position = positionPopup.selectedIndex();
    }

    /** Method to change plot attribute
      */
    public void Percent(Object arg) {
         percent = percentPopup.selectedIndex();
    }

    /** Method to change plot attribute
      */
    public void Value(Object arg) {
         value = valuePopup.selectedIndex();
    }
    
    /** Update the text displayed in the status field
      */
    public void showStatus(String status) {
    statusField.setStringValue(status);
    }

    /** Main method required when run as an application
      * rather than an applet.
      */
    public static void main(String args[]) {
        pie app;
        ExternalWindow mainWindow;
        Size size;

        app = new pie();
        mainWindow = new ExternalWindow();
        size = mainWindow.windowSizeForContentSize(450, 500);
        mainWindow.sizeTo(size.width, size.height);
        mainWindow.show();
        app.setMainRootView(mainWindow.rootView());

        app.run();
    }


TextField  titleField;
WavePie    pie;
Popup      dataPopup;
int        datatype=0;
TextView   dataField;
ContainerView scrollView;
TextField  fileField;
Button     browseButton;
Button     optionButton;
Button     plotButton;
TextField  statusField;
InternalWindow window;
Popup      bgcolorPopup;
Popup      positionPopup;
Popup      percentPopup;
Popup      valuePopup;
String     bgcolor = "white";
int        position= 1;
int        percent = 0;
int        value   = 0;

}
