/*                                                
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 *
 * -----------------------------------------------------------------------
 *
 * contour.java
 *
 * This demonstration code shows how the JWAVE class WaveContour can be used
 * to produce contour plots of either sample data created within the java
 * code, or from user provided data.
 *
 * The format for user provided data must be comma separated values, 
 * with any number of values per line.  The data can be in the
 * form of X/Y/Z triplets (the total numer of values must then of 
 * course be divisible by three).  If triplets are used then the 
 * FAST_GRID3 procedure in PV-WAVE will be used to grid them and
 * the resulting 2D grid passed to the CONTOUR procedure.
 *
 * The data can also be in the form of a NxM array or grid.  In this case
 * the first two values in the data must represent the number of rows and
 * columns.  For example a 2x3 array of data could look like this:
 *
 *   2, 3, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0 
 *
 * If this code is run as an applet, it will display a scrolled text
 * field in which you can enter your own data.  If the code is run
 * as an application (using the "java" command provided with the 
 * Java JDK from Sun for instance), you instead can enter or browse 
 * for a path/filename containing your data.
 *
 * The JWAVE classes allow you access to all PV-WAVE keyword parameters,
 * and an "Options" dialog is provided in this demo to allow you to 
 * change a few of them.  See the documentation for the JWAVE classes for 
 * complete descriptions of the parameters supported.
 *
 */

import java.io.*;
import netscape.application.*;
import netscape.util.*;
import VisualNumerics.wave.*;

public class contour extends Application implements Target {
    
    /** This method gets called to initialize an application. We'll take
      * this opportunity to set up the View hierarchy.
      */
   public void init() {
        super.init();   

   // Change the color of the background view to be the standard
   // application lightGray.
   mainRootView().setColor(Color.lightGray);

   // Plot Title   
   TextField titleField = new TextField(150, 5, 200, 30);
   titleField.setBorder(null);
   titleField.setEditable(false);
   titleField.setBackgroundColor(Color.lightGray);
   titleField.setFont(Font.fontNamed("Helvetica", Font.BOLD, 14));
   titleField.setStringValue("WaveContour Example");
   mainRootView().addSubview(titleField);

   // Create the Plot component
   cont = new WaveContour( 25, 30, 400, 300 );
   
   // This demo can be run as both an applet or an application,
   // using either a PV-WAVE based server on the internet,
   // or a local PV-WAVE process with no network communication.
   //
   // When run as an applet, two parameters can be specified in 
   // the <APPLET> tag in the HTML document that starts this applet.  
   // You could use either (but not both) of these parameters:
   //
   //    <PARAM NAME="Server" VALUE="http://vrml.boulder.vni.com.:9000">
   // or
   //    <PARAM NAME="LocalServer" VALUE="C:\java\waveserver">
   //
   // The "Server" parameter specifies the URL of the server
   // which has a "waveserver" script in its cgi-bin directory.
   // Communications with the PV-WAVE graphic server is
   // performed through this cgi script.
   //
   // The "LocalServer" parameter specifies a local directory 
   // which a PV-WAVE process running the "LocalServer" procedure
   // uses to communicate with the applet via files.
   //
   // WHAT THIS ALL MEANS
   // 
   // Here are the two ways you can run this demo as provided:
   //
   // - By using a browser to access the provided HTML file.
   //   This will run the demo as an applet, using our PV-WAVE
   //   server in Boulder, Colorado.  Because an applet can not
   //   read local files on a client, you will not be able to
   //   plot your own data from a file, but for demonstration
   //   purposes you can enter comma separated ASCII data in
   //   a text widget.  You can get the same behavior with
   //   the appletviewer provided with the Java JDK from Sun:
   //
   //      appletviewer bar3d.html
   //
   // - By downloading the JWAVE SDK and running as an application:
   //
   //      java bar3d
   //
   //   This will still use the PV-WAVE server in Boulder, CO,
   //   but you will be able to read comma separated ASCII files
   //   of your own.
   //
   // You can modify the HTML file to use the "LocalServer" parameter
   // instead, so that you do not need a web server or internet 
   // connection to run the demo.  You need to start a PV-WAVE
   // server as a separate process on your machine in order to
   // do this.  See the JWAVE SDK for instructions on configuring
   // and running a local server.
   //      
   
   // Get the parameters from the applet tags
   java.applet.Applet applet = AWTCompatibility.awtApplet();
   String server  = applet.getParameter("Server");
   String lserver = applet.getParameter("LocalServer");

   // Use the parameters if provided else default
   if (server != null) {
      cont.setServer(server);
   } else if (lserver != null) {
      cont.setLocalServer(lserver);
   } else {
      cont.setServer( "http://vrml.boulder.vni.com.:9000" );
   }
         
   mainRootView().addSubview(cont);

   // Create label and popup selection for data to plot
   TextField labelField1 = new TextField(25, 350, 100, 25);
   labelField1.setBorder(null);
   labelField1.setEditable(false);
   labelField1.setBackgroundColor(Color.lightGray);
   labelField1.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   labelField1.setStringValue("Data to plot:");
   mainRootView().addSubview(labelField1);
   
   dataPopup = new Popup(100, 350, 250, 25);
   dataPopup.addItem("Random data",         "DataType");
   dataPopup.addItem("NxM array",           "DataType");
   dataPopup.addItem("X/Y/Z data triplets", "DataType");
   dataPopup.setTarget(this);
   dataPopup.setCommand("DataType");
   mainRootView().addSubview(dataPopup);

   // We can prompt for the actual data to be plotted in a text
   // widget if this code is run as an applet, but if it is run
   // as an application we can prompt for a local file to be read.
   if (isApplet()) {

      // Create label and scrolled text view for data input
      TextField labelField2 = new TextField(25, 385, 90, 25);
      labelField2.setBorder(null);
      labelField2.setEditable(false);
      labelField2.setBackgroundColor(Color.lightGray);
      labelField2.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      labelField2.setStringValue("Enter data:");
      mainRootView().addSubview(labelField2);

      scrollView = new ContainerView(0, 0, 250, 5000);
      scrollView.setBorder(null);      
      dataField = new TextView(0, 0, 250, 100);
      dataField.setEditable(false);
      dataField.setBackgroundColor(Color.lightGray);
      dataField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      dataField.setString("");
      scrollView.addSubview(dataField);
      ScrollGroup sgView = new ScrollGroup(100, 385, 250, 34);
      sgView.setBorder(new BezelBorder().groovedBezel());
      sgView.setContentView(scrollView);
      mainRootView().addSubview(sgView);
   
   } else {

      // Create label, filename text component, and button to
      // invoke a file browser
      TextField labelField2 = new TextField(25, 385, 90, 25);
      labelField2.setBorder(null);
      labelField2.setEditable(false);
      labelField2.setBackgroundColor(Color.lightGray);
      labelField2.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      labelField2.setStringValue("Filename:");
      mainRootView().addSubview(labelField2);

      fileField = new TextField(100, 390, 250, 25);
      fileField.setBorder(new BezelBorder().groovedBezel());
      fileField.setEditable(false);
      fileField.setBackgroundColor(Color.lightGray);
      fileField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
      fileField.setStringValue("");
      mainRootView().addSubview(fileField);

      browseButton = new Button(360, 385, 65, 25);
      browseButton.setTitle("Browse...");
      browseButton.setTarget(this);
      browseButton.setCommand("Browse");
      mainRootView().addSubview(browseButton);
   
   }

   // Create plot button to draw graph
   plotButton = new Button(25, 435, 65, 25);
   plotButton.setTitle("Plot");
   plotButton.setTarget(this);
   plotButton.setCommand("Plot");
   mainRootView().addSubview(plotButton);

   // Create button to invoke new window with plot option
   optionButton = new Button(100, 435, 65, 25);
   optionButton.setTitle("Options...");
   optionButton.setTarget(this);
   optionButton.setCommand("Options");
   mainRootView().addSubview(optionButton);
   
   // Create a text field for status messages
   statusField = new TextField(25, 470, 400, 25);
   statusField.setBorder(null);
   statusField.setEditable(false);
   statusField.setBorder(new BezelBorder().groovedBezel());
   statusField.setBackgroundColor(Color.lightGray);
   statusField.setFont(Font.fontNamed("Helvetica", Font.PLAIN, 12));
   statusField.setStringValue("");
   mainRootView().addSubview(statusField);
   
   }
    
    /** Method to dispatch all commands.
      */
    public void performCommand(String command, Object arg) {
    if      (command.equals("DataType")) DataType(arg);
    else if (command.equals("Browse"))   Browse(arg);
    else if (command.equals("Plot"))     Plot(arg);
    else if (command.equals("Options"))  Options(arg);
    else if (command.equals("BgColor"))  BgColor(arg);
    else if (command.equals("LnColor"))  LnColor(arg);
    else if (command.equals("NLevel"))   NLevel(arg);
    else if (command.equals("Filled"))   Filled(arg);
    }

    /** This method is invoked when the Data Popup is pressed.
      */
    public void DataType(Object arg) {
       
       // Save the data type selected
       datatype = dataPopup.selectedIndex();
       
       // Make the file/data field editable/non-editable as
       // appropriate.
       if (!isApplet()) {
          if (datatype >= 1) {
             fileField.setBackgroundColor(Color.white);
             if (!fileField.isEditable()) fileField.setEditable(true);
          } else {
             fileField.setBackgroundColor(Color.lightGray);
             if ( fileField.isEditable()) {
                fileField.cancelEditing();
                fileField.setEditable(false);
             }
          }
          fileField.draw();
       } else {
          if (datatype >= 1) {
             dataField.setBackgroundColor(Color.white);
             scrollView.setBackgroundColor(Color.white);
             if (!dataField.isEditable()) dataField.setEditable(true);
          } else {
             dataField.setBackgroundColor(Color.lightGray);
             scrollView.setBackgroundColor(Color.lightGray);
             if ( dataField.isEditable()) {
                dataField.setEditable(false);
             }
          }
          dataField.draw();
       }
    } 

    /** This method is invoked when the Data Popup is pressed.
      * It invokes a modal FileChooser dialog.
      */
    public void Browse(Object arg) {
       FileChooser fc = new FileChooser(mainRootView(), 
          "Select ASCII data file", FileChooser.LOAD_TYPE);
       fc.showModally();
       if (fc != null) fileField.setStringValue(fc.file());
    }
    
    /** This method is invoked when the Plot button is pressed.
      */
    public void Plot(Object arg) {
    
         int xsize;
         int ysize;
    
         // Reset and set some default attributes of the plot component
         cont.reset();
         cont.setTitle( "WaveContour Test" );
         cont.setXTitle( "X Axes" );
         cont.setYTitle( "Y Axes" );
         cont.TEK_COLOR();
         cont.setSpline(true);
         cont.setBackground(bgcolor);
         cont.setColor(lncolor);
         cont.setFilled(filled);
         cont.setNLevels(nlevel);
         
         int[] cols = new int[20];
         for (int i=1; i<20; i++) cols[i] = i+1;
         cont.setColor_Index(cols);
         
         // Set the data for the plot component and create plot   
         switch (datatype)
         {   
             // Random data
             case 0: {  double[] data = new double[121];
                        for(int i =0; i<121; i++) data[i]=Math.random() * 100.0 + 100.0;
                        cont.setGrid(false);
                        cont.setZ( data, 11, 11 );
                        showStatus("Calling PV-WAVE ...");
                        cont.plot();
                        showStatus("");
                        break;
                     }
             
             // NxM Array
             case 1: {  Vector vdata = new Vector();
             
                        // For an applet read from the text widget
                        if (isApplet()) {
                              try {
                                 StreamTokenizer strm = new StreamTokenizer(
                                    new StringBufferInputStream(dataField.string()));
                                 strm.wordChars(0, ' ');
                                 strm.whitespaceChars(',', ',');
                                 int tok;
                                 
                                 // Get array size
                                 tok = strm.nextToken();
                                 xsize = (int) strm.nval;
                                 tok = strm.nextToken();
                                 ysize = (int) strm.nval;
                                 
                                 while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                    if (tok == strm.TT_NUMBER) {
                                       vdata.addElement(new Double(strm.nval));
                                    }
                                 }
                              } catch (IOException e) {
                                 System.err.println(e);
                                 return;
                              }
                              
                              // Set the Y data and plot the data
                              cont.setZ( vdata, xsize, ysize );
                              showStatus("Calling PV-WAVE ...");
                              cont.plot();
                              showStatus("");
                              break;
                              
                        } else {
                      
                           // For an application read the data from a file
                           if (!fileField.stringValue().equals("")) {
                              File dataFile = new File(fileField.stringValue());
                              if (dataFile.exists()) {
                                 try {
                                    StreamTokenizer strm = new StreamTokenizer(
                                       new FileInputStream(fileField.stringValue()));
                                    strm.wordChars(0, ' ');
                                    strm.whitespaceChars(',', ',');
                                    int tok;
                                    
                                    // Get array size
                                    tok = strm.nextToken();
                                    xsize = (int) strm.nval;
                                    tok = strm.nextToken();
                                    ysize = (int) strm.nval;
                                    
                                    while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                       if (tok == strm.TT_NUMBER) {
                                          vdata.addElement(new Double(strm.nval));
                                       }
                                    }
                                 } catch (IOException e) {
                                    System.err.println(e);
                                    return;
                                 }
                              
                                 // Set the Y data and plot the data
                                 cont.setZ( vdata, xsize, ysize );                              
                                 showStatus("Calling PV-WAVE ...");
                                 cont.plot();
                                 showStatus("");
                              }
                           } else {
                              showStatus("Invalid filename entered: "+fileField.stringValue());
                           }
                           break;
                        }
                     }
                     
             // XYZ Data values
             case 2: {  Vector vxdata = new Vector();
                        Vector vydata = new Vector();
                        Vector vzdata = new Vector();
                        
                        // For an applet read from the text widget
                        if (isApplet()) {
                              try {
                                 StreamTokenizer strm = new StreamTokenizer(
                                    new StringBufferInputStream(dataField.string()));
                                 strm.wordChars(0, ' ');
                                 strm.whitespaceChars(',', ',');
                                 int tok;
                                 int cnt = 0;                                 
                                 while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                    if (tok == strm.TT_NUMBER) {
                                       switch (cnt % 3) {
                                          case 0: {  vxdata.addElement(new Double(strm.nval));
                                                     break;
                                                  } 
                                          case 1: {  vydata.addElement(new Double(strm.nval));
                                                     break;
                                                  } 
                                          case 2: {  vzdata.addElement(new Double(strm.nval));
                                                     break;
                                                  } 
                                       }
                                       cnt ++;
                                    }
                                 }
                              } catch (IOException e) {
                                 System.err.println(e);
                                 return;
                              }
                              
                              // Set the X and Y data and plot the data                        
                              cont.setGrid( true );
                              cont.setX( vxdata );
                              cont.setY( vydata );
                              cont.setZ( vzdata );
                              showStatus("Calling PV-WAVE ...");
                              cont.plot();
                              showStatus("");
                              break;
                              
                        } else {
                         
                           // For an application read the data from a file
                           if (!fileField.stringValue().equals("")) {
                              File dataFile = new File(fileField.stringValue());
                              if (dataFile.exists()) {
                                 try {
                                    StreamTokenizer strm = new StreamTokenizer(
                                       new FileInputStream(fileField.stringValue()));
                                    strm.wordChars(0, ' ');
                                    strm.whitespaceChars(',', ',');
                                    int tok;
                                    int cnt = 0;
                                    while ((tok = strm.nextToken()) != strm.TT_EOF) {
                                       if (tok == strm.TT_NUMBER) {
                                          switch (cnt %3) {
                                             case 0: vxdata.addElement(new Double(strm.nval)); 
                                             case 1: vydata.addElement(new Double(strm.nval)); 
                                             case 2: vzdata.addElement(new Double(strm.nval)); 
                                          }
                                          cnt ++;
                                       }
                                    }
                                 } catch (IOException e) {
                                    System.err.println(e);
                                    return;
                                 }
                                                         
                                 // Set the X and Y data and plot the data
                                 cont.setGrid( true );
                                 cont.setX( vxdata );
                                 cont.setY( vydata );
                                 cont.setZ( vzdata );                              
                                 showStatus("Calling PV-WAVE ...");
                                 cont.plot();
                                 showStatus("");
                              }
                           } else {
                              showStatus("Invalid filename entered: "+fileField.stringValue());
                           }
                           break;
                        }
                     }
         }
    }

    /** This method is invoked when the Data Popup is pressed.
      * It creates a dialog to allow a few of the attributes associated
      * with this plot type to be modified.
      */
    public void Options(Object arg) {
    
       // Don't create a new window if one is already displayed
       if ((window == null) || (!window.isVisible())) {
       
       window = new InternalWindow(40, 40, 200, 160);

       window.setTitle("Attributes");
       window.setResizable(true);
       window.setCloseable(true);

       // Reset settings
       bgcolor = "black";
       lncolor = "white";
       filled  = true;
       nlevel  = 9;

       // Background color

       TextField bgcolorField = new TextField(5, 5, 100, 24);
       bgcolorField.setBorder(null);
       bgcolorField.setEditable(false);
       bgcolorField.setBackgroundColor(Color.lightGray);
       bgcolorField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       bgcolorField.setStringValue("Background");
       window.addSubview(bgcolorField);
       
       bgcolorPopup = new Popup(100, 5, 90, 24);
       bgcolorPopup.addItem("black", "BgColor");
       bgcolorPopup.addItem("green", "BgColor");
       bgcolorPopup.addItem("red", "BgColor");
       bgcolorPopup.addItem("blue", "BgColor");
       bgcolorPopup.addItem("lightGray", "BgColor");
       bgcolorPopup.addItem("white", "BgColor");
       bgcolorPopup.addItem("cyan", "BgColor");
       bgcolorPopup.addItem("magenta", "BgColor");
       bgcolorPopup.addItem("yellow", "BgColor");
       bgcolorPopup.addItem("darkGray", "BgColor");
       bgcolorPopup.addItem("orange", "BgColor");
       bgcolorPopup.addItem("gray", "BgColor");
       bgcolorPopup.addItem("pink", "BgColor");
       bgcolorPopup.setTarget(this);
       bgcolorPopup.setCommand("BgColor");
       window.addSubview(bgcolorPopup);

       // Line color

       TextField lncolorField = new TextField(5, 35, 100, 24);
       lncolorField.setBorder(null);
       lncolorField.setEditable(false);
       lncolorField.setBackgroundColor(Color.lightGray);
       lncolorField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       lncolorField.setStringValue("Line Color");
       window.addSubview(lncolorField);
       
       lncolorPopup = new Popup(100, 35, 90, 24);
       lncolorPopup.addItem("black", "LnColor");
       lncolorPopup.addItem("green", "LnColor");
       lncolorPopup.addItem("red", "LnColor");
       lncolorPopup.addItem("blue", "LnColor");
       lncolorPopup.addItem("lightGray", "LnColor");
       lncolorPopup.addItem("white", "LnColor");
       lncolorPopup.addItem("cyan", "LnColor");
       lncolorPopup.addItem("magenta", "LnColor");
       lncolorPopup.addItem("yellow", "LnColor");
       lncolorPopup.addItem("darkGray", "LnColor");
       lncolorPopup.addItem("orange", "LnColor");
       lncolorPopup.addItem("gray", "LnColor");
       lncolorPopup.addItem("pink", "LnColor");
       lncolorPopup.selectItemAt(5);
       lncolorPopup.setTarget(this);
       lncolorPopup.setCommand("LnColor");
       window.addSubview(lncolorPopup);

       // # contours

       TextField nlevelField = new TextField(5, 65, 100, 24);
       nlevelField.setBorder(null);
       nlevelField.setEditable(false);
       nlevelField.setBackgroundColor(Color.lightGray);
       nlevelField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       nlevelField.setStringValue("# of Levels");
       window.addSubview(nlevelField);
       
       nlevelPopup = new Popup(100, 65, 90, 24);
       nlevelPopup.addItem("3", "NLevel");
       nlevelPopup.addItem("6", "NLevel");
       nlevelPopup.addItem("9", "NLevel");
       nlevelPopup.addItem("12", "NLevel");
       nlevelPopup.addItem("15", "NLevel");
       nlevelPopup.selectItemAt(2);       
       nlevelPopup.setTarget(this);
       nlevelPopup.setCommand("NLevel");
       window.addSubview(nlevelPopup);

       // filled

       TextField filledField = new TextField(5, 95, 100, 24);
       filledField.setBorder(null);
       filledField.setEditable(false);
       filledField.setBackgroundColor(Color.lightGray);
       filledField.setFont(Font.fontNamed("Courier", Font.PLAIN, 12));
       filledField.setStringValue("Filled");
       window.addSubview(filledField);
       
       filledPopup = new Popup(100, 95, 90, 24);
       filledPopup.addItem("Yes", "Filled");
       filledPopup.addItem("No", "Filled");
       filledPopup.setTarget(this);
       filledPopup.setCommand("Filled");
       window.addSubview(filledPopup);

       window.contentView().layoutView(0, 0);
       window.show();
    }
    }

    /** Method to change plot attribute
      */
    public void BgColor(Object arg) {
         bgcolor = bgcolorPopup.selectedItem().title();
    }

    /** Method to change plot attribute
      */
    public void LnColor(Object arg) {
         lncolor = lncolorPopup.selectedItem().title();
    }

    /** Method to change plot attribute
      */
    public void NLevel(Object arg) {
         nlevel = nlevelPopup.selectedIndex() * 3 + 3;
    }

    /** Method to change plot attribute
      */
    public void Filled(Object arg) {
         if (filledPopup.selectedIndex() == 0) filled = true; else filled = false;
    }
    
    /** Update the text displayed in the status field
      */
    public void showStatus(String status) {
    statusField.setStringValue(status);
    }

    /** Main method required when run as an application
      * rather than an applet.
      */
    public static void main(String args[]) {
        contour app;
        ExternalWindow mainWindow;
        Size size;

        app = new contour();
        mainWindow = new ExternalWindow();
        size = mainWindow.windowSizeForContentSize(450, 500);
        mainWindow.sizeTo(size.width, size.height);
        mainWindow.show();
        app.setMainRootView(mainWindow.rootView());

        app.run();
    }


TextField  titleField;
WaveContour cont;
Popup      dataPopup;
int        datatype=0;
TextView   dataField;
ContainerView scrollView;
TextField  fileField;
Button     browseButton;
Button     optionButton;
Button     plotButton;
TextField  statusField;
InternalWindow window;
Popup      bgcolorPopup;
Popup      lncolorPopup;
Popup      nlevelPopup;
Popup      filledPopup;
String     bgcolor = "black";
String     lncolor = "white";
int        nlevel = 9;
boolean    filled = true;

}
