// NetscapeApplet.java
// Copyright 1996 Netscape Communications Corp.  All rights reserved.

import netscape.application.*;
import netscape.util.*;

public class NetscapeApplet extends FoundationApplet {
    /** This method must be implemented by the applet developer because
      * there is no way in the standard Java API for system classes (like
      * netscape_beta.foundation) to look up an applet's class by name. The
      * static method Class.ForName() simply looks up one level in the stack
      * and gets the ClassLoader associated with the method block of the
      * caller. When the netscape_beta.foundation classes are installed as
      * system classes their ClassLoader is null, so when code in
      * netscape_beta.foundation calls Class.forName() it can only find
      * other system classes. What is needed is API which allows code to
      * find the ClassLoader for an applet by URL, and public API on
      * ClassLoader to ask it to load classes by name. Until those
      * enhancements can be made and distributed in all the java systems
      * in the world, applets will have to subclass FoundationApplet and
      * implement this one-line method:
      * <pre>
      *     public abstract Class classForName(String className)
      *         throws ClassNotFoundException {
      *         return Class.forName(className);
      *     }
      * </pre>
      */
    public Class classForName(String className)
        throws ClassNotFoundException {
        return Class.forName(className);
    }
}
