/*                                                
 * @(#)VisualNumerics.wave  1.00 96/09/24 Steve Lang
 * 
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 */

package VisualNumerics.wave;

/**
 * A class for creating VRML surface plots.
 *
 * This class encapsulates the PV-WAVE <tt>VRMLSurface</tt> command
 * and all of the associated positional parameters and keywords
 * and produces a VRML surface plot in a new container.
 * <tt>VRMLSurface</tt> is part of the "Wave on the Web" toolkit.<p>
 *
 * Methods for setting all of the parameters/keywords have the form 
 * <tt>setKeyword(arg1, arg2, ...)</tt> where "Keyword" is the parameter
 * or keyword name from the PV-WAVE documentation.  See the WaveGraph
 * class documentation for information on these methods.<p>
 *
 * This class also handles the communication between the applet and a PV-WAVE
 * graphic server running on the web server that served the java applet.
 *
 * @version 2.00, 4 Dec 1996
 * @author  Steve Lang
 * @see WaveGraph#setX
 * @see WaveGraph#setY
 * @see WaveGraph#setZ
 * @see WaveGraph#setGrid
 * @see WaveGraph#setGridNx
 * @see WaveGraph#setGridNy
 * @see WaveGraph#setGridNghbr
 * @see WaveGraph#TEK_COLOR
 * @see WaveGraph#LOADCT
 * @see WaveGraph#setAx
 * @see WaveGraph#setAz
 * @see WaveGraph#setCharsize
 * @see WaveGraph#setCharthick
 * @see WaveGraph#setColor
 * @see WaveGraph#setData
 * @see WaveGraph#setDevice
 * @see WaveGraph#setNormal
 * @see WaveGraph#setFont
 * @see WaveGraph#setLinestyle
 * @see WaveGraph#setNodata
 * @see WaveGraph#setPosition
 * @see WaveGraph#setRegion
 * @see WaveGraph#setTitle
 * @see WaveGraph#setSubtitle
 * @see WaveGraph#setThick
 * @see WaveGraph#setTicklen
 * @see WaveGraph#setYnozero
 * @see WaveGraph#setXCharsize
 * @see WaveGraph#setXGridstyle
 * @see WaveGraph#setXMinor
 * @see WaveGraph#setXRange
 * @see WaveGraph#setXStyle
 * @see WaveGraph#setXTicklen
 * @see WaveGraph#setXTicks
 * @see WaveGraph#setXTitle
 * @see WaveGraph#setXType
 * @see WaveGraph#setYCharsize
 * @see WaveGraph#setYGridstyle
 * @see WaveGraph#setYMinor
 * @see WaveGraph#setYRange
 * @see WaveGraph#setYStyle
 * @see WaveGraph#setYTicklen
 * @see WaveGraph#setYTicks
 * @see WaveGraph#setYTitle
 * @see WaveGraph#setYType
 * @see WaveGraph#setZCharsize
 * @see WaveGraph#setZGridstyle
 * @see WaveGraph#setZMinor
 * @see WaveGraph#setZRange
 * @see WaveGraph#setZStyle
 * @see WaveGraph#setZTicklen
 * @see WaveGraph#setZTicks
 * @see WaveGraph#setZTitle
 * @see WaveGraph#setZType
 * @see WaveGraph#setFile
 */
public class WaveVRMLSurface extends WaveGraph
{  
   /**
    * Creates a frame of the requested size
    * @param x  the x location of the View
    * @param y  the x location of the View
    * @param xs the with of the View
    * @param ys the height of the View
    */
   public WaveVRMLSurface()
   {  super( 0, 0, 0, 0 );
   
      // The constructor is overridden to change the
      // file type to ".wrl" for VRML.
      file = "tmp"+id+".1.wrl";
      fileext = ".wrl";
   }
   
   /**
    * Connects to the PV-WAVE server and creates the graphic
    * display and displays it in the container.
    */
   public void plot()
   {
      // Set the graph type
      addGraph("WaveVRMLSurface");

      // Add the data to plot
      addX();
      addY();
      addZ();

      // Add some special tags just for VRMLSurface
      addWireframe();
      addShades();
      addLight();

      // Load color tables
      addTEK_COLOR();
      addLOADCT();

       // Add gridding info
      addGrid();
      addGridNx();
      addGridNy();
      addGridNghbr();      

      // Add all keywords supported for this plot type
      addAx();
      addAz();
      addCharsize();
      addCharthick();
      addColor();
      addData();
      addDevice();
      addNormal();
      addFont();
      addLinestyle();
      addNodata();
      addPosition();
      addRegion();
      addTitle();
      addSubtitle();
      addThick();
      addTicklen();
      addYnozero();

      addXCharsize();
      addXGridstyle();
      addXMinor();
      addXRange();
      addXStyle();
      addXTicklen();
      addXTicks();
      addXTitle();
      addXType();

      addYCharsize();
      addYGridstyle();
      addYMinor();
      addYRange();
      addYStyle();
      addYTicklen();
      addYTicks();
      addYTitle();
      addYType();

      addZCharsize();
      addZGridstyle();
      addZMinor();
      addZRange();
      addZStyle();
      addZTicklen();
      addZTicks();
      addZTitle();
      addZType();

      // Call the Wave graphic server
      callWave();
   }      

   /**
    * Overide the drawView method with a dummy method since the VRML does not 
    * draw anything into the container
    */
   public void drawView(netscape.application.Graphics g)
   {
   }

   /**
    * Flag to set Wireframe vrs Shaded Surface representation
    */
   public void setWireframe( boolean flag )
   {  wireframe = flag;
   }


   /**
    * Set the color of the VRML surface. Valid indicies are 0-32 
    * which uses colors from the PV-WAVE TEK_COLOR palette.
    */
   public void setShades( int col )
   {  vrmlshades = col;
   }

   /**
    * Set the position of a light source in 3D coordinates
    */
   public void setLight( double x, double y, double z )
   {  xlight = x;
      ylight = y;
      zlight = z;
   }

   void addWireframe()
   {  if (wireframe) tags = tags + "Wireframe\tI\t1\n"; }

   void addShades()
   {  if (vrmlshades != 999) tags = tags + "Shades\tI\t" + vrmlshades + "\n"; }

   void addLight()
   {  if (xlight != 999.0) tags = tags + "Light\tF\t" + 
         xlight + "\t" + ylight + "\t" + zlight + "\n"; }

   /**
    * Reset all PV-WAVE plot attributes and data
    */      
   public void reset()
   {
   super.reset();
   int      wireframe    = 999;
   int      vrmlshades   = 999;
   double   xlight       = 999.0;
   double   ylight       = 999.0;
   double   zlight       = 999.0;
   }

   protected boolean  wireframe    = false;
   protected int      vrmlshades   = 999;
   protected double   xlight       = 999.0;
   protected double   ylight       = 999.0;
   protected double   zlight       = 999.0;

}
