/*                                                
 * @(#)VisualNumerics.wave  1.00 96/09/24 Steve Lang
 * 
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 */

package VisualNumerics.wave;

/**
 * A class for creating wireframe surface plots.
 *
 * This class encapsulates the PV-WAVE <tt>SURFACE</tt> command
 * and all of the associated positional parameters and keywords
 * and produces a surface plot in a new container.<p>
 *
 * Methods for setting all of the parameters/keywords have the form 
 * <tt>setKeyword(arg1, arg2, ...)</tt> where "Keyword" is the parameter
 * or keyword name from the PV-WAVE documentation.  See the WaveGraph
 * class documentation for information on these methods.<p>
 *
 * This class also handles the communication between the applet and a PV-WAVE
 * graphic server running on the web server that served the java applet.
 *
 * @version 1.00, 24 Sep 1996
 * @author  Steve Lang
 * @see WaveGraph#setX
 * @see WaveGraph#setY
 * @see WaveGraph#setZ
 * @see WaveGraph#setGrid
 * @see WaveGraph#setGridNx
 * @see WaveGraph#setGridNy
 * @see WaveGraph#setGridNghbr
 * @see WaveGraph#TEK_COLOR
 * @see WaveGraph#LOADCT
 * @see WaveGraph#setBackground
 * @see WaveGraph#setAx
 * @see WaveGraph#setAz
 * @see WaveGraph#setCharsize
 * @see WaveGraph#setCharthick
 * @see WaveGraph#setColor
 * @see WaveGraph#setData
 * @see WaveGraph#setDevice
 * @see WaveGraph#setNormal
 * @see WaveGraph#setFont
 * @see WaveGraph#setLinestyle
 * @see WaveGraph#setNodata
 * @see WaveGraph#setPosition
 * @see WaveGraph#setRegion
 * @see WaveGraph#setTitle
 * @see WaveGraph#setSubtitle
 * @see WaveGraph#setThick
 * @see WaveGraph#setTicklen
 * @see WaveGraph#setYnozero
 * @see WaveGraph#setXCharsize
 * @see WaveGraph#setXGridstyle
 * @see WaveGraph#setXMinor
 * @see WaveGraph#setXRange
 * @see WaveGraph#setXStyle
 * @see WaveGraph#setXTicklen
 * @see WaveGraph#setXTicks
 * @see WaveGraph#setXTitle
 * @see WaveGraph#setXType
 * @see WaveGraph#setYCharsize
 * @see WaveGraph#setYGridstyle
 * @see WaveGraph#setYMinor
 * @see WaveGraph#setYRange
 * @see WaveGraph#setYStyle
 * @see WaveGraph#setYTicklen
 * @see WaveGraph#setYTicks
 * @see WaveGraph#setYTitle
 * @see WaveGraph#setYType
 * @see WaveGraph#setZCharsize
 * @see WaveGraph#setZGridstyle
 * @see WaveGraph#setZMinor
 * @see WaveGraph#setZRange
 * @see WaveGraph#setZStyle
 * @see WaveGraph#setZTicklen
 * @see WaveGraph#setZTicks
 * @see WaveGraph#setZTitle
 * @see WaveGraph#setZType
 * @see WaveGraph#setFile
 */
public class WaveSurface extends WaveGraph
{  
   /**
    * Creates a frame of the requested size
    * @param x  the x location of the View
    * @param y  the x location of the View
    * @param xs the with of the View
    * @param ys the height of the View
    */
   public WaveSurface( int x, int y, int xsize, int ysize )
   {  super( x, y, xsize, ysize );
   }
   
   /**
    * Connects to the PV-WAVE server and creates the graphic
    * display and displays it in the container.
    */
   public void plot()
   {
      // Set the graph type
      addGraph("WaveSurface");

      // Add the data to plot
      addX();
      addY();
      addZ();
      
      // Add gridding info
      addGrid();
      addGridNx();
      addGridNy();
      addGridNghbr();

      // Load color tables
      addTEK_COLOR();
      addLOADCT();
      
      // Add all keywords supported for this plot type
      addBackground();      
      addAx();
      addAz();
      addCharsize();
      addCharthick();
      addColor();
      addData();
      addDevice();
      addNormal();
      addFont();
      addLinestyle();
      addNodata();
      addPosition();
      addRegion();
      addTitle();
      addSubtitle();
      addThick();
      addTicklen();
      addYnozero();

      addXCharsize();
      addXGridstyle();
      addXMinor();
      addXRange();
      addXStyle();
      addXTicklen();
      addXTicks();
      addXTitle();
      addXType();

      addYCharsize();
      addYGridstyle();
      addYMinor();
      addYRange();
      addYStyle();
      addYTicklen();
      addYTicks();
      addYTitle();
      addYType();

      addZCharsize();
      addZGridstyle();
      addZMinor();
      addZRange();
      addZStyle();
      addZTicklen();
      addZTicks();
      addZTitle();
      addZType();

      // Call the Wave graphic server
      callWave();
   }      
}
