/*                                                
 * @(#)VisualNumerics.wave  1.00 96/09/24 Steve Lang
 * 
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 */

package VisualNumerics.wave;

/**
 * A class for creating wireframe Contour plots.
 *
 * This class encapsulates the PV-WAVE <tt>CONTOUR</tt> and 
 * <tt>CONTOURFILL</tt> commands 
 * and all of the associated positional parameters and keywords
 * and produces a Contour plot in a new container.<p>
 *
 * Methods for setting all of the parameters/keywords have the form 
 * <tt>setKeyword(arg1, arg2, ...)</tt> where "Keyword" is the parameter
 * or keyword name from the PV-WAVE documentation.  See the WaveGraph
 * class documentation for information on these methods.<p>
 *
 * This class also handles the communication between the applet and a PV-WAVE
 * graphic server running on the web server that served the java applet.
 *
 * @version 2.00, 4 Dec 1996
 * @author  Steve Lang
 * @see WaveGraph#setX
 * @see WaveGraph#setY
 * @see WaveGraph#setZ
 * @see WaveGraph#setGrid
 * @see WaveGraph#setGridNx
 * @see WaveGraph#setGridNy
 * @see WaveGraph#setGridNghbr
 * @see WaveGraph#setBackground
 * @see WaveGraph#TEK_COLOR
 * @see WaveGraph#LOADCT
 * @see WaveGraph#setCharsize
 * @see WaveGraph#setCharthick
 * @see WaveGraph#setColor
 * @see WaveGraph#setData
 * @see WaveGraph#setDevice
 * @see WaveGraph#setNormal
 * @see WaveGraph#setFont
 * @see WaveGraph#setNodata
 * @see WaveGraph#setPosition
 * @see WaveGraph#setRegion
 * @see WaveGraph#setTitle
 * @see WaveGraph#setSubtitle
 * @see WaveGraph#setThick
 * @see WaveGraph#setTicklen
 * @see WaveGraph#setXCharsize
 * @see WaveGraph#setXMinor
 * @see WaveGraph#setXRange
 * @see WaveGraph#setXStyle
 * @see WaveGraph#setXTicklen
 * @see WaveGraph#setXTicks
 * @see WaveGraph#setXTitle
 * @see WaveGraph#setXType
 * @see WaveGraph#setYCharsize
 * @see WaveGraph#setYMinor
 * @see WaveGraph#setYRange
 * @see WaveGraph#setYStyle
 * @see WaveGraph#setYTicklen
 * @see WaveGraph#setYTicks
 * @see WaveGraph#setYTitle
 * @see WaveGraph#setYType
 * @see WaveGraph#setFile
 */
public class WaveContour extends WaveGraph
{  
   /**
    * Creates a frame of the requested size
    * @param x  the x location of the View
    * @param y  the x location of the View
    * @param xs the with of the View
    * @param ys the height of the View
    */
   public WaveContour( int x, int y, int xsize, int ysize )
   {  super( x, y, xsize, ysize );
   }
   
   /**
    * Connects to the PV-WAVE server and creates the graphic
    * display and displays it in the container.
    */
   public void plot()
   {
      // Set the graph type
      addGraph("WaveContour");

      // Add the data to plot
      addX();
      addY();
      addZ();

      // Load color tables
      addTEK_COLOR();
      addLOADCT();
 
       // Add gridding info
      addGrid();
      addGridNx();
      addGridNy();
      addGridNghbr();
      
      // Add all unique keywords supported for this plot type
      addBackground();
      addC_Annotation();
      addC_Charsize();
      addC_Colors();
      addC_Labels();
      addC_Linestyle();
      addC_Thick();
      addFollow();
      addNLevels();
      addSpline();
      addFilled();
      addColor_Index();
      
      // Add all keywords supported for this plot type
      // from WaveGraph
      addCharsize();
      addCharthick();
      addColor();
      addData();
      addDevice();
      addNormal();
      addFont();
      addNodata();
      addPosition();
      addRegion();
      addTitle();
      addSubtitle();
      addThick();
      addTicklen();

      addXCharsize();
      addXMinor();
      addXRange();
      addXStyle();
      addXTicklen();
      addXTicks();
      addXTitle();
      addXType();

      addYCharsize();
      addYMinor();
      addYRange();
      addYStyle();
      addYTicklen();
      addYTicks();
      addYTitle();
      addYType();

      // Call the Wave graphic server
      callWave();
   }


   // Set methods unique to this class
   
   /**
    * Set the contour labels
    */
   public void setC_Annotation(String[] labels)
   {  c_annotation = labels;
   }

   /**
    * Set character size for contour labels (default is 0.75 of normal text)
    */
   public void setC_Charsize( double siz )
   {  c_charsize = siz;
   }

   /**
    * Set the contour line colors
    */
   public void setC_Colors(int[] colors)
   {  c_colors = colors;
   }

   /**
    * Specify which contour lines to label
    */
   public void setC_Labels(int[] labels)
   {  c_labels = labels;
   }

   /**
    * Set the contour line linestyle
    */
   public void setC_Linestyle(int[] linestyle)
   {  c_linestyle = linestyle;
   }
                      
   /**
    * Set contour line thickness (default = 1 pixel)
    */
   public void setC_Thick( double thick )
   {  c_thick = thick;
   }

   /**
    * Set contour method to line-following vrs cell-drawing (default)
    */
   public void setFollow( boolean flag )
   {  follow = flag;
   }

   /**
    * Set number of contour levels (default = 6)
    */
   public void setNLevels( int count )
   {  nlevels = count;;
   }

   /**
    * Set contour interpolation to spline (implies setFollow(true))
    */
   public void setSpline( boolean flag )
   {  spline = flag;
   }

   /**
    * Set filled contours
    */
   public void setFilled( boolean flag )
   {  filled = flag;
   }

   /**
    * Set the contour fill colors
    */
   public void setColor_Index(int[] colors)
   {  color_index = colors;
   }


   // Add methods used by this class

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addC_Annotation()
   {  if (c_annotation.length > 1) {
         tags = tags + "C_Annotation\tF";
         for (int i=0; i < c_annotation.length; i++)
            tags = tags + "\t" + c_annotation[i];
         tags = tags + "\n";
      } 
   }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addC_Charsize()
   {  if (c_charsize != 999.0) tags = tags + "C_Charsize\tF\t" + c_charsize + "\n"; }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addC_Colors()
   {  if (c_colors != null) { 
         if (c_colors.length >= 1) {
            tags = tags + "C_Colors\tF";
            for (int i=0; i < c_colors.length; i++)
               tags = tags + "\t" + c_colors[i];
            tags = tags + "\n";
         }
      } 
   }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addC_Labels()
   {  if (c_labels != null) {
         if (c_labels.length >= 1) {
            tags = tags + "C_Labels\tF";
            for (int i=0; i < c_labels.length; i++)
               tags = tags + "\t" + c_labels[i];
            tags = tags + "\n";
         }
      } 
   }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addC_Linestyle()
   {  if (c_linestyle != null) {
         if (c_linestyle.length > 1) {
            tags = tags + "C_Linestyle\tF";
            for (int i=0; i < c_linestyle.length; i++)
               tags = tags + "\t" + c_linestyle[i];
            tags = tags + "\n";
         }
      } 
   }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addC_Thick()
   {  if (c_thick != 999.0) tags = tags + "C_Thick\tF\t" + c_thick + "\n"; }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addFollow()
   {  if (follow) tags = tags + "Follow\tI\t1\n"; }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addNLevels()
   {  if (nlevels != 999) tags = tags + "NLevels\tI\t" + nlevels + "\n"; }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addSpline()
   {  if (spline) tags = tags + "Spline\tI\t1\n"; }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addFilled()
   {  if (filled) tags = tags + "Filled\tI\t1\n"; }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addColor_Index()
   {  if (color_index != null) {
         if (color_index.length >= 1) {
            tags = tags + "Color_Index\tF";
            for (int i=0; i < color_index.length; i++)
               tags = tags + "\t" + color_index[i];
            tags = tags + "\n";
         }
      } 
   }

   /**
    * Reset all PV-WAVE plot attributes and data
    */      
   public void reset()
   {
   super.reset();
   c_annotation = new String[0];
   c_charsize   = 999.0;
   c_colors     = null;
   c_labels     = null;
   c_linestyle  = null;
   c_thick      = 999.0;
   follow       = false;
   nlevels      = 999;
   spline       = false;
   filled       = false;
   color_index  = null;
   }
      
   protected String[] c_annotation;
   protected double   c_charsize  = 999.0;
   protected int[]    c_colors;
   protected int[]    c_labels;
   protected int[]    c_linestyle;
   protected double   c_thick     = 999.0;
   protected boolean  follow      = false;
   protected int      nlevels     = 999;
   protected boolean  spline      = false;
   protected boolean  filled      = false;
   protected int[]    color_index;
            
}
