/*                                                
 * @(#)VisualNumerics.wave  1.00 96/09/24 Steve Lang
 * 
 * Copyright (c) 1996 Visual Numerics Inc. All Rights Reserved.
 *                      Boulder, Colorado, USA
 * This software is confidential information which is proprietary to
 * and a trade secret of Visual Numerics, Inc.  Use, duplication or
 * disclosure is subject to the terms of an appropriate license agreement.
 *  
 * VISUAL NUMERICS MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
 * OR NON-INFRINGEMENT. VNI SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
 * LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR
 * ITS DERIVATIVES.
 */

package VisualNumerics.wave;

/**
 * A class for creating 3D bar charts.
 *
 * This class encapsulates a modified version of the PV-WAVE 
 * <tt>Bar_3D</tt> procedure from the user library
 * and all of the associated positional parameters and keywords
 * and produces a 3D bar chart in a new container.<p>
 *
 * Methods for setting all of the parameters/keywords have the form 
 * <tt>setKeyword(arg1, arg2, ...)</tt> where "Keyword" is the parameter
 * or keyword name from the PV-WAVE documentation.  See the WaveGraph
 * class documentation for information on these methods.<p>
 *
 * The Z data used with this object bust be 2 dimensional, as it
 * represents a grid of bars to be plotted.
 *
 * This class also handles the communication between the applet and a PV-WAVE
 * graphic server running on the web server that served the java applet.
 *
 * @version 2.00, 4 Dec 1996
 * @author  Steve Lang
 * @see WaveGraph#setZ
 * @see WaveGraph#TEK_COLOR
 * @see WaveGraph#LOADCT
 * @see WaveGraph#setAx
 * @see WaveGraph#setAz
 * @see WaveGraph#setBackground
 * @see WaveGraph#setColor
 * @see WaveGraph#setRegion
 * @see WaveGraph#setTitle
 * @see WaveGraph#setXTitle
 * @see WaveGraph#setYTitle
 * @see WaveGraph#setZTitle
 * @see WaveGraph#setFile
 */
public class WaveBar3D extends WaveGraph
{  
   /*
    * Creates a frame of the requested size
    * @param x  the x location of the View
    * @param y  the x location of the View
    * @param xs the with of the View
    * @param ys the height of the View
    */
   public WaveBar3D( int x, int y, int xsize, int ysize )
   {  super( x, y, xsize, ysize );
   }
   
   /**
    * Connects to the PV-WAVE server and creates the graphic
    * display and displays it in the container.
    */
   public void plot()
   {
      // Set the graph type
      addGraph("WaveBar3D");

      // Add the data to plot
      addZ();

      // Load color tables
      addTEK_COLOR();
      addLOADCT();
      
      // Add all unique keywords supported for this plot type
      addRowColors();
      addColumnColors();

      // Add all keywords supported for this plot type
      // from WaveGraph
      addAx();
      addAz();
      addBackground();
      addColor();
      addRegion();
      addTitle();
      addXTitle();
      addYTitle();
      addZTitle();

      // Call the Wave graphic server
      callWave();
   }


   // Set methods unique to this class
   
   /**
    * Set the bar colors for each row of bars.
    */
   public void setRowColors(int[] color)
   {  rowcolors = color;
   }

   /**
    * Set the bar colors for each column of bars.
    */
   public void setColumnColors(int[] color)
   {  columncolors = color;
   }

   // Add methods used by this class

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addRowColors()
   {  if (rowcolors != null) { 
         if (rowcolors.length >= 1) {
            tags = tags + "RowColors\tI";
            for (int i=0; i < rowcolors.length; i++)
               tags = tags + "\t" + rowcolors[i];
            tags = tags + "\n";
         }
      } 
   }

   /**
    * Protected method used by classes derived from WaveGraph
    */   
   protected void addColumnColors()
   {  if (columncolors != null) { 
         if (columncolors.length >= 1) {
            tags = tags + "ColumnColors\tI";
            for (int i=0; i < columncolors.length; i++)
               tags = tags + "\t" + columncolors[i];
            tags = tags + "\n";
         }
      } 
   }

   /**
    * Reset all PV-WAVE plot attributes and data
    */      
   public void reset()
   {
   super.reset();
   rowcolors     = null;
   columncolors  = null;
   }

   protected int[] rowcolors;
   protected int[] columncolors;
}
