

!*  harb.cmd
!*************************************************************************
!*  TERM command script for communications with the Harbinger Network.
!*
!*  usage:  harb argfile
!*     argfile contains the Harbinger logon information
!*
!*************************************************************************
!

retries 2                              ! 3 total attempts
fopen 1, "$1"                          ! open argfile

repeat                                 ! load the logon variables
    freadln 1, inbuf
    setvar in_arg left( inbuf, 2 )
    setvar length len( inbuf ) - 2

    switch
        case in_arg = "1:"             ! send file name */
            setvar outfile midstr( inbuf, 3, length )

        case in_arg = "2:"             ! receive file name */
            setvar infile midstr( inbuf, 3, length )

        case in_arg = "3:"             ! logon id
            setvar logonid midstr( inbuf, 3, length )

        case in_arg = "4:"             ! logon password
            setvar logonpswd midstr( inbuf, 3, length )

        case in_arg = "5:"             ! file transfer switch
                                       !      S = send only
                                       !      R = receive only
                                       !      B = both send and receive
            setvar optionsw midstr( inbuf, 3, length )
            setvar optionsw toupper( optionsw )

        case in_arg = "6:"             ! message log file name
            setvar logfile midstr( inbuf, 3, length )
    endswitch
until feof( 1 )
fclose 1

on abort
    ? "^C operator abort"
    hangup
    quit
endon

DTIMEOUT 60
capture disk $(logfile) on OVERWRITE
capture on

!
!*************************************************************************
!*  Attemptint to connect to the network modem
!*************************************************************************
!

? "\nConnecting to Harbinger Network\n"
baud 2400,n,8,1
call 1-800-677-4282
protocol xmodem

!
!*************************************************************************
!*  Attemptting to logon to the network
!*************************************************************************
!

dwait "LOGON\r", 60
if _timeout
    ? "\nFailed to connect to Harbinger Network...Check the phone number\n"
    capture close
    hangup
    quit
endif

xmit "$(logonid),$(logonpswd)\r"
dwait "EDIREADY\r", 60
if _timeout
    ? "\nFailed to logon to Harbinger Network...Check your parameters...\n"
    capture close
    hangup
    quit
endif

!
!*************************************************************************
!*  Determine if we need to send a file to the network
!*************************************************************************
!
if ( optionsw = "S" or optionsw = "B" )
    iferror fopen 2, outfile
        ? "\nNo Data To Send...\n"
    else
        fseek 2, 0, 2
        setvar filesz ftell( 2 )
        fclose 2

        if ( filesz <= 10 )
            ? "\nNo Data To Send...\n"
        else
            xmit "TRANSFER,X,EDFROM,$(filesz)\r"
            iferror dwait "CONTINUE\r", 120
                ? "\nNetwork failed to respond to TRANSFER request...Data not sent\n"
            else
                capture off
                iferror send $(outfile)
                    capture on
                    ? "\nFile upload to Harbinger failed...\n"
                    capture close
                    hangup
                    quit
                endif
                capture on
                dwait "SAVED\r", 120
                ? "\n    Transmission Successful...\n"
            endif
        endif
    endif
endif

!
!*************************************************************************
!*  Determine if we need to receive a file from the network
!*************************************************************************
!

if ( optionsw = "R" or optionsw = "B" )
    capture on
    xmit "RECEIVE\r"
    dwait "EMPTY|TRANSFER"
    if _retval = 0
        ? "\nNetwork indicates that there is no mail in your mailbox...\n"
    else
        xmit "CONTINUE\r"
        capture off
        iferror rcv $(infile)
            capture on
            ? "\nDownload FAILED...\n"
        else
            capture on
            xmit "SAVED\r"
            ? "\nFile was received successfully...\n"
        endif
    endif
endif

!
!*************************************************************************
!*  Now logoff the network
!*************************************************************************
!

xmit "LOGOFF\r"
capture close
hangup
quit
# 