;**********************************************************************
;*     HARB.ASP for Procomm Plus -                                    *
;*     command file for automatic logon and send/ receive to Harbinger*
;*     Network.  This script does an automatic send/receive to the    *
;*     Network if the outbound file exists.  If it doesn't exist a    *
;*     receive only is performed.                                     *
;*     All of the call logging information is written to a file       *
;*     called harb.log.  This file is deleted at the begining of each *
;*     session automatically.                                         *
;*                                                                    *
;*      DATE WRITTEN: 05-03-93                                        *
;*      REVISED:                                                      *
;*      BY:           Rick L. Leedy                                   *
;*                    American Business Computer                      *
;*   To invoke pcplus and this script from the command line, type:    *
;*          pcplus /fHARB   <enter>                                   *
;*                                                                    *
;*   The following system variables must be updated prior to use:     *
;*                                                                    *
;* BAUDRATE 2400            ;* DESIRED BAUD RATE                      *
;* PORT COM1                ;* The COM port containing the modem      *
;*                                                                    *
;* You will also need to initialize the logon information in the file *
;* LOGON.HAR.  The parameters in this file are:                       *
;*                                                                    *
;* 1: "HARBOUT.DAT"         ;* Harbinger OUTBOUND FILE NAME           *
;* 2: "HARBIN.DAT"          ;* Harbinger INBOUND FILE NAME            *
;* 3: "USER-ID"             ;* USER ID                                *
;* 4: "PASSWORD"            ;* Password                               *
;* 5: "1(###)###-####       ;* Dial Up phone Number                   *
;* 6: "1(###)###-####       ;* Dial Up phone Number NUMBER 2          *
;* 7: "RCVTYPE"             ;* Receive Mode ( Y / N )                 *
;*                                                                    *
;**********************************************************************

DEFINE LOGNAME "HARB.LOG"

STRING LOGONSTR ;*  Logon ID                         *
STRING PASSWRD  ;*  Password                         *
STRING PHONENUM ;*  Phone Number                     *
STRING PHONENM2 ;*  Backup Phone Number              *
STRING INFILE   ;*  Network incomming file name      *
STRING OUTFILE  ;*  Network Outgoing File name       *
STRING RCVTYPE  ;*  Y TO RECEIVE DATA                *
                ;*  N FOR NO RECEIVE                 *

PROC MAIN

    SET BAUDRATE 2400           ;* desired BAUD rate
    SET PORT COM3               ;* COMM port containing the modem
    SET DATABITS 8
    SET PARITY NONE
    SET STOPBITS 1
    SET DUPLEX FULL
    SET MODEM WAITCNCT 30
    SET SOUND OFF
    EMULATE ANSI                  ;* Use ANSI-BBS emulation for ANSI graphics *
    HANGUP                        ;* Make sure we are off-line

    STRING BUFFER
    INTEGER FLEND
    INTEGER X

          ;***************************************************
          ;**                 MAIN PROCEDURE                **
          ;***************************************************

    DELETE INFILE
    FOPEN 0 "LOGON.HAR" "RT"

    WHILE NOT FLEND
        FGETS 0 BUFFER

        STRCMP BUFFER "1:" 2
        IF SUCCESS
            SUBSTR OUTFILE BUFFER 2 34
            STRLEN OUTFILE X
            DEC X
            STRPOKE OUTFILE X 00
        ENDIF

        STRCMP BUFFER "2:" 2
        IF SUCCESS
            STRSET INFILE 00 34
            SUBSTR INFILE BUFFER 2 34
            STRLEN INFILE X
            DEC X
            STRPOKE INFILE X 00
        ENDIF

        STRCMP BUFFER "3:" 2
        IF SUCCESS
            SUBSTR LOGONSTR BUFFER 2 20
            STRLEN LOGONSTR X
            DEC X
            STRPOKE LOGONSTR X 00
        ENDIF

        STRCMP BUFFER "4:" 2
        IF SUCCESS
            SUBSTR PASSWRD BUFFER 2 20
            STRLEN PASSWRD X
            DEC X
            STRPOKE PASSWRD X 00
        ENDIF

        STRCMP BUFFER "5:" 2
        IF SUCCESS
            SUBSTR PHONENUM BUFFER 2 34
        ENDIF

        STRCMP BUFFER "6:" 2
        IF SUCCESS
            SUBSTR PHONENM2 BUFFER 2 34
        ENDIF

        STRCMP BUFFER "7:" 2
        IF SUCCESS
            SUBSTR RCVTYPE BUFFER 2 1
            STRUPR RCVTYPE          ;* Convert to uppercase
        ENDIF

        EOF 0 FLEND
    ENDWHILE

    FCLOSE 0

    ;***************END OF INITIALIZATION SECTION  **************************

    ;************************************************************************

    DELETE LOGNAME            ;* Remove old log file
    LOG OPEN LOGNAME

    MESSAGE "`n                    Dialing the Harbinger Network...`n"
    TRANSMIT "ATDT "
    TRANSMIT PHONENUM
    TRANSMIT "^M"             ;* Dial Up Phone Number
    WAITFOR "CONNECT" 45
    IF NOT WAITFOR
        MESSAGE "`n   FAILED TO CONNECT TO MAIN PHONE NUMBER...`n"
        MESSAGE "`n   TRYING SECOND PHONE NUMBER...`n"
        HANGUP
        TRANSMIT "ATDT "
        TRANSMIT PHONENM2      ;* Dial Up phone Number 2
        TRANSMIT "^M"
        WAITFOR "CONNECT" 45
        IF NOT WAITFOR
            CALL ERROR WITH 1
        ENDIF
    ENDIF

    PAUSE 3
    TRANSMIT "^M"
    WAITFOR "LOGON^M" 60
    IF NOT WAITFOR
        CALL ERROR WITH 2
    ENDIF

    TRANSMIT LOGONSTR
    TRANSMIT ","
    TRANSMIT PASSWRD
    TRANSMIT "^M"

    WAITFOR "EDIREADY^M" 60
    IF NOT WAITFOR
        CALL ERROR WITH 4
    ENDIF

            ;************************************************************
            ;*           Check for, prepare, and send a file            *
            ;************************************************************

    ISFILE OUTFILE
    IF SUCCESS
        LONG   L
        STRING FILESZ

        FOPEN 0 OUTFILE "RB"
        FSEEK 0 0 2
        FTELL 0 L
        FCLOSE 0
        LTOA L FILESZ

        TRANSMIT "TRANSFER,X,EDFROM,"
        TRANSMIT FILESZ
        TRANSMIT "^M"
        WAITFOR "CONTINUE^M" 120

        LOG SUSPEND

        IF WAITFOR
            SENDFILE XMODEM OUTFILE
            LOG RESUME
            IF FAILURE
                CALL ERROR WITH 6
            ELSE
                WAITFOR "SAVED^M" 120
                IF WAITFOR
                    MESSAGE "`n   TRANSMISSION SUCCESSFUL...`n"
                ELSE
                    MESSAGE "`n   NETWORK DID NOT SAVE UPLOADED DATA...`n"
                ENDIF
            ENDIF
        ENDIF
    ENDIF


            ;************************************************************
            ;*           If requested, receive a file.                  *
            ;************************************************************

    STRCMP RCVTYPE "Y" 1
    IF SUCCESS

        ISFILE INFILE
        IF SUCCESS
            CALL ERROR WITH 8
        ENDIF

        LOG RESUME

        WHEN 0 "EMPTY" CALL NOMAIL
        WHEN 1 "TRANSFER" CALL RECEIVE

        TRANSMIT "RECEIVE^M"

        WAITFOR "EDIREADY" 180
        CWHEN 0
        CWHEN 1

    ENDIF

                      ;***********************************************
                      ;*            Log Off the network              *
                      ;***********************************************

    TRANSMIT "LOGOFF^M"
    PAUSE 2
    LOG CLOSE
    HANGUP
    QUIT
ENDPROC

         ;***************************************************************
         ;**                ERROR HANDLING PROCEDURE                   **
         ;***************************************************************

PROC ERROR
    INTPARM ERRNUM

    SWITCH ERRNUM
        CASE 1
            MESSAGE "`n   CONNECTION TO HARBINGER NETWORK FAILED..."
        ENDCASE

        CASE 2
            MESSAGE "`n   NO RESPONSE FROM NETWORK AFTER MODEM CONNECTION..."
        ENDCASE

        CASE 3
            MESSAGE "`n   NO PASSWORD REQUEST RECEIVED AFTER SUPPLYING LOGON ID..."
        ENDCASE

        CASE 4
            MESSAGE "`n   LOGON WAS NOT SUCCESSFUL...CHECK LOGON ID AND PASSWORD..."
        ENDCASE

        CASE 6
            MESSAGE "`n   FILE UPLOAD FAILED...   "
        ENDCASE

        CASE 7
            MESSAGE "`n   FILE DOWNLOAD FAILED...   "
        ENDCASE

        CASE 8
            MESSAGE "`n   INFILE ALREADY EXISTS...DOWNLOAD FAILED...   "
        ENDCASE
    ENDSWITCH

    MESSAGE "`n   EXECUTION OF SCRIPT AND COMMUNICATION SESSION TERMINATED "
    MESSAGE "`n   DUE TO ABOVE ERROR..."

    ALARM 2

    TRANSMIT "QUIT^M"
    PAUSE 2
    HANGUP
    QUIT
ENDPROC

         ;***************************************************************
         ;**                GIVE EMPTY MAILBOX MESSAGE                 **
         ;***************************************************************

PROC NOMAIL
    MESSAGE "`nHARBINGER NETWORK INDICATES THAT THERE IS NO MAIL IN YOUR MAILBOX...`n"
ENDPROC

         ;***************************************************************
         ;**                PERFORM RECEIVE PROCESSING                 **
         ;***************************************************************

PROC RECEIVE
    PAUSE 1
    TRANSMIT "CONTINUE^M"
    LOG SUSPEND
    GETFILE XMODEM INFILE
    LOG RESUME
    IF FAILURE
        CALL ERROR WITH 7
    ELSE
        MESSAGE "`n   FILE RECEIVED SUCCESSFULLY...`n"
        TRANSMIT "SAVED^M"
    ENDIF
ENDPROC