;**********************************************************************
;*     GE.ASP  for Procomm Plus -                                     *
;* GE  command file for automatic logon and send/ receive to GEIS     *
;*     Network.  This script does an automatic send/receive to GEIS   *
;*     Network if the outbound file exists.  If it doesn't exist a    *
;*     receive only is performed.  Please not the "S6" option switch  *
;*     for doing a send without a receive or a receive prior is       *
;*     available; use N for send only or P for receive previous.      *
;*     All of the call loging information is written to a file called *
;*     ge.log.  This file is deleted at the begining of each          *
;*     transmision automatically.                                     *
;*                                                                    *
;*      DATE WRITTEN:10/31/91                                         *
;*      REVISED: 9/19/92                                              *
;*      BY: Ted Carlson  for  Sterling Software                       *                               *
;*                            phone: (313) 973-6600                   *
;*   To invoke pcplus from the command line:                          *
;*     <enter> pcplus/fGE                                             *
;*   The following system variables must be updated prior to use:     *
;*                                                                    *
;* BAUDRATE 2400            ;* DESIRED BAUD RATE                      *
;* PORT COM1                ;* Your modems comm port                  *
;* PAUSE 25                 ;* Time required for connection           *
;* Parameter info for logon.ge file:                                  *
;*                                                                    *
;* 1: "GEOUT.DAT"           ;* GE OUTBOUND FILE NAME                  *
;* 2: "GEIN.DAT"            ;* GE INBOUND FILE NAME                   *
;* 3: "USER-ID"             ;* USER ID                                *
;* 4: "PASSWORD"            ;* ge password                            *
;* 5: "ATDT 6636866"        ;* GE Dial Up phone Number                *
;* 6: "ATDT 13136266570"    ;* GE Dial Up phone Number NUMBER 2       *
;* 7:"DOCS###"              ;* OUTGOING MAIL FILE NAME                *
;*                           * Use DOCS and the last 3 digits of your *
;*                           * user id                                *
;* 8: "MAILA###"            ;* INCOMMING GE MAIL FILE NAME           *
;*                           * Use MAILA and the last digits of your  *
;*                           * user id                                *
;* 9: "APP"                 ;* FILE UPDATE MODE APP for append or OV  *
;* 10: "N"                   :* R TO RECEIVE DATA P TO RECEIVE PRIOR   *
;*                           * N FOR SEND ONLY                        *
;**********************************************************************
proc main

SET BAUDRATE 2400           ;*** If you change the BAUDRATE to 9600, you must***
SET DATABITS 7              ;*** change the PAUSE value found after the init.***
SET PORT COM2               ;* Your modems comm port
SET DUPLEX FULL
set modem waitcnct 30
SET PARITY EVEN
SET SOUND OFF
SET STOPBITS 1
SET FGETS_CRLF OFF
EMULATE ANSI                  ;* Use ANSI-BBS emulation for ANSI graphics      *
HANGUP
STRING BUFFER
STRING EDIOUT   ;*  Send Document Name               *
STRING EDIIN    ;*  Receive Document Name            *
STRING LOGONSTR ;* GEIS Logon                        *
STRING PASSWRD  ;* GEIS password                     *
STRING PHONENUM ;* GEIS Phone Number *               *
STRING PHONENM2 ;* GEIS backup Phone Number          *
STRING DOCSNUM  ;* Network incomming file name       *
STRING MAILNUM  ;* Network Outgoing File name        *
STRING FLMODE   ;* FILE UPDATE MODE APP or OV        *
STRING RCVTYPE  ;* R TO RECEIVE DATA P TO RECEIVE PRIOR
		;* N FOR NO RECEIVE
STRING LOGONBUF
STRING TEMPBUF
STRING OUTFILE = "OUTFILE.SND" 
INTEGER FLEND = 0
INTEGER RCVQ = 1
INTEGER SNDQ = 1
INTEGER TRIES = 0
DELETE EDIIN
FOPEN 0 "LOGON.GE" "RT"
DELETE EDIIN
WHILE NOT FLEND
FGETS 0 BUFFER
STRCMP BUFFER "1:" 2
IF SUCCESS
  SUBSTR EDIOUT BUFFER 2 34
ENDIF

STRCMP BUFFER "2:" 2
IF SUCCESS
  SUBSTR EDIIN BUFFER 2 34
ENDIF

STRCMP BUFFER "3:" 2
IF SUCCESS
  SUBSTR LOGONSTR BUFFER 2 8
ENDIF

STRCMP BUFFER "4:" 2
IF SUCCESS
  SUBSTR PASSWRD BUFFER 2 8
ENDIF

STRCMP BUFFER "5:" 2
IF SUCCESS
  SUBSTR PHONENUM BUFFER 2 34
ENDIF

STRCMP BUFFER "6:" 2
IF SUCCESS
  SUBSTR PHONENM2 BUFFER 2 34
ENDIF

STRCMP BUFFER "7:" 2
IF SUCCESS
  SUBSTR DOCSNUM BUFFER 2 8
ENDIF

STRCMP BUFFER "8:" 2
IF SUCCESS
  SUBSTR MAILNUM BUFFER 2 8
ENDIF

STRCMP BUFFER "9:" 2
IF SUCCESS
  SUBSTR FLMODE BUFFER 2 4
  STRCAT FLMODE, "^M", 2
ENDIF

STRCMP BUFFER "10:" 3
IF SUCCESS
  SUBSTR RCVTYPE BUFFER 3 2
ENDIF
EOF 0 FLEND
ENDWHILE
FCLOSE 0

;***************END OF INITIALIZATION SECTION  **************************

;************************************************************************

WHILE FOREVER
  ISFILE EDIOUT
  DELETE OUTFILE
  RENAME EDIOUT OUTFILE
  LOG OPEN "GE.LOG"
  TRANSMIT "ATDT "
  TRANSMIT PHONENUM
  TRANSMIT "^M"            ;* GE Dial Up phone Number
  PAUSE 25                 ;**** If you changed the baud to 9600,  ****
  IF NOT CONNECTED         ;*** change PAUSE to 40 both hear, and below  ***
     HANGUP                          ;* Disconnect phone line    
     STRCPY TEMPBUF "NO CONNECTION ON LINE ONE"  ;* Indicate status
     MESSAGE TEMPBUF
     TRANSMIT "ATDT "
     TRANSMIT PHONENM2               ;* GE Dial Up phone Number 2
     TRANSMIT "^M"
     PAUSE 25              ;**** If you changed the baud to 9600,  **** 
  ENDIF                    ;*** change PAUSE to 40 both hear, and above  ***
  
  IF CONNECTED
     STRCPY TEMPBUF "CONNECTED"                  ;* Indicate status  
     MESSAGE TEMPBUF
     TRANSMIT "HH^M"
     WAITFOR "U#=" 
     STRCPY LOGONBUF, LOGONSTR, 8
     STRCAT LOGONBUF, "," 1
     STRCAT LOGONBUF, PASSWRD, 8
     STRCAT LOGONBUF, ",MAILA^M" 8
     MESSAGE LOGONBUF
     TRANSMIT LOGONBUF
  ;* TRANSMIT ",MAILA^M"   ;* SENDS USER ID AND PASSWORD     *
  ELSE
     STRCPY TEMPBUF "NO CONNECTION ON LINE TWO"  ;* Indicate status  
     MESSAGE TEMPBUF
     GOTO COMEND
  ENDIF
 
  LOG SUSPEND     ;* DON'T CAPTURE MENU
  WAITFOR "SELECTION:" 30
    TRANSMIT "DATA^M"
   
  WAITFOR "SELECTION:" 30
  ISFILE OUTFILE            ;* CHECKS FOR OUTBOUND EDI FILE
  IF SUCCESS
     TRANSMIT "XMOD SEND^M"
     WAITFOR "?" 30
     TRANSMIT "C^M"
     WAITFOR "?" 30
     MESSAGE DOCSNUM
     TRANSMIT DOCSNUM        ;*  SENDS A REQUEST TO SEND AN EDI FILE
     TRANSMIT "^M"
     WAITFOR "READY FOR INPUT" 40
     IF WAITFOR
       LOG RESUME
       PAUSE 10
       SENDFILE XMODEM  OUTFILE
       IF FAILURE
	     HANGUP
	     QUIT
       ENDIF
	LOG SUSPEND
     ELSE
	WHILE SNDQ
	  MESSAGE FLMODE
	  TRANSMIT FLMODE
	  WAITFOR "READY FOR INPUT" 40
	  IF NOT WAITFOR
	     SNDQ = 1
	  ELSE
	     SNDQ = 0
	   ENDIF
	ENDWHILE
	  LOG RESUME
	  PAUSE 15
	  SENDFILE XMODEM OUTFILE     ;* SENDS OUTBOUND EDI FILE
	  IF FAILURE
	     HANGUP
	     GOTO COMEND
	  ENDIF
	  LOG SUSPEND
     ENDIF
     WAITFOR "?" 30
     TRANSMIT "N^M"
     WAITFOR "?" 30
     TRANSMIT "N^M"
     WAITFOR "SELECTION:" 45
     TRANSMIT "SEND "
     TRANSMIT DOCSNUM
     TRANSMIT "^M"
     LOG RESUME
     WAITFOR "SELECTION:" 300
     LOG SUSPEND
     DELETE OUTFILE
     GOTO RCVONLY
  ELSE
     GOTO RCVONLY
  ENDIF
  
  
;***Perform Receive session ***
RCVONLY:
   FIND RCVTYPE "P"
      IF FOUND
	 WHILE RCVQ
	    TRANSMIT "PRIOR^M"
	    LOG RESUME
	    WAITFOR "SELECTION:" 60
	    IF NOT WAITFOR
	       TRIES = TRIES + 1
	       RCVQ = 1
	       IF ge TRIES 5
		 RCVQ = 0
		 TRIES = 0
	       ENDIF
	    ELSE
	       RCVQ = 0
	    ENDIF
	 ENDWHILE
	 LOG SUSPEND
      ENDIF
   FIND RCVTYPE "R"
      IF FOUND
	 WHILE RCVQ
	    TRANSMIT "RECV^M"
	    LOG RESUME
	    WAITFOR "SELECTION:" 600
	    IF NOT WAITFOR
	       TRIES = TRIES + 1
	       RCVQ = 1
	       IF ge TRIES 5
		 RCVQ = 0
		 TRIES = 0
	       ENDIF
	    ELSE
	       RCVQ = 0
	    ENDIF
	 ENDWHILE
	 LOG RESUME
	 WAITFOR "SELECTION:" 60
	 LOG SUSPEND
      ENDIF
   FIND RCVTYPE "N"
      IF NOT FOUND
	 PAUSE 10
	 TRANSMIT "XMOD RECV^M"
	 WAITFOR "?" 30
	 TRANSMIT "C^M"
	 WAITFOR "?" 30
	 MESSAGE MAILNUM
	 TRANSMIT MAILNUM
	 TRANSMIT "^M"
	 LOG RESUME
	 WAITFOR "Start download now." 20
	 IF NOT WAITFOR
	    GOTO COMEND
	 ELSE
	    IF CONNECTED
	       GETFILE XMODEM EDIIN
	       IF FAILURE
		  HANGUP
		  GOTO COMEND
	       ENDIF
	    ELSE
	       GOTO COMEND
	    ENDIF
	 ENDIF
	 LOG SUSPEND
	 WAITFOR "?" 30
	 TRANSMIT "N^M"
	 WAITFOR "?" 30
	 TRANSMIT "N^M"
	 WAITFOR "SELECTION:" 30
      ENDIF
  TRANSMIT "BYE^M"
  GOTO COMEND

;** Close Session **

COMEND:
   LOG CLOSE
   HANGUP
   QUIT
   ENDWHILE
;*******************************END GE.CMD**************************
endproc
