;**********************************************************************
;*     GE.CMD  for Procomm -                                          *
;* GE  command file for automatic logon and send/ receive to GEIS     *
;*     Network.  This script does an automatic send/receive to GEIS   *
;*     Network if the outbound file exists.  If it doesn't exist a    *
;*     receive only is performed.  Please not the "S6" option switch  *
;*     for doing a send without a receive or a receive prior is also  *
;*     available; use N for send only or P for receive previous or R  *
;*     for receive.                                                   *
;*     All of the call loging information is written to a file called *
;*     ge.log.  This file is deleted at the begining of each          *
;*     transmision automatically.                                     *
;*                                                                    *
;*   To invoke procomm from the command line:                         *
;*     <enter> procomm/fGE                                            *
;*   The following system variables must be updated prior to use:     *
;*                                                                    *
;* BAUDRATE 2400            ;* DESIRED BAUD RATE                      *
;* PORT COM1                ;* Your modems comm port                  *
;* DLDIR "\MENTOR\"          ;* Default dowload directory              *
;* S0 "GEIN.DAT"            ;* GE INBOUND FILE NAME                   *
;* S1 "GEOUT.DAT"           ;* GE OUTBOUND FILE NAME                  *
;* S2 "MAILA###"            ;* INCOMMING GE MAIL FILE NAME            *
;*                           * Use MAILA and the last digits of your  *
;*                           * user id                                *
;* S3 "DOCS###"             ;* OUTGOING MAIL FILE NAME                *
;*                           * Use DOCS and the last 3 digits of your *
;*                           * user id                                *
;* S4 "USER-ID,PASSWORD"    ;* USER ID AND PASSWORD calma seperated   *
;* S5 "APP"                 ;* FILE update mode APP for append or OV  *
;*                           * for overwriting an existing file that  *
;*                           * was sent to GE network on the same day *
;* S6 "N"                   :* R TO RECEIVE DATA P TO RECEIVE PRIOR   *
;*                           * N FOR SEND ONLY                        *
;* S7 "ATDT 6636866!"       ;* GE Dial Up phone Number                *
;* S8 "ATDT 13136266570!"   ;* GE Dial Up phone Number NUMBER 2       *
;*                           * Phone number must include ATDT prefix  *
;*                           * ! suffix                               *
;**********************************************************************

SET BAUDRATE 2400           ;* desired BAUD rate
SET DATABITS 7
SET PORT COM1               ;* Your modems comm port
SET DUPLEX FULL
SET RDELAY 30
SET PARITY EVEN
SET SOUND OFF
SET STOPBITS 1
SET DLDIR "\MENTOR\"         ;* Default dowload directory
EMULATE ANSI                ;* Use ANSI-BBS emulation for ANSI graphics      *
HANGUP
DOS "DEL GE.LOG"              ;* REMOVING OLD LOG FILE
ASSIGN S0 "GEIN.DAT"          ;*  GE INBOUND FILE NAME
ASSIGN S1 "GEOUT.DAT"         ;*  GE OUTBOUND FILE NAME
ASSIGN S2 "MAILA###"          ;* INCOMMING GE MAIL FILE NAME
ASSIGN S3 "DOCS###"           ;* OUTGOING MAIL FILE NAME
ASSIGN S4 "USRID,PWRD"        ;* USER ID AND PASSWORD
ASSIGN S5 "APP"               ;* FILE UPDATE MODE APP or OV
ASSIGN S6 "P"                 ;* R TO RECEIVE DATA P TO RECEIVE PRIOR
										;* N FOR NO RECEIVE
ASSIGN S7 "ATDT 6636866!"     ;* Primary GE dial number
ASSIGN S8 "ATDT 13136266570!" ;* Secondary dila up phone number

;***************END OF INITIALIZATION SECTION  **************************

;************************************************************************

LOG OPEN "GE.LOG"
TRANSMIT S7 @                 ;* GE Dial Up phone Number
IF NOT CONNECTED
	TRANSMIT S8 @              ;* GE Dial Up phone Number 2
ENDIF

PAUSE "20"
IF CONNECTED
   TRANSMIT "HH^M"
   WAITFOR "U#="
	TRANSMIT S4
	TRANSMIT ",MAILA^M"   ;* SENDS USER ID AND PASSWORD     *
ELSE
	GOTO COMEND
ENDIF
LOG SUSPEND     ;* DON'T CAPTURE MENU
PAUSE "30"
TRANSMIT "DATA^M"
PAUSE "20"
ISFILE S1            ;* CHECKS FOR OUTBOUND EDI FILE
IF SUCCESS
	TRANSMIT "XMOD SEND^M"
	PAUSE "10"
	TRANSMIT "C^M"
	PAUSE "5"
	TRANSMIT S3        ;*  SENDS A REQUEST TO SEND AN EDI FILE
	TRANSMIT "^M"
	PAUSE "15"
	WAITFOR "READY FOR INPUT" 10
	IF NOT WAITFOR
		TRANSMIT S5
		TRANSMIT "^M"
		PAUSE "5"
		WAITFOR "READY FOR INPUT"
		PAUSE "15"
		IF CONNECTED
		  LOG RESUME
		  SENDFILE XMODEM S1     ;* SENDS OUTBOUND EDI FILE
		  LOG SUSPEND
		ELSE
		  GOTO COMEND
		ENDIF
	ELSE
		  LOG RESUME
		  PAUSE "5"
		 SENDFILE XMODEM  S1
		 LOG SUSPEND
	ENDIF
	PAUSE "5"
	TRANSMIT "N^M"
	PAUSE "5"
   TRANSMIT "N^M"
	PAUSE "10"
	TRANSMIT "SEND "
	TRANSMIT S3
	TRANSMIT "^M"
	LOG RESUME
	PAUSE "20"
	LOG SUSPEND
   GOTO RCVONLY
ELSE
   GOTO RCVONLY
ENDIF

;***Perform Receive session ***
RCVONLY:
 SWITCH S6
 FIND S6 "P"
 IF FOUND
	TRANSMIT "PRIOR^M"
	LOG RESUME
	PAUSE "45"
	LOG SUSPEND
 ENDIF
 FIND S6 "R"
 IF FOUND
	 TRANSMIT "RECV^M"
	 LOG RESUME
	 PAUSE "45"
	 LOG SUSPEND
 ENDIF
 FIND S6 "N"
 IF NOT FOUND
	TRANSMIT "XMOD RECV^M"
	PAUSE "20"
	TRANSMIT "C^M"
	PAUSE "10"
	TRANSMIT S2
	TRANSMIT "^M"
	LOG RESUME
	WAITFOR "Start download now." 45
	IF NOT WAITFOR
	  GOTO COMEND
	ELSE
	  IF CONNECTED
		 GETFILE XMODEM S0
	  ELSE
		 GOTO COMEND
	  ENDIF
	ENDIF
	LOG SUSPEND
	PAUSE "5"
	TRANSMIT "N^M"
	PAUSE "5"
	TRANSMIT "N^M"
	PAUSE "20"
 ENDIF
 TRANSMIT "BYE^M"
 GOTO COMEND
 ;** Close Session **
COMEND:
 LOG CLOSE
 HANGUP
 QUIT
;*******************************END GE.CMD**************************