;*****************************************************************************
;*                                                                           *
;* EDINET.ASP - Command File for automatic logon and send/receive of EDI Data*
;*             via the EDI*NET Network, when using a MNP Error Checking      *
;*             Modem (MNP Class 4 or Up).                                    *
;*                                                                           *
;*             All Network message files will be returned to a file called   *
;*             EDINET.MSG                                                    *
;*                                                                           *
;*             The File LOGON.EDI will contain information necessary to      *
;*             successfully communicate with the network.  This file will    *
;*             contain ...                                                   *
;*                                                                           *
;*             1:EDI File to Receive                                         *
;*             2:EDI File to Send                                            *
;*             3:Network Mailbox Id                                          *
;*             4:Network Password                                            *
;*             5:Primary Phone Number                                        *
;*             6:Secondary Phone Number                                      *
;*                                                                           *
;*****************************************************************************

proc main

   SET BAUDRATE 2400
   SET DATABITS 8
   SET PORT COM1
   SET DUPLEX FULL
   SET PARITY NONE
   SET SOUND OFF
   SET FGETS_CRLF OFF
   SET STOPBITS 1
   EMULATE ANSI                 ;* Use ANSI-BBS emulation for ANSI graphics *
   STRING BUFFER
   STRING EDIIN                 ;* EDI File to Receive *
   STRING EDIOUT                ;* EDI File to Send *
   STRING MAILBOX               ;* Network Mailbox Id *
   STRING PASSWORD              ;* Network Password
   STRING PHONENUM              ;* Primary Phone Number *
   STRING PHONENM2              ;* Secondary Phone Number *
   STRING DATESTR
   STRING TIMESTR
   INTEGER FLEND = 0		;* End of File Marker *

   ;* Read LOGON.EDI to get variable information *
   FOPEN 0 "LOGON.EDI" "RT"
   WHILE NOT FLEND
      FGETS 0 BUFFER
      STRCMP BUFFER "1:" 2
      IF SUCCESS
	 SUBSTR EDIIN BUFFER 2 34
      ENDIF
      STRCMP BUFFER "2:" 2
      IF SUCCESS
	 SUBSTR EDIOUT BUFFER 2 34
      ENDIF
      STRCMP BUFFER "3:" 2
      IF SUCCESS
         SUBSTR MAILBOX BUFFER 2 34
      ENDIF
      STRCMP BUFFER "4:" 2
      IF SUCCESS
         SUBSTR PASSWORD BUFFER 2 34
      ENDIF
      STRCMP BUFFER "5:" 2
      IF SUCCESS
         SUBSTR PHONENUM BUFFER 2 34
      ENDIF
      STRCMP BUFFER "6:" 2
      IF SUCCESS
         SUBSTR PHONENM2 BUFFER 2 34
      ENDIF
      EOF 0 FLEND
      ENDWHILE

      FCLOSE 0

      DELETE EDIIN              ;* Delete Previous EDI Receive File *
      DELETE ".\EDINET.STS"     ;* Delete  Previous Network Stats File *

      DOS "TYPE EDI_BEG.TXT > EDINET.MSG"
      FOPEN 0 "EDINET.MSG" "AT"	;* Open Status Log in append mode *

      DATE DATESTR  		;* Get current Date *
      TIME TIMESTR 0		;* Get current time *

      STRSET BUFFER 00 80
      STRCPY BUFFER "--------------------"
      FWRITE  0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "Run Date: "
      STRCAT BUFFER DATESTR
      STRCAT BUFFER " "
      STRCAT BUFFER TIMESTR
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "--------------------"
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "EDI File to Receive: "
      STRCAT BUFFER EDIIN
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "EDI File to Send: "
      STRCAT BUFFER EDIOUT
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "Mailbox Id: "
      STRCAT BUFFER MAILBOX
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "Password: "
      STRCAT BUFFER PASSWORD
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "Primary Phone Number: "
      STRCAT BUFFER PHONENUM
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "Secondary Phone Number: "
      STRCAT BUFFER PHONENM2
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "--------------------"
      FWRITE 0 BUFFER 80

      TRANSMIT "ATDT "          ;* First Dial Attempt *
      TRANSMIT PHONENUM         ;* Primary Phone Number *
      TRANSMIT "^M"
      PAUSE 30
      IF CONNECTED
	 STRSET BUFFER  00 80
	 STRCPY BUFFER "First Dial Attempt Successful"
	 FWRITE 0 BUFFER 80
         GOTO SEND_LOGON
      ENDIF

      STRSET BUFFER 00 80
      STRCPY BUFFER "First Dial Attempt Unsuccessful"
      FWRITE 0 BUFFER 80

      STRSET BUFFER 00 80
      STRCPY BUFFER "Dial again using Secondary Phone Number"
      FWRITE 0 BUFFER 80

      TRANSMIT "ATDT "          ;* Second Dial Attempt *
      TRANSMIT PHONENM2         ;* Secondary Phone Number *
      TRANSMIT "^M"
      PAUSE 30
      IF CONNECTED
	 STRSET BUFFER 00 80
	 STRCPY BUFFER "Second Dial Attempt was Successful"
	 FWRITE 0 BUFFER 80
	 GOTO SEND_LOGON
      ENDIF

      ;* Unable to Connect, Update Message File with No Carrier Text *
      ;* then exit.
      STRSET BUFFER 00 80
      STRCPY BUFFER "ERROR: Unable to Detect Carrier"
      FWRITE 0 BUFFER 80
      FCLOSE 0
      GOTO WRAPUP

SEND_LOGON:
      STRSET BUFFER 00 80
      STRCPY BUFFER "Transmit Login Info"
      FWRITE 0 BUFFER 80

      TRANSMIT "A"
      PAUSE 3
      WAITFOR "please log in:"
      TRANSMIT "EDIXPC01;XPC*EDI^M"
      TRANSMIT MAILBOX
      TRANSMIT ";"
      TRANSMIT PASSWORD
      TRANSMIT ";X130;^M"
      WAITFOR "WELCOME TO EDI*NET"
      STRSET BUFFER 00 80
      STRCPY BUFFER "Network Login Accepted - Receiving EDI File"
      FWRITE 0 BUFFER 80
      GETFILE ASCII EDIIN
      WAITFOR "^I"
      IF FAILURE
	 STRSET BUFFER 00 80
	 STRCPY BUFFER "ERROR: Carrier Lost During Transmission"
	 FWRITE 0 BUFFER 80
	 FCLOSE 0
	 HANGUP
	 GOTO WRAPUP
      ENDIF
      STRSET BUFFER 00 80
      STRCPY BUFFER "EDI File Received"
      FWRITE 0 BUFFER 80
      ISFILE EDIOUT		;* Check if an EDI File to Send Exist *
      IF FAILURE
	 STRSET BUFFER  00 80
	 STRCPY BUFFER "No EDI Data to Send to Network"
	 FWRITE 0 BUFFER 80
	 TRANSMIT "NO DATA TO SEND^M"
	 TRANSMIT "^I"
      ELSE
	 STRSET BUFFER 00  80
	 STRCPY BUFFER "Sending EDI File to Network"
	 FWRITE 0 BUFFER 80
	 SENDFILE ASCII EDIOUT
         TRANSMIT "^I"
      ENDIF
      STRSET BUFFER 00 80
      STRCPY BUFFER "Waiting to Receive Network Statistics"
      FWRITE 0 BUFFER 80
      WAITFOR "EODEDI"
      GETFILE ASCII ".\EDINET.STS"
      WAITFOR "^I"
      HANGUP
      ISFILE ".\EDINET.STS"
      IF FAILURE
	  STRSET BUFFER 00 80
	  STRCPY BUFFER "No Statistics were received from Network"
	  FWRITE 0 BUFFER 80
	  FCLOSE 0
      ELSE
	  STRSET BUFFER 00 80
	  STRCPY BUFFER "Network Statistics were Received"
	  FWRITE 0 BUFFER 80
	  STRSET BUFFER 00 80
	  STRCPY BUFFER "--------------------"
	  FWRITE 0 BUFFER 80
	  FCLOSE 0
	  DOS "TYPE .\EDINET.STS >>EDINET.MSG"
      ENDIF

      WRAPUP:
	DOS "TYPE EDI_END.TXT >>EDINET.MSG"
        QUIT
     endproc
