! comnet_cps.cmd 
!*********************************************************************
! usage: comnet_bts  argfile
!       argfile contains the easylink logon argument information
!*********************************************************************
! Date		Name	Description
! 041095  	jackm 	Original creation for COMPUSERVE
!*********************************************************************

retries 2		        ! 3  tries total
! setvar logfile "comm_net.log" ! Commerce Net Log File
fopen 1, "$1"                   ! File containing all of the Commerce Net
itime 0
                                ! configuration arguments
repeat
freadln 1, inbuf                ! Loading all of the environment variables
   setvar in_arg left(inbuf,2)
   setvar length  len(inbuf) -2 
   switch
     case in_arg = "1:"         ! Send File List Name. 
         setvar sndfllst midstr(inbuf, 3, length)
     case in_arg = "2:"         ! Received File List Name. 
         setvar rcvfllst midstr(inbuf,3, length)
     case in_arg = "3:"         ! Log File Name. 
         setvar logfile midstr(inbuf, 3, length)
     case in_arg = "4:"         ! Phone Number. 
         setvar phonenum midstr(inbuf, 3, length)
    endswitch
until feof(1)
fclose (1)

on abort
	? "^C operator abort"
	hangup
	quit 3
endon

DTIMEOUT 40
capture disk $(logfile) on APPEND
capture on

? "Connecting to Commerce Net Network"
baud 9600,N,8,1
call $(phonenum)
protocol ascii
dwait 3
xmit "\r"
dwait ":",30
xmit "+\r"
dwait "Host Name:", 20
xmit "ONET,SSGATE\r"
dwait "Connected to ONET",30

if _timeout
   quit 1
endif

xmit "LOGON\r"
dwait "SUPERTRACS READY FOR INPUT", 30

if _timeout
   ? "\nFailed to logon to Commerce Net check your phone number & password\n"
   hangup
   quit 2
endif

if exists("$(rcvfllst)") !* If inbound file list exists retrieved it to network
fopen 2, "$(rcvfllst)"   ! File containing all of the Commerce Net Send File(s)s
repeat
freadln 2, inbuf         ! Loading all of the environment variables
 if  !feof(2)
   setvar logon_len  pos ( ",", inbuf,1) 
   setvar logonid left(inbuf,logon_len -1)
   setvar passwd_len  pos ( ",", inbuf,logon_len +1) 
   setvar pwrd  midstr(inbuf,logon_len +1,  passwd_len - logon_len -1) 
   setvar file_len  len( inbuf)
   setvar infile midstr( inbuf, (passwd_len) +1,  file_len - passwd_len )
? "Logon: $(logonid) Password: $(pwrd)   Receive File: $(infile)\r"
  do @comnrcv             !****** Calling the receive function
endif
until feof(2)
fclose (2)
endif

if exists("$(sndfllst)") !* If outbound file list exists send it to network
fopen 3, "$(sndfllst)"  ! File containing all of the Commerce Net send file(s))s

repeat
freadln 3, inbuf            ! Loading all of the environment variables
if ( !feof (3))
   setvar logon_len  pos ( ",", inbuf,1) 
   setvar logonid left(inbuf,logon_len -1)
   setvar passwd_len  pos ( ",", inbuf,logon_len +1) 
   setvar pwrd  midstr(inbuf,logon_len +1,  passwd_len - logon_len -1) 
   setvar file_len  len( inbuf)
   setvar outfile midstr( inbuf, (passwd_len) +1,  file_len - passwd_len )
? " Logon:$(logonid)  Password: $(pwrd)  Send File: $(outfile)\r"

  do @comnsnd          !**** Calling the send function
endif
until feof(3)
fclose (3)
endif

xmit "LOGOFF\r" 
capture close
hangup
quit 0

!**********************************************
! The send proc
!**********************************************
proc comnsnd

if exists("$(outfile)") !* If outbound file list exists send it to network
    fopen 4, "$(outfile)"         ! File containing data for Commerce Net
else
    ? "Commerce Net outbound file doesn't exit: $(outfile) " 
  return 0
endif
capture on
? "\$\$ADD ID=$(logonid) BATCHID=\'$(pwrd)\'\r"
xmit "\$\$ADD ID=$(logonid) BATCHID=\'$(pwrd)\'\r"
                            ! configuration arguments
repeat
freadln 4, inbuf            ! Loading all of the environment variables
!   setvar length  len(inbuf) 
!   setvar in_data   left(inbuf,length)
    setvar in_data inbuf
   !!!? "$(in_data)\r"
   xmit "$(in_data)\r"
until feof(4)
xmit "\x04"
fclose (4)
dwait "SUPERTRACS READY FOR INPUT", 30
capture off
endproc comnsnd

!*********************************************************************
! The receive only proc
!*********************************************************************
proc comnrcv
capture disk $(infile) on APPEND
capture on
? "\$\$REQUEST ID=$(logonid) BATCHID=\'$(pwrd)\'\r"
xmit "\$\$REQUEST ID=$(logonid) BATCHID=\'$(pwrd)\'\r"
dwait 2
! Pull Down the Data
 dwait "SUPERTRACS READY FOR INPUT| NO BATCHES FOR TRANSMISSION", 810
if _retval=1
   dwait 3
endif
capture off
capture disk $(logfile) on OVERWRITE
endproc comnrcev
