# Zinc Application Framework 5.0 test programs makefile
# Uses Watcom C/C++ 10.6 and 11.0 with Watcom WMAKE.EXE (excluding QNX)
#
# Builds Zinc test programs for 32 bit DOS (using DOS4GW), Windows 16,
#  Windows 32, OS2, DESQview/X (using Motif toolkit), QNX (Motif).
#    wmake -f watcom.mak dos32
#    wmake -f watcom.mak win16
#    wmake -f watcom.mak win32
#    wmake -f watcom.mak os2
#    wmake -f watcom.mak dvx
#    make -f watcom.mak qnx
#
# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
# DOS 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# WIN 16:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\WIN;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB286\WIN;C:\WATCOM\LIB286;C:\ZINC\LIB\WCCPP
# WIN 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\NT;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\NT;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# OS/2:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\OS2;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\OS2;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# DESQView/X:
#    set INCLUDE=.;C:\DVX\INCLUDE;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\DVX\LIB\C386;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
#
# ----- General Definitions -------------------------------------------------
ZAF_ROOT=..

!include $(ZAF_ROOT)\include\optswat.mak

# ----- Usage ---------------------------------------------------------------
usage: .SYMBOLIC
	@echo This makefile supports Watcom 10.6 and 11.0
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo wmake -f watcom.mak dos32
	@echo wmake -f watcom.mak win16
	@echo wmake -f watcom.mak win32
	@echo wmake -f watcom.mak os2
	@echo wmake -f watcom.mak dvx
	@echo make -f watcom.mak qnx
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean: .SYMBOLIC
	z_clean

# ----- DOS 32 bit (DOS4GW extender) Test Programs --------------------------
# This is pending.

# ----- Windows 16 bit Test Programs ----------------------------------------
win16: wbnum16.exe wbtn16.exe wcombo16.exe wgroup16.exe whlist16.exe &
	wimage16.exe wmdiwn16.exe wsclwn16.exe wspin16.exe wstr16.exe &
	wsys16.exe wtbar16.exe wtext16.exe wtree16.exe wvlist16.exe .SYMBOLIC

wbnum16.exe: bignum.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbnum16.exe F bignum.ob1$(WIN_OBJS) L $(WIN_LIBS)

wbtn16.exe: button.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wbtn16.exe F button.ob1$(WIN_OBJS) L $(WIN_LIBS)

wcombo16.exe: combo.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wcombo16.exe F combo.ob1$(WIN_OBJS) L $(WIN_LIBS)

wgroup16.exe: group.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wgroup16.exe F group.ob1$(WIN_OBJS) L $(WIN_LIBS)

whlist16.exe: hlist.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N whlist16.exe F hlist.ob1$(WIN_OBJS) L $(WIN_LIBS)

wimage16.exe: image.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wimage16.exe F image.ob1$(WIN_OBJS) L $(WIN_LIBS)

wmdiwn16.exe: mdiwin.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wmdiwn16.exe F mdiwin.ob1$(WIN_OBJS) L $(WIN_LIBS)

wsclwn16.exe: sclwin.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wsclwn16.exe F sclwin.ob1$(WIN_OBJS) L $(WIN_LIBS)

wspin16.exe: spin.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wspin16.exe F spin.ob1$(WIN_OBJS) L $(WIN_LIBS)

wstr16.exe: string1.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wstr16.exe F string1.ob1$(WIN_OBJS) L $(WIN_LIBS)

wsys16.exe: sys.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wsys16.exe F sys.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtbar16.exe: tbar.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtbar16.exe F tbar.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtext16.exe: text.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtext16.exe F text.ob1$(WIN_OBJS) L $(WIN_LIBS)

wtree16.exe: tree.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wtree16.exe F tree.ob1$(WIN_OBJS) L $(WIN_LIBS)

wvlist16.exe: vlist.ob1
	$(WIN_LINK) $(WIN_LINK_OPTS) N wvlist16.exe F vlist.ob1$(WIN_OBJS) L $(WIN_LIBS)

# ----- Windows 32 bit Test Programs ----------------------------------------
#win32: wbnum32.exe wbtn32.exe wcombo32.exe wgroup32.exe whlist32.exe &
win32: wbtn32.exe wcombo32.exe wgroup32.exe whlist32.exe &
	wimage32.exe wmdiwn32.exe wsclwn32.exe wspin32.exe wstr32.exe &
	wsys32.exe wtbar32.exe wtext32.exe wtree32.exe wvlist32.exe .SYMBOLIC

wbnum32.exe: bignum.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wbnum32.exe F bignum.obw$(W32_OBJS) L $(W32_LIBS)

wbtn32.exe: button.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wbtn32.exe F button.obw$(W32_OBJS) L $(W32_LIBS)

wcombo32.exe: combo.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wcombo32.exe F combo.obw$(W32_OBJS) L $(W32_LIBS)

wgroup32.exe: group.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wgroup32.exe F group.obw$(W32_OBJS) L $(W32_LIBS)

whlist32.exe: hlist.obw
	$(W32_LINK) $(W32_LINK_OPTS) N whlist32.exe F hlist.obw$(W32_OBJS) L $(W32_LIBS)

wimage32.exe: image.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wimage32.exe F image.obw$(W32_OBJS) L $(W32_LIBS)

wmdiwn32.exe: mdiwin.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wmdiwn32.exe F mdiwin.obw$(W32_OBJS) L $(W32_LIBS)

wsclwn32.exe: sclwin.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wsclwn32.exe F sclwin.obw$(W32_OBJS) L $(W32_LIBS)

wspin32.exe: spin.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wspin32.exe F spin.obw$(W32_OBJS) L $(W32_LIBS)

wstr32.exe: string1.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wstr32.exe F string1.obw$(W32_OBJS) L $(W32_LIBS)

wsys32.exe: sys.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wsys32.exe F sys.obw$(W32_OBJS) L $(W32_LIBS)

wtbar32.exe: tbar.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtbar32.exe F tbar.obw$(W32_OBJS) L $(W32_LIBS)

wtext32.exe: text.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtext32.exe F text.obw$(W32_OBJS) L $(W32_LIBS)

wtree32.exe: tree.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wtree32.exe F tree.obw$(W32_OBJS) L $(W32_LIBS)

wvlist32.exe: vlist.obw
	$(W32_LINK) $(W32_LINK_OPTS) N wvlist32.exe F vlist.obw$(W32_OBJS) L $(W32_LIBS)


# ----- Windows 32 bit dll Test Programs -------------------------------------
win32dll: wbtn.exe wcombo.exe wgroup.exe whlist.exe &
#win32dll: wbnum.exe wbtn.exe wcombo.exe wgroup.exe whlist.exe &
	wimage.exe wmdiwn.exe wsclwn.exe wspin.exe wstr.exe &
	wsys.exe wtbar.exe wtext.exe wtree.exe wvlist.exe .SYMBOLIC

wbnum.exe: bignum.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbnum.exe F bignum.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wbtn.exe: button.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wbtn.exe F button.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wcombo.exe: combo.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wcombo.exe F combo.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wgroup.exe: group.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wgroup.exe F group.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

whlist.exe: hlist.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N whlist.exe F hlist.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wimage.exe: image.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wimage.exe F image.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wmdiwn.exe: mdiwin.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wmdiwn.exe F mdiwin.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wsclwn.exe: sclwin.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wsclwn.exe F sclwin.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wspin.exe: spin.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wspin.exe F spin.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wstr.exe: string1.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wstr.exe F string1.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wsys.exe: sys.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wsys.exe F sys.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtbar.exe: tbar.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtbar.exe F tbar.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtext.exe: text.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtext.exe F text.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wtree.exe: tree.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wtree.exe F tree.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)

wvlist.exe: vlist.obi
	$(W32_LINK) $(W32_DLL_IMPORT_LINK_OPTS) N wvlist.exe F vlist.obi$(W32_OBJS) L $(W32_DLL_IMPORT_LIBS)


# ----- OS/2 Test Programs --------------------------------------------------
# This is pending.


# ----- DESQview/X Test Programs --------------------------------------------
dvx: mbnum.exe mbtn.exe mcombo.exe mgroup.exe mhlist.exe mimage.exe \
	mmdiwn.exe msclwn.exe mspin.exe mstr.exe msys.exe mtbar.exe mtext.exe \
	mtree.exe mvlist.exe

mbnum.exe: bignum.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mbnum.exe F bignum.obm$(DVX_OBJS) L $(DVX_LIBS)

mbtn.exe: button.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mbtn.exe F button.obm$(DVX_OBJS) L $(DVX_LIBS)

mcombo.exe: combo.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mcombo.exe F combo.obm$(DVX_OBJS) L $(DVX_LIBS)

mgroup.exe: group.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mgroup.exe F group.obm$(DVX_OBJS) L $(DVX_LIBS)

mhlist.exe: hlist.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mhlist.exe F hlist.obm$(DVX_OBJS) L $(DVX_LIBS)

mimage.exe: image.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mimage.exe F image.obm$(DVX_OBJS) L $(DVX_LIBS)

mmdiwn.exe: mdiwin.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mmdiwn.exe F mdiwin.obm$(DVX_OBJS) L $(DVX_LIBS)

msclwn.exe: sclwin.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N msclwn.exe F sclwin.obm$(DVX_OBJS) L $(DVX_LIBS)

mspin.exe: spin.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mspin.exe F spin.obm$(DVX_OBJS) L $(DVX_LIBS)

mstr.exe: string1.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mstr.exe F string1.obm$(DVX_OBJS) L $(DVX_LIBS)

msys.exe: sys.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N msys.exe F sys.obm$(DVX_OBJS) L $(DVX_LIBS)

mtbar.exe: tbar.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mtbar.exe F tbar.obm$(DVX_OBJS) L $(DVX_LIBS)

mtext.exe: text.o
	$(DVX_LINK) $(DVX_LINK_OPTS) N mtext.exe F text.obm$(DVX_OBJS) L $(DVX_LIBS)

mtree.exe: tree.o
	$(DVX_LINK) $(DVX_LINK_OPTS) N mtree.exe F tree.obm$(DVX_OBJS) L $(DVX_LIBS)

mvlist.exe: vlist.obm
	$(DVX_LINK) $(DVX_LINK_OPTS) N mvlist.exe F vlist.obm$(DVX_OBJS) L $(DVX_LIBS)


# ----- QNX Motif Test Programs ---------------------------------------------
qnx: mbignum mbutton mcombo mgroup mhlist mimage mmdiwin msclwin mspin \
	mstring1 msys mtbar mtext mtree mvlist

mbignum: bignum.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ bignum.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mbutton: button.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ button.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mcombo: combo.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ combo.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mgroup: group.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ group.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mhlist: hlist.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ hlist.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mimage: image.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ image.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mmdiwin: mdiwin.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ mdiwin.o $(QNX_LIB_DIRS) $(QNX_LIBS)

msclwin: sclwin.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ sclwin.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mspin: spin.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ spin.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mstring1: string1.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ string1.o $(QNX_LIB_DIRS) $(QNX_LIBS)

msys: sys.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ sys.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtbar: tbar.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ tbar.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtext: text.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ text.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mtree: tree.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ tree.o $(QNX_LIB_DIRS) $(QNX_LIBS)

mvlist: vlist.o
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ vlist.o $(QNX_LIB_DIRS) $(QNX_LIBS)

qclean:
	rm -f *.o core mbignum mbutton mcombo mgroup mhlist mimage mmdiwin \
	rm -f msclwin mspin mstring1 msys mtbar mtext mtree mvlist
