//	Zinc Application Framework - TBAR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>

static ZafLogicalColor bitmapArray[16][16] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};
static ZafImageStruct bitmapInfo = 
{
	16, 16, (ZafLogicalColor *)bitmapArray, true
};

// ----- ToolbarWindow ------------------------------------------------------

class ToolbarWindow : public ZafWindow
{
public:
	ToolbarWindow(int left, int top);
	~ToolbarWindow(void);

private:
	ZafBitmapData bitmapData;
};

ToolbarWindow::ToolbarWindow(int left, int top) :
	ZafWindow(left, top, 40, 9),
	bitmapData(bitmapInfo)
{
	// Set the window information.
	SetSelectionType(ZAF_MULTIPLE_SELECTION);
	SetStringID(ZAF_ITEXT("ToolbarWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);
	bitmapData.SetDestroyable(false);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Toolbar Window")));

	left = 10 * display->cellWidth + 10;
	top = (display->cellHeight - 20) / 2;

	// Create the window fields.
	ZafToolBar *tbar = new ZafToolBar(0, 0, 1, 1);
	tbar->Add(new ZafButton(0, 0, 5, 1, "1", ZAF_NULLP(ZafBitmapData), ZAF_3D_BUTTON));
	tbar->Add(new ZafButton(0, 0, 5, 1, "2", ZAF_NULLP(ZafBitmapData), ZAF_3D_BUTTON));
	tbar->Add(new ZafButton(0, 0, 5, 1, "3", ZAF_NULLP(ZafBitmapData), ZAF_3D_BUTTON));
	tbar->Add(new ZafButton(0, 0, 5, 1, "4", ZAF_NULLP(ZafBitmapData), ZAF_3D_BUTTON));
	tbar->Add(new ZafButton(0, 0, 5, 1, "5", ZAF_NULLP(ZafBitmapData), ZAF_3D_BUTTON));
	Add(tbar);

	tbar = new ZafToolBar(0, 0, 1, 1);
	tbar->SetWrapChildren(false);
	tbar->Add(new ZafString(0, 0, 10, new ZafStringData("string2", 20)));

	ZafButton *button = new ZafButton(left, top, 20, 20, "1");
	button->SetCoordinateType(ZAF_PIXEL);
	button->SetAutoSize(false);
	tbar->Add(button);
	button = new ZafButton(left+20, top, 20, 20, "2");
	button->SetCoordinateType(ZAF_PIXEL);
	button->SetAutoSize(false);
	tbar->Add(button);
	button = new ZafButton(left+40, top, 20, 20, "3");
	button->SetCoordinateType(ZAF_PIXEL);
	button->SetAutoSize(false);
	tbar->Add(button);

	button = new ZafButton(left+70, top, 20, 20, "4");
	button->SetCoordinateType(ZAF_PIXEL);
	button->SetAutoSize(false);
	tbar->Add(button);
	button = new ZafButton(left+90, top, 20, 20, "5");
	button->SetCoordinateType(ZAF_PIXEL);
	button->SetAutoSize(false);
	tbar->Add(button);
	button = new ZafButton(left+110, top, 20, 20, "6");
	button->SetCoordinateType(ZAF_PIXEL);
	button->SetAutoSize(false);
	tbar->Add(button);
	tbar->Add(new ZafString(1, 1, 10, new ZafStringData("string", 20)));
	Add(tbar);
}

ToolbarWindow::~ToolbarWindow(void)
{
	// We must specifically destroy the window's children before the static
	// iconData is destroyed (The natural call sequence order of destruction
	// is wrong).
	ZafList::Destroy();
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new ToolbarWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

