//	Zinc Application Framework - SPIN.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>

// ----- SpinControlWindow --------------------------------------------------

class SpinControlWindow : public ZafWindow
{
public:
	SpinControlWindow(int left, int top);
};

SpinControlWindow::SpinControlWindow(int left, int top) :
	ZafWindow(left, top, 40, 8)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("SpinControlWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton(ZAF_NATIVE_SYSTEM_BUTTON));
	Add(new ZafTitle(new ZafStringData(ZAF_ITEXT("Spin Control Window"))));

	// Create a ZafBignum spin control with a prompt.
	ZafPrompt *prompt = new ZafPrompt(1, 1, 8, new ZafStringData(ZAF_ITEXT("Bignum:")));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	ZafSpinControl *spin = new ZafSpinControl(10, 1, 24, new ZafBignumData(0.1));
	spin->Add(new ZafBignum(0, 0, 15, ZAF_NULLP(ZafBignumData)));
	Add(spin);

	// Create a ZafDate spin control with a prompt.
	prompt = new ZafPrompt(1, 2, 8, new ZafStringData(ZAF_ITEXT("Date:")));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	spin = new ZafSpinControl(10, 2, 24, new ZafDateData(0, 0, 1));
	spin->Add(new ZafDate(0, 0, 15, ZAF_NULLP(ZafDateData)));
	Add(spin);

	// Create a ZafInteger spin control with a prompt.
	prompt = new ZafPrompt(1, 3, 8, new ZafStringData(ZAF_ITEXT("Integer:")));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	spin = new ZafSpinControl(10, 3, 24, new ZafIntegerData(1L));
	spin->Add(new ZafInteger(0, 0, 15, ZAF_NULLP(ZafIntegerData)));
	Add(spin);

	// Create a ZafReal spin control with a prompt.
	prompt = new ZafPrompt(1, 4, 8, new ZafStringData(ZAF_ITEXT("Real:")));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	spin = new ZafSpinControl(10, 4, 24, new ZafRealData(1.1));
	spin->Add(new ZafReal(0, 0, 15, ZAF_NULLP(ZafRealData)));
	Add(spin);
			
	// Create a ZafTime spin control with a prompt.
	prompt = new ZafPrompt(1, 5, 8, new ZafStringData(ZAF_ITEXT("Time:")));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	spin = new ZafSpinControl(10, 5, 24, new ZafTimeData(0, 1, 0, 0));
	spin->Add(new ZafTime(0, 0, 15, ZAF_NULLP(ZafTimeData)));
	Add(spin);

	// Create a ZafUTime spin control with a prompt.
	prompt = new ZafPrompt(1, 6, 8, new ZafStringData(ZAF_ITEXT("UTime:")));
	prompt->SetHzJustify(ZAF_HZ_RIGHT);
	Add(prompt);
	spin = new ZafSpinControl(10, 6, 24, new ZafUTimeData(0, 0, 0, 0, 1, 0, 0));
	spin->Add(new ZafUTime(0, 0, 15, ZAF_NULLP(ZafUTimeData)));
	Add(spin);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new SpinControlWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

