//	Zinc Application Framework - SCLWIN.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>

// ----- ScrolledWindow -----------------------------------------------------

class ScrolledWindow : public ZafScrolledWindow
{
public:
	ScrolledWindow(int left, int top);
};

ScrolledWindow::ScrolledWindow(int left, int top) :
	ZafScrolledWindow(left, top, 50, 10, 1000, 1000)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("ScrolledWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Scrolled Window")));

	// Add the scroll information.
	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_CORNER_SCROLL));
	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_VERTICAL_SCROLL));
	Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_HORIZONTAL_SCROLL));

	// Add the scroll information.
	ZafScrollBar *scrollBar = new ZafScrollBar(10, 10, 40, 300, new ZafScrollData(0, 100, 0), ZAF_VERTICAL_SLIDER);
	scrollBar->SetSupportObject(false);
	scrollBar->SetRegionType(ZAF_INSIDE_REGION);
	scrollBar->SetCoordinateType(ZAF_PIXEL);
	Add(scrollBar);

	scrollBar = new ZafScrollBar(60, 60, 300, 40, new ZafScrollData(0, 100, 0), ZAF_HORIZONTAL_SLIDER);
	scrollBar->SetSupportObject(false);
	scrollBar->SetRegionType(ZAF_INSIDE_REGION);
	scrollBar->SetCoordinateType(ZAF_PIXEL);
	Add(scrollBar);
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new ScrolledWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}

