//	Zinc Application Framework - COMBO.CPP
//	COPYRIGHT (C) 1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_appall.hpp>

static ZafUInt8 bitmapArray[16][16] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};
static ZafImageStruct bitmapInfo = 
{
	16, 16, (ZafLogicalColor *)bitmapArray, true
};

// ----- ComboWindow --------------------------------------------------------

class ComboWindow : public ZafWindow
{
public:
	ComboWindow(int left, int top);
	~ComboWindow(void);

private:
	ZafBitmapData bitmapData;
};

ComboWindow::ComboWindow(int left, int top) :
	ZafWindow(left, top, 40, 9),
	bitmapData(bitmapInfo)
{
	// Set the window information.
	SetStringID(ZAF_ITEXT("ComboWindow"));
	if (left == 0 && top == 0)
		zafWindowManager->Center(this);
	bitmapData.SetDestroyable(false);

	// Create the window decorations.
	Add(new ZafBorder);
	Add(new ZafMaximizeButton);
	Add(new ZafMinimizeButton);
	Add(new ZafSystemButton);
	Add(new ZafTitle(new ZafStringData("Combo Window")));

	ZafComboBox *combo1 = new ZafComboBox(1, 1, 20, 6);

	ZafComboBox *combo2 = new ZafComboBox(1, 3, 20, 6);

	ZafComboBox *combo3 = new ZafComboBox(1, 5, 20, 6);
	combo3->SetOSDraw(false);
	combo3->SetViewOnly(true);

	// Add children to the lists.
	ZafString *stringField;
	ZafButton *buttonField;
	for (int i = 1; i <= 10; i++)
	{
		// Add textual children.
		ZafIChar buffer[64];
		sprintf(buffer, ZAF_ITEXT("string %d"), i);
		stringField = new ZafString(0, 0, 8, new ZafStringData(buffer));
		stringField->SetBordered(false);
		combo2->Add(stringField);
		stringField = new ZafString(0, 0, 8, new ZafStringData(buffer));
		stringField->SetBordered(false);
		combo3->Add(stringField);

		// Add button children.
		sprintf(buffer, ZAF_ITEXT("button %d"), i);
		if (i % 2)
			buttonField = new ZafButton(0, 0, 8, 1, new ZafStringData(buffer), &bitmapData);
		else
			buttonField = new ZafButton(0, 0, 8, 1, new ZafStringData(buffer));
		buttonField->SetBordered(false);
		buttonField->SetButtonType(ZAF_FLAT_BUTTON);
		buttonField->SetHzJustify(ZAF_HZ_LEFT);
		combo3->Add(buttonField);
	}
	Add(combo1);
	Add(combo2);
	Add(combo3);
}

ComboWindow::~ComboWindow(void)
{
	// We must specifically destroy the window's children before the static
	// iconData is destroyed (The natural call sequence order of destruction
	// is wrong).
	ZafList::Destroy();
}

// ----- Main() -------------------------------------------------------------

int ZafApplication::Main(void)
{
	// Ensure main() is linked properly.
	LinkMain();

	// Add the windows to the window manager.
	zafWindowManager->Add(new ComboWindow(0, 0));

	// Get the user input.
	Control();

	// Return success.
	return (0);
}
