//	Zinc Application Framework - W_TITLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_title.hpp>

// ----- ZafTitle ----------------------------------------------------------

ZafPaletteMap ZAF_FARDATA ZafTitle::defaultPaletteMap[] =
{
	{ ZAF_PM_ANY_TYPE, ZAF_PM_ANY_STATE, { ZAF_LINE_DEFAULT, ZAF_PTN_DEFAULT, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_DEFAULT, ZAF_MONO_DEFAULT, ZAF_FNT_DEFAULT } }
};

ZafEventType ZafTitle::Event(const ZafEventStruct &event)
{
	if (event.type == S_REGISTER_OBJECT)
	{
		screenID = parent->OSScreenID(ZAF_FRAMEID);
		OSSetText();
	}
	else if (event.type == S_DEINITIALIZE)
		screenID = 0;

	return (S_UNKNOWN);
}

// ----- OS Specific Functions ----------------------------------------------

void ZafTitle::OSRegisterObject(void)
{
}

ZafError ZafTitle::OSSetText(void)
{
	// Set the windows text.
	if (screenID)
	{
		if (ZafMSWindowsApp::convertText)
		{
			char *osText = zafCodeSet->ConvertToOSString(*stringData, ZAF_NULLP(char), FALSE);
#if defined(ZAF_WIN32) && defined(ZAF_UNICODE)
			::SendMessageA(screenID, WM_SETTEXT, (WPARAM)0, (LPARAM)osText);
#else
			::SendMessage(screenID, WM_SETTEXT, (WPARAM)0, (LPARAM)osText);
#endif
		}
		else
			::SendMessage(screenID, WM_SETTEXT, (WPARAM)0, (LPARAM)stringData->Text());
	}

	return ZAF_ERROR_NONE;
}

// ----- Stubs --------------------------------------------------------------

ZafEventType ZafTitle::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	// Handled by windows.
	return (ccode);
}

void ZafTitle::OSSize(void)
{
	// Handled automatically by Windows.
}

ZafError ZafTitle::OSUpdatePalettes(ZafPaletteType, ZafPaletteType)
{
	return (ZAF_ERROR_NONE);
}

