//	Zinc Application Framework - W_TIMER.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_timer.hpp>

// ----- ZafTimer ----------------------------------------------------------

ZafEventType ZafTimer::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case D_INITIALIZE:
		timerID = SetTimer(NULL, ZAF_DEVICE_TIMER_ID, (UINT)interval, NULL);
		break;

	case D_DEINITIALIZE:
		KillTimer(NULL, timerID);
		break;

	case S_ADD_OBJECT:
		Add(event.windowObject);
		break;

	case S_SUBTRACT_OBJECT:
		Subtract(event.windowObject);
		break;

	default:
		ccode = S_UNKNOWN;
		break;
	}

	// Return the control code.
	return (ccode);
}

void ZafTimer::Poll(void)
{
	if (DeviceState() == D_OFF)
		return;

	// Get the next event (without removing it from the queue).
	ZafEventStruct event;
	eventManager->Get(event, Q_NO_BLOCK | Q_BEGIN | Q_NO_DESTROY | Q_NO_POLL);

	if (event.osEvent.message == WM_TIMER && event.osEvent.wParam == timerID)
	{
		// Remove the event from the queue.
		eventManager->Get(event, Q_NO_BLOCK | Q_BEGIN | Q_NO_POLL);

		// Call the specified notification objects.
		ZafEventStruct event;
		event.device = this;
		for (ZafNotifyList::ZafNotifyElement *element = notifyList.First(); element; element = element->Next())
		{
			event.type = element->notifyMessage ? element->notifyMessage : notifyMessage;
			element->notifyObject->Event(event);
		}

		// Check for queued events.
		if (QueueEvents())
		{
			event.type = notifyMessage;
			eventManager->Put(event);
		}
	}
}
