//	Zinc Application Framework - W_TABLE2.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_table.hpp>

ZafEventType ZafTableRecord::Draw(const ZafEventStruct &event, ZafEventType ccode)
{
	// Compute the actual draw region.
	ZafRegionStruct drawRegion = BeginDraw();

	// Erase the background.
	DrawBackground(drawRegion, ccode);

	// Draw the table records.
	ZafEventStruct childEvent = event;
	for (ZafWindowObject *object = First(); object; object = object->Next())
	{
		if (!object->SystemObject() && object->zafRegion.Overlap(event.region, childEvent.region))
		{
			childEvent.region.left -= object->zafRegion.left;
			childEvent.region.right -= object->zafRegion.left;
			childEvent.region.top -= object->zafRegion.top;
			childEvent.region.bottom -= object->zafRegion.top;
			object->Draw(childEvent, ccode);
		}
	}

	// Draw the record grid, if appropriate.
	ZafTable *table = DynamicPtrCast(parent, ZafTable);
	if (table->Grid() && (ccode == S_REDISPLAY || ccode == S_REDISPLAY_REGION))
	{
		// Compute the actual draw region.
		ZafPaletteState state = PaletteState();
		ZafPaletteStruct outline = LogicalPalette(ZAF_PM_DARK_SHADOW, state);
		display->SetPalette(outline);
		display->Line(drawRegion.left, drawRegion.top, drawRegion.right, drawRegion.top);
	}

	// Return the control code.
	EndDraw();
	return (ccode);
}

// ----- OS Specific Functions ----------------------------------------------

void ZafTableRecord::OSRegisterObject(void)
{
	screenID = parent->screenID;
}

OSWindowID ZafTableRecord::OSScreenID(ZafScreenIDType) const
{
	return screenID;
}


