//	Zinc Application Framework - W_TABLE1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_table.hpp>

LRESULT CALLBACK TableHeaderProc(HWND hwnd, UINT wMsg, WPARAM wParam, LPARAM lParam)
{
	if (wMsg == WM_NCPAINT)
	{
		ZafWindowObject *header = ZafMSWindowsApp::ObjectFromHandle(hwnd);

		ZafRegionStruct drawRegion;
		drawRegion.left = drawRegion.top = 0;
		drawRegion.right = header->zafRegion.Width() - 1;
		drawRegion.bottom = header->zafRegion.Height() - 1;

		HDC hDC = GetWindowDC(hwnd);
		header->display->BeginDraw(hDC, hwnd, drawRegion, drawRegion);

		if (header->Bordered())
			header->DrawShadow(drawRegion, 2, S_REDISPLAY);

		header->display->EndDraw();
	
		return 0;
	}

	return ZafMSWindowsApp::JumpProc(hwnd, wMsg, wParam, lParam);
}

ZafEventType ZafTableHeader::Draw(const ZafEventStruct &event, ZafEventType ccode)
{
	ZafRegionStruct drawRegion = BeginDraw();

	// Erase the background.
	DrawBackground(drawRegion, ccode);

	// Draw the header objects.
	ZafEventStruct childEvent = event;
	for (ZafWindowObject *object = First(); object; object = object->Next())
	{
		if (object->zafRegion.Overlap(event.region, childEvent.region))
		{
			childEvent.region.left -= object->zafRegion.left;
			childEvent.region.right -= object->zafRegion.left;
			childEvent.region.top -= object->zafRegion.top;
			childEvent.region.bottom -= object->zafRegion.top;
			object->Draw(childEvent, ccode);
		}
	}

	// Return the control code.
	EndDraw();

	return (true);
}

ZafEventType ZafTableHeader::DrawBorder(ZafRegionStruct &region, ZafEventType ccode)
{
	return ZafWindowObject::DrawBorder(region, ccode);
}

void ZafTableHeader::OSRegisterObject(void)
{
	ZafWindow::OSRegisterObject();

	// Re-direct the frame window's "window procedure."
	SetWindowLong(screenID, GWL_WNDPROC, (LONG)TableHeaderProc);
}

OSWindowID ZafTableHeader::OSScreenID(ZafScreenIDType type) const
{
	return ZafWindow::OSScreenID(type);
}

