//	Zinc Application Framework - W_TABLE.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#define USE_RAW_KEYS
#include "w_app.hpp"
#include <z_keymap.hpp>
#include <z_table.hpp>

ZafEventType ZafTable::Draw(const ZafEventStruct &event, ZafEventType ccode)
{
	ZafRegionStruct drawRegion = BeginDraw();

	// Erase the background.
	if (last)
	{
		ZafRegionStruct backgroundRegion = drawRegion;
		backgroundRegion.left += Last()->zafRegion.right + 1;
		DrawBackground(backgroundRegion, ccode);
		backgroundRegion.right = backgroundRegion.left - 1;
		backgroundRegion.left = drawRegion.left;
		backgroundRegion.top += Last()->zafRegion.bottom + 1;
		DrawBackground(backgroundRegion, ccode);
	}
	else
		DrawBackground(drawRegion, ccode);

	// Draw the table records.
	ZafEventStruct childEvent = event;
	for (ZafWindowObject *object = First(); object; object = object->Next())
	{
		if (object->zafRegion.Overlap(event.region, childEvent.region))
		{
			childEvent.region.left -= object->zafRegion.left;
			childEvent.region.right -= object->zafRegion.left;
			childEvent.region.top -= object->zafRegion.top;
			childEvent.region.bottom -= object->zafRegion.top;
			object->Draw(childEvent, ccode);
		}
	}

	// Return the control code.
	EndDraw();

	return (true);
}

// ----- Stubs --------------------------------------------------------------

void ZafTable::OSRegisterObject(void)
{
	ZafWindow::OSRegisterObject();
}

OSWindowID ZafTable::OSScreenID(ZafScreenIDType type) const
{
	return (ZafWindow::OSScreenID(type));
}


