//	Zinc Application Framework - W_STATUS.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_app.hpp>
#include <z_bitmap.hpp>
#include <z_status.hpp>
#include <z_utils.hpp>

//??? This should be in img_us.cpp?
static ZafLogicalColor ZAF_FARDATA sizeGripArray[] =
{
	255,255,255,255,255,255,255,255,255,255,255,255,255, 16,
	255,255,255,255,255,255,255,255,255,255,255,255, 16,  7,
	255,255,255,255,255,255,255,255,255,255,255, 16,  8,  7,
	255,255,255,255,255,255,255,255,255,255, 16,  8,  8,  7,
	255,255,255,255,255,255,255,255,255, 16,  8,  8,  7,  7,
	255,255,255,255,255,255,255,255, 16,  8,  8,  7, 16,  7,
	255,255,255,255,255,255,255, 16,  8,  8,  7, 16,  8,  7,
	255,255,255,255,255,255, 16,  8,  8,  7, 16,  8,  8,  7,
	255,255,255,255,255, 16,  8,  8,  7, 16,  8,  8,  7,  7,
	255,255,255,255, 16,  8,  8,  7, 16,  8,  8,  7, 16,  7,
	255,255,255, 16,  8,  8,  7, 16,  8,  8,  7, 16,  8,  7,
	255,255, 16,  8,  8,  7, 16,  8,  8,  7, 16,  8,  8,  7,
	255, 16,  8,  8,  7, 16,  8,  8,  7, 16,  8,  8,  7,  7,
	 16,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7,  7
};
static ZafBitmapStruct _sizeGrip_ZafBitmap(14,14,sizeGripArray,true);
ZafBitmapData *ZafStatusBar::sizeGripBitmap;

ZafPaletteMap ZAF_FARDATA ZafStatusBar::defaultPaletteMap[] =
{
	{ ZAF_PM_BACKGROUND, ZAF_PM_ANY_STATE, { ZAF_LINE_SOLID, ZAF_PTN_SOLID_FILL, ZAF_CLR_DEFAULT, ZAF_CLR_DEFAULT, ZAF_MONO_WHITE, ZAF_MONO_BLACK, ZAF_FNT_DIALOG } },
	{ ZAF_PM_NONE, 0 }
};

ZafPositionStruct ZafStatusBar::ConvertToOSPosition(const ZafWindowObject *object,
	const ZafPositionStruct *position) const
{
	ZafPositionStruct osPosition = ZafWindowObject::ConvertToOSPosition(object, position);
	if (bordered)
		osPosition.line += ZAF_BORDER_WIDTH;
	return (osPosition);
}

ZafPositionStruct ZafStatusBar::ConvertToZafPosition(const ZafWindowObject *object,
	const ZafPositionStruct *position) const
{
	ZafPositionStruct zafPosition = ZafWindowObject::ConvertToZafPosition(object, position);
	if (bordered)
		zafPosition.line -= ZAF_BORDER_WIDTH;
	return (zafPosition);
}

void ZafStatusBar::ConvertRegion(ZafRegionStruct &region, ZafCoordinateType newType)
{
	if (newType != region.coordinateType)
	{
		int offset = -display->postSpace;

		// Add space for the border.
		if (Bordered())
			offset += ZAF_BORDER_WIDTH;

		if (newType == ZAF_CELL)
			region.bottom -= (int)display->ConvertYValue(offset, ZAF_PIXEL, region.coordinateType);

		ZafWindowObject::ConvertRegion(region, newType);

		if (coordinateType == ZAF_CELL)
			region.bottom += (int)display->ConvertYValue(offset, ZAF_PIXEL, newType);
	}
}

ZafEventType ZafStatusBar::Draw(const ZafEventStruct &event, ZafEventType ccode)
{
	ZafRegionStruct drawRegion = BeginDraw();

	if (Bordered())
	{
		if (ccode == S_REDISPLAY || ccode == S_REDISPLAY_REGION)
		{
			ZafPaletteState state = PaletteState();
			display->SetPalette(LogicalPalette(ZAF_PM_DARK_SHADOW, state));
			display->Line(drawRegion.left, drawRegion.top, drawRegion.right, drawRegion.top);
			drawRegion.top++;
			display->SetPalette(LogicalPalette(ZAF_PM_LIGHT_SHADOW, state));
			display->Line(drawRegion.left, drawRegion.top, drawRegion.right, drawRegion.top);
			drawRegion.top++;
		}
		else
			drawRegion.top += 2;
	}

	// Erase the background.
	DrawBackground(drawRegion, ccode);

	// Draw the children.
	ZafEventStruct childEvent = event;
	for (ZafWindowObject *object = First(); object; object = object->Next())
	{
		if (object->zafRegion.Overlap(event.region, childEvent.region))
		{
			childEvent.region.left -= object->zafRegion.left;
			childEvent.region.right -= object->zafRegion.left;
			childEvent.region.top -= object->zafRegion.top;
			childEvent.region.bottom -= object->zafRegion.top;
			object->Draw(childEvent, ccode);
		}
	}

	if (ccode == S_REDISPLAY || ccode == S_REDISPLAY_REGION &&
		DynamicPtrCast(parent, ZafWindow)->Sizeable())
		display->Bitmap(drawRegion.right - 13, drawRegion.bottom - 13, *sizeGripBitmap);

	EndDraw();

	return ccode;
}

ZafEventType ZafStatusBar::DrawBorder(ZafRegionStruct &region, ZafEventType ccode)
{
	return DrawShadow(region, -1, ccode);
}

ZafEventType ZafStatusBar::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	if (ccode == E_OSEVENT)
		return ZafStatusBar::OSEvent(event);

	// Switch on the event type.
	switch (ccode)
	{
	case S_COMPUTE_SIZE:
		{
		int height = zafRegion.bottom - zafRegion.top;
		ccode = ZafWindowObject::Event(event);
		zafRegion.top = zafRegion.bottom - height;
		}
		break;

	case N_SIZE:
		ccode = ZafWindow::Event(event);

		RECT rect;
		rect.left = ZafMin(oldRegion.right - 13, zafRegion.right - 13);
		rect.right = ZafMax(oldRegion.right, zafRegion.right) + 1;
		rect.top = 0;
		rect.bottom = zafRegion.Height();
		InvalidateRect(screenID, &rect, TRUE);
		break;

	default:
		ccode = ZafWindow::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

ZafRegionStruct ZafStatusBar::MaxRegion(ZafWindowObject *, ZafVtJustify, ZafHzJustify)
{
	ZafRegionStruct maxRegion;
	maxRegion.left = 0;
	maxRegion.top = display->preSpace;
	if (Bordered())
		maxRegion.top += 2;
	maxRegion.right = zafRegion.Width() - 1;
	maxRegion.bottom = zafRegion.Height() - 1;
	return (maxRegion);
}

void ZafStatusBar::ImageAllocate(void)
{
	// Initialize the image.
	if (!sizeGripBitmap)
	{
		ZafApplication::AddStaticModule(ImageFree);
		sizeGripBitmap = new ZafBitmapData(_sizeGrip_ZafBitmap);
	}
}

void ZafStatusBar::ImageFree(bool globalRequest)
{
	// Destroy the static images.
	if (globalRequest && sizeGripBitmap)
	{
		delete sizeGripBitmap;
		sizeGripBitmap = ZAF_NULLP(ZafBitmapData);
	}
}

// ----- OS Specific Functions ----------------------------------------------

ZafEventType ZafStatusBar::OSEvent(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	switch (event.osEvent.message)
	{
	case WM_LBUTTONDOWN:
	case WM_RBUTTONDOWN:
#if defined(ZAF_WIN32)
		SetForegroundWindow(RootObject()->OSScreenID(ZAF_FRAMEID));
#else
		SetActiveWindow(RootObject()->OSScreenID(ZAF_FRAMEID));
#endif
		break;

	case WM_PAINT:
	case WM_ERASEBKGND:
		ccode = ZafWindowObject::Event(event);
		break;

	default:
		ccode = ZafWindow::Event(event);
	}

	return ccode;
}

void ZafStatusBar::OSMapPalette(ZafPaletteStruct &palette, ZafPaletteType type, ZafPaletteState state)
{
	if (type == ZAF_PM_BACKGROUND)
		palette.osPalette.colorForeground = palette.osPalette.colorBackground = GetSysColor(COLOR_3DFACE);
	else
		ZafWindow::OSMapPalette(palette, type, state);
}

void ZafStatusBar::OSRegisterObject(void)
{
	DWORD dwStyle = WS_CHILD;
	if (visible)
		dwStyle |= WS_VISIBLE;
//???#if defined ZAF_WIN32
//???	if (ZafMSWindowsApp::commonControlsAvailable)
//???	{
//???		dwStyle |= SBS_SIZEGRIP;
//???		screenID = ZafMSWindowsApp::CreateSubclassedWindow(this, STATUSCLASSNAME, dwStyle);
//???	}
//???	else
//???		screenID = ZafMSWindowsApp::CreateSubclassedWindow(this, NULL, dwStyle);
//???#else
	screenID = ZafMSWindowsApp::CreateSubclassedWindow(this, NULL, dwStyle);
//???#endif
}

// ----- Stubs --------------------------------------------------------------

OSWindowID ZafStatusBar::OSScreenID(ZafScreenIDType) const
{
	return (screenID);
}

void ZafStatusBar::OSSize(void)
{
	ZafWindowObject::OSSize();
}


