//	Zinc Application Framework - W_PLLDN1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_plldn.hpp>

// ----- ZafPullDownItem -------------------------------------------------

ZafPaletteMap ZAF_FARDATA ZafPullDownItem::defaultPaletteMap[] =
{
	// Palette is inherited from ZafWindowObject.
	{ ZAF_PM_NONE, 0 }
};

ZafEventType ZafPullDownItem::Event(const ZafEventStruct &event)
{
	// Switch on the event type.
	ZafEventType ccode = event.type;
	switch (ccode)
	{
	case S_INITIALIZE:
	case S_DEINITIALIZE:
	case S_REGISTER_OBJECT:
		menu.Event(event);
		ccode = ZafWindowObject::Event(event);
		break;

	case S_CREATE:
		ccode = ZafWindowObject::Event(event);
		DrawMenuBar(RootObject()->OSScreenID(ZAF_FRAMEID));
		break;

	case S_DESTROY:
		{
		RemoveMenu((HMENU)screenID, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, MF_BYCOMMAND);
		if (menu.screenID)
			DestroyMenu((HMENU)menu.screenID);
		Event(ZafEventStruct(S_DEINITIALIZE));
		}
		break;

	case S_CURRENT:
		ccode = ZafWindowObject::Event(event);
		Event(N_CURRENT);
		break;

	case S_NON_CURRENT:
		// NotifyFocus() is not used by menus... propegate the message.
		if (menu.Focus())
			menu.Event(event);
		Event(N_NON_CURRENT);
		ccode = ZafWindowObject::Event(event);
		break;

	default:
		ccode = ZafWindowObject::Event(event);
	}

	// Return the control code.
	return (ccode);
}

bool ZafPullDownItem::SetDisabled(bool setDisabled)
{
	if (setDisabled != disabled)
	{
		// Set the attribute.
		disabled = setDisabled;

		// Set the selectabilty with the OS.
		if (screenID)
		{
			EnableMenuItem((HMENU)screenID, ListIndex(), MF_BYPOSITION | (disabled ? MF_GRAYED : MF_ENABLED));
			DrawMenuBar(RootObject()->OSScreenID(ZAF_FRAMEID));
		}
	}

	return disabled;
}

// ----- OS Specific Functions ----------------------------------------------

ZafEventType ZafPullDownItem::OSEvent(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	switch (event.osEvent.message)
	{
	case WM_COMMAND:
		// Item was selected.
		Event(ZafEventStruct(L_SELECT));
		break;
	
	default:
		ccode = ZafWindowObject::Event(event);
	}

	return (ccode);
}

void ZafPullDownItem::OSRegisterObject(void)
{
	screenID = parent->screenID;

	UINT flags = MF_STRING;
	if (menu.First())
		flags |= MF_POPUP;
	if (disabled)
		flags |= MF_GRAYED;

	if (ZafMSWindowsApp::convertText)
	{
		char *osText = zafCodeSet->ConvertToOSString(*stringData, ZAF_NULLP(char), false);
#if defined(ZAF_WIN32) && defined(ZAF_UNICODE)
		AppendMenuA((HMENU)screenID, flags, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, osText);
#else
		AppendMenu((HMENU)screenID, flags, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, osText);
#endif
	}
#if defined(ZAF_WIN32) || !defined(ZAF_UNICODE)
	else
		AppendMenu((HMENU)screenID, flags, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, *stringData);
#endif
}

ZafError ZafPullDownItem::OSSetText(void)
{
	if (screenID)
	{
//??? Modifying a menu item destroys its menu?
		if (ZafMSWindowsApp::convertText)
		{
			char *osText = zafCodeSet->ConvertToOSString(*stringData, ZAF_NULLP(char), false);
#if defined(ZAF_WIN32) && defined(ZAF_UNICODE)
			ModifyMenuA(screenID, ListIndex(), MF_STRING | MF_BYPOSITION, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, osText);
#else
			ModifyMenu((HMENU)screenID, ListIndex(), MF_STRING | MF_BYPOSITION, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, osText);
#endif
		}
#if defined(ZAF_WIN32) || !defined(ZAF_UNICODE)
		else
			ModifyMenu((HMENU)screenID, ListIndex(), MF_STRING | MF_BYPOSITION, menu.screenID ? (UINT)menu.screenID : (UINT)numberID, *stringData);
#endif
		DrawMenuBar(parent->parent->OSScreenID(ZAF_FRAMEID));
	}
	return (ZAF_ERROR_NONE);
}

// ----- Stubs --------------------------------------------------------------

ZafEventType ZafPullDownItem::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	return ccode;
}

void ZafPullDownItem::OSMapPalette(ZafPaletteStruct &, ZafPaletteType, ZafPaletteState)
{
}

void ZafPullDownItem::OSSize(void)
{
}
