//	Zinc Application Framework - W_PLLDN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_plldn.hpp>

// ----- ZafPullDownMenu -------------------------------------------------

ZafEventType ZafPullDownMenu::Event(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	if (ccode == E_OSEVENT)
		return ZafPullDownMenu::OSEvent(event);

	switch (ccode)
	{
	case S_INITIALIZE:
		systemObject = false;
		ccode = ZafWindowObject::Event(event);
		BroadcastEvent(event);
		break;

	case S_DEINITIALIZE:
		ccode = ZafWindowObject::Event(event);
		BroadcastEvent(event);
		break;

	case S_REGISTER_OBJECT:
		screenID = (HWND)CreateMenu();
		SetMenu(parent->OSScreenID(ZAF_FRAMEID), (HMENU)screenID);
		BroadcastEvent(event);
		break;

	case S_CURRENT:
		ccode = ZafWindowObject::Event(event);
		Event(N_CURRENT);
		break;

	case S_NON_CURRENT:
		// NotifyFocus() is not used by menus... propegate the message.
		if (current && Current()->Focus())
			Current()->Event(event);
		SetCurrent(ZAF_NULLP(ZafWindowObject));
		Event(N_NON_CURRENT);
		ccode = ZafWindowObject::Event(event);
		break;

	default:
		ccode = ZafWindowObject::Event(event);
		break;
	}

	// Return the control code.
	return (ccode);
}

// ----- OS Specific Functions ----------------------------------------------

ZafEventType ZafPullDownMenu::OSEvent(const ZafEventStruct &event)
{
	ZafEventType ccode = event.type;

	switch (event.osEvent.message)
	{
	case WM_MENUSELECT:
		{
#if defined(ZAF_WIN32)
		UINT itemID = (UINT)LOWORD(event.osEvent.wParam);
		UINT flags = (UINT)HIWORD(event.osEvent.wParam);
		HWND hMenu = (HWND)event.osEvent.lParam;
#else
		WORD itemID = event.osEvent.wParam;
		WORD flags = LOWORD(event.osEvent.lParam);
		HWND hMenu = (HWND)HIWORD(event.osEvent.lParam);
#endif
		ZafPullDownItem *currentItem = DynamicPtrCast(Current(), ZafPullDownItem);
		if (hMenu == screenID)
		{
			// Find the selected item.
			ZafWindowObject *selectedItem;
			for (selectedItem = First(); selectedItem; selectedItem = selectedItem->Next())
			{
				ZafPullDownItem *item = DynamicPtrCast(selectedItem, ZafPullDownItem);
				if (item)
				{
					if (flags & MF_POPUP)
					{
						if ((HMENU)item->menu.screenID == (HMENU)itemID)
							break;
					}
					else if (item->NumberID() == itemID)
						break;
				}
			}

			// Adjust the focus at the menu level.
			if (!focus)
				Event(ZafEventStruct(S_CURRENT));
			else if (currentItem && currentItem->menu.Focus())
				currentItem->menu.Event(ZafEventStruct(S_NON_CURRENT));

			// Adjust the focus at the item level.
			if (selectedItem && !selectedItem->Focus())
			{
				if (currentItem && currentItem->Focus())
					currentItem->Event(ZafEventStruct(S_NON_CURRENT));
				SetCurrent(selectedItem);
				selectedItem->Event(ZafEventStruct(S_CURRENT));
			}
		}
		else if (currentItem)
			currentItem->menu.Event(event);
		}
		break;
	
	default:
		ccode = ZafWindowObject::OSEvent(event);
	}

	return (ccode);
}

// ----- Stubs --------------------------------------------------------------

void ZafPullDownMenu::OSRegisterObject(void)
{
}

ZafEventType ZafPullDownMenu::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	// The pull down menu is always drawn by windows.
	return ccode;
}

ZafEventType ZafPullDownMenu::DrawBorder(ZafRegionStruct &, ZafEventType ccode)
{
	// The pull down menu is always drawn by windows.
	return ccode;
}

ZafRegionStruct ZafPullDownMenu::MaxRegion(ZafWindowObject *, ZafVtJustify, ZafHzJustify)
{
	return zafRegion;
}

OSWindowID ZafPullDownMenu::OSScreenID(ZafScreenIDType) const
{
	return screenID;
}

void ZafPullDownMenu::OSSize(void)
{
}
