//	Zinc Application Framework - W_MIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_min.hpp>

// ----- ZafMinimizeButton ------------------------------------------------

ZafPaletteMap ZAF_FARDATA ZafMinimizeButton::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0 }
};

ZafEventType ZafMinimizeButton::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	// Automatically drawn by windows.
	return (ccode);
}

ZafEventType ZafMinimizeButton::Event(const ZafEventStruct &event)
{
	if (event.type == S_REGISTER_OBJECT)
		screenID = parent->OSScreenID(ZAF_FRAMEID);
	else if (event.type == S_DEINITIALIZE)
		screenID = 0;

	return (S_UNKNOWN);
}

// ----- OS Specific Functions ----------------------------------------------

void ZafMinimizeButton::OSRegisterObject(void)
{
}

void ZafMinimizeButton::OSSize(void)
{
	// Handled automatically by Windows.
}

ZafError ZafMinimizeButton::OSUpdatePalettes(ZafPaletteType, ZafPaletteType)
{
	return (ZAF_ERROR_NONE);
}

