//	Zinc Application Framework - W_MAX.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_max.hpp>

// ----- ZafMaximizeButton ------------------------------------------------

ZafPaletteMap ZAF_FARDATA ZafMaximizeButton::defaultPaletteMap[] =
{
	{ ZAF_PM_NONE, 0 }
};

ZafEventType ZafMaximizeButton::Draw(const ZafEventStruct &, ZafEventType ccode)
{
	// Automatically drawn by windows.
	return (ccode);
}

ZafEventType ZafMaximizeButton::Event(const ZafEventStruct &event)
{
	if (event.type == S_REGISTER_OBJECT)
		screenID = parent->OSScreenID(ZAF_FRAMEID);
	else if (event.type == S_DEINITIALIZE)
		screenID = 0;

	return (S_UNKNOWN);
}

// ----- OS Specific Functions ----------------------------------------------

void ZafMaximizeButton::OSRegisterObject(void)
{
}

void ZafMaximizeButton::OSSize(void)
{
	// Handled automatically by Windows.
}

ZafError ZafMaximizeButton::OSUpdatePalettes(ZafPaletteType, ZafPaletteType)
{
	return (ZAF_ERROR_NONE);
}

