//	Zinc Application Framework - W_LOC.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_loc.hpp>
#include <z_string.hpp>
#include <w_app.hpp>
#include <z_cset.hpp>
#include <z_utils.hpp>
#include <z_stdlib.hpp>

bool ZafLocaleData::OSLocaleInformation(ZafLocaleStruct &localeInfo)
{
		char intlString[] = { 'I','n','t','l', 0 };
//		char iCountry[] = { 'i','C','o','u','n','t','r','y', 0 };

//		char sLanguage[] = { 's','L','a','n','g','u','a','g','e', 0 };
		char sDecimal[] = { 's','D','e','c','i','m','a','l', 0 };
		char sThousand[] = { 's','T','h','o','u','s','a','n','d', 0 };
		char sCurrency[] = { 's','C','u','r','r','e','n','c','y', 0 };
		char sDate[] = { 's','D','a','t','e', 0 };
		char sTime[] = { 's','T','i','m','e', 0 };
		char iCurrency[] = { 'i','C','u','r','r','e','n','c','y', 0 };
		char iNegCurr[] = { 'i','N','e','g','C','u','r','r', 0 };
		char iCurrDigits[] = { 'i','C','u','r','r','D','i','g','i','t','s', 0 };
//		char iDate[] = { 'i','D','a','t','e', 0 };
//		char iTime[] = { 'i','T','i','m','e', 0 };

#if !defined(ZAF_WIN32)
#	if defined(ZAF_UNICODE)
		char tmpBuff[20];
		GetProfileString(intlString, sDecimal, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.decimalSeparator, false);
		GetProfileString(intlString, sDecimal, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.monDecimalSeparator, false);
		GetProfileString(intlString, sThousand, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.thousandsSeparator, false);
		GetProfileString(intlString, sThousand, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.monThousandsSeparator, false);
		GetProfileString(intlString, sCurrency, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.currencySymbol, false);
		strcpy(localeInfo.intCurrencySymbol, localeInfo.currencySymbol);
		GetProfileString(intlString, sDate, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.dateSeparator, false);
		GetProfileString(intlString, sTime, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.timeSeparator, false);
#	else
		GetProfileString(intlString, sDecimal, localeInfo.decimalSeparator,
			 	localeInfo.decimalSeparator, sizeof(localeInfo.decimalSeparator));
		GetProfileString(intlString, sDecimal, localeInfo.monDecimalSeparator,
			 	localeInfo.monDecimalSeparator, sizeof(localeInfo.monDecimalSeparator));
		GetProfileString(intlString, sThousand, localeInfo.thousandsSeparator,
			 	localeInfo.thousandsSeparator, sizeof(localeInfo.thousandsSeparator));
		GetProfileString(intlString, sThousand, localeInfo.monThousandsSeparator,
			 	localeInfo.monThousandsSeparator, sizeof(localeInfo.monThousandsSeparator));
		GetProfileString(intlString, sCurrency, localeInfo.currencySymbol,
			 	localeInfo.currencySymbol, sizeof(localeInfo.currencySymbol));
		strcpy(localeInfo.intCurrencySymbol, localeInfo.currencySymbol);
		GetProfileString(intlString, sDate, localeInfo.dateSeparator,
				localeInfo.dateSeparator, sizeof(localeInfo.dateSeparator));
		GetProfileString(intlString, sTime, localeInfo.timeSeparator,
				localeInfo.timeSeparator, sizeof(localeInfo.timeSeparator));
#	endif
		WORD tmpval;
		static struct {
			int spce;
			int curr;
		} pcstable[] = {
			{ 0, TRUE },
			{ 0, FALSE },
			{ 1, TRUE },
			{ 1, FALSE }
		};
		tmpval = GetProfileInt(intlString, iCurrency, -1);
		if (tmpval < 4) {
			localeInfo.posSpaceSeparation = pcstable[tmpval].spce;
			localeInfo.posCurrencyPrecedes = pcstable[tmpval].curr;
		}
		// ???? posSignPrecedes = 1;
		// ???? positiveSign
		// ???? negativeSign
		static struct {
			int spce;
			int curr;
			int sign;
		} ncstable[] = {
			{ 0, 1, 0 },	// 0
			{ 0, 1, 1 },	// 1
			{ 0, 1, 3 },	// 2
			{ 0, 1, 2 },	// 3
			{ 0, 0, 0 },	// 4
			{ 0, 0, 1 },	// 5
			{ 0, 0, 4 },	// 6
			{ 0, 0, 2 },	// 7
			{ 1, 0, 1 },	// 8
			{ 1, 1, 1 },	// 9
			{ 1, 0, 2 }		// 10
		};
		tmpval = GetProfileInt(intlString, iNegCurr, -1);
		if (tmpval < 11) {
			localeInfo.negSpaceSeparation = ncstable[tmpval].spce;
			localeInfo.negCurrencyPrecedes = ncstable[tmpval].curr;
			localeInfo.negSignPrecedes = ncstable[tmpval].sign;
		}
		localeInfo.fractionDigits =
			GetProfileInt(intlString, iCurrDigits, localeInfo.fractionDigits);
		localeInfo.intFractionDigits = localeInfo.fractionDigits;
		// iDate and sDate should be replaced with sShortDate
/* START BLOCK COMMENT
**			switch (GetProfileInt(intlString, iDate, 0))
**			{
**				case 0:
**					localeInfo.defaultDateFlags = DTF_US_FORMAT;
**					break;
**				case 1:
**					localeInfo.defaultDateFlags = DTF_EUROPEAN_FORMAT;
**					break;
**				case 2:
**					localeInfo.defaultDateFlags = DTF_ASIAN_FORMAT;
**					break;
**			}
**			switch (GetProfileInt(intlString, iTime, 0))
**			{
**				case 0:
**	 				localeInfo.defaultTimeFlags = TMF_TWELVE_HOUR;
**					break;
**				case 1:
**					localeInfo.defaultTimeFlags = TMF_TWENTY_FOUR_HOUR;
**					break;
**			}
END BLOCK COMMENT */
#else
	if (ZafMSWindowsApp::windowsPlatform == ZAF_WIN32_NT)
	{
		ZafIChar buffer[64];
		ZafIChar tmpBuff[32];
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_ILANGUAGE, buffer, 32);
		strcpy(tmpBuff, buffer);
		tmpBuff[0] = '0';	tmpBuff[1] = 'x';
		strlwr(tmpBuff);

		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SDECIMAL, buffer, 4);
		strcpy(localeInfo.decimalSeparator, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SMONDECIMALSEP, buffer, 4);
		strcpy(localeInfo.monDecimalSeparator, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_STHOUSAND, buffer, 4);
		strcpy(localeInfo.thousandsSeparator, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SMONTHOUSANDSEP, buffer, 4);
		strcpy(localeInfo.monThousandsSeparator, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SCURRENCY, buffer, 8);
		strcpy(localeInfo.currencySymbol, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SGROUPING, buffer, 19);
		ZafIChar *buff = buffer;
		int i = 0;
		do
		{
			localeInfo.grouping[i] = 0;
			while (*buff >= '0' && *buff <= '9')
			{
				localeInfo.grouping[i] = localeInfo.grouping[i] * 10 + *buff - '0';
				buff++;
			}
			buff++;
		} while (localeInfo.grouping[i++]);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SMONGROUPING, buffer, 19);
		i = 0;
		do
		{
			localeInfo.monGrouping[i] = 0;
			while (*buff >= '0' && *buff <= '9')
			{
				localeInfo.monGrouping[i] = localeInfo.monGrouping[i] * 10 + *buff - '0';
				buff++;
			}
			buff++;
		} while (localeInfo.monGrouping[i++]);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SINTLSYMBOL, buffer, 8);
		strcpy(localeInfo.intCurrencySymbol, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_IPOSSYMPRECEDES, buffer, 16);
		localeInfo.posCurrencyPrecedes = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_INEGSYMPRECEDES, buffer, 16);
		localeInfo.negCurrencyPrecedes = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_ICURRDIGITS, buffer, 16);
		localeInfo.fractionDigits = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_IINTLCURRDIGITS, buffer, 16);
		localeInfo.intFractionDigits = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SPOSITIVESIGN, buffer, 4);
		strcpy(localeInfo.positiveSign, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_IPOSSYMPRECEDES, buffer, 16);
		localeInfo.posSignPrecedes = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_IPOSSEPBYSPACE, buffer, 16);
		localeInfo.posSpaceSeparation = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SNEGATIVESIGN, buffer, 4);
		strcpy(localeInfo.negativeSign, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_INEGSYMPRECEDES, buffer, 16);
		localeInfo.negSignPrecedes = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_INEGSEPBYSPACE, buffer, 16);
		localeInfo.negSpaceSeparation = atoi(buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_IDATE, buffer, 16);
/* START BLOCK COMMENT
**			switch (atoi(buffer))
**			{
**			case 0:
**				localeInfo.defaultDateFlags = DTF_US_FORMAT;
**				break;
**			case 1:
**				localeInfo.defaultDateFlags = DTF_EUROPEAN_FORMAT;
**				break;
**			case 2:
**				localeInfo.defaultDateFlags = DTF_ASIAN_FORMAT;
**				break;
**			}
END BLOCK COMMENT */
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_SDATE, buffer, 4);
		strcpy(localeInfo.dateSeparator, buffer);
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_ITIME, buffer, 16);
/* START BLOCK COMMENT
**			switch (atoi(buffer))
**			{
**			case 0:
**	 			localeInfo.defaultTimeFlags = TMF_TWELVE_HOUR;
**				break;
**			case 1:
**				localeInfo.defaultTimeFlags = TMF_TWENTY_FOUR_HOUR;
**				break;
**			}
END BLOCK COMMENT */
		GetLocaleInfo(MAKELCID(LANG_NEUTRAL, SORT_DEFAULT), LOCALE_STIME, buffer, 4);
		strcpy(localeInfo.timeSeparator, buffer);
	}
	else
	{
#	if defined(ZAF_UNICODE)
		char tmpBuff[20];
		GetProfileString(intlString, sDecimal, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.decimalSeparator, false);
		GetProfileString(intlString, sDecimal, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.monDecimalSeparator, false);
		GetProfileString(intlString, sThousand, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.thousandsSeparator, false);
		GetProfileString(intlString, sThousand, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.monThousandsSeparator, false);
		GetProfileString(intlString, sCurrency, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.currencySymbol, false);
		strcpy(localeInfo.intCurrencySymbol, localeInfo.currencySymbol);
		GetProfileString(intlString, sDate, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.dateSeparator, false);
		GetProfileString(intlString, sTime, tmpBuff, tmpBuff,
			 	sizeof(tmpBuff));
		zafCodeSet->ConvertToZafString(tmpBuff, localeInfo.timeSeparator, false);
#	else
		GetProfileString(intlString, sDecimal, localeInfo.decimalSeparator,
			 	localeInfo.decimalSeparator, sizeof(localeInfo.decimalSeparator));
		GetProfileString(intlString, sDecimal, localeInfo.monDecimalSeparator,
			 	localeInfo.monDecimalSeparator, sizeof(localeInfo.monDecimalSeparator));
		GetProfileString(intlString, sThousand, localeInfo.thousandsSeparator,
			 	localeInfo.thousandsSeparator, sizeof(localeInfo.thousandsSeparator));
		GetProfileString(intlString, sThousand, localeInfo.monThousandsSeparator,
			 	localeInfo.monThousandsSeparator, sizeof(localeInfo.monThousandsSeparator));
		GetProfileString(intlString, sCurrency, localeInfo.currencySymbol,
			 	localeInfo.currencySymbol, sizeof(localeInfo.currencySymbol));
		strcpy(localeInfo.intCurrencySymbol, localeInfo.currencySymbol);
		GetProfileString(intlString, sDate, localeInfo.dateSeparator,
				localeInfo.dateSeparator, sizeof(localeInfo.dateSeparator));
		GetProfileString(intlString, sTime, localeInfo.timeSeparator,
				localeInfo.timeSeparator, sizeof(localeInfo.timeSeparator));
#	endif
		WORD tmpval;
		static struct {
			int spce;
			int curr;
		} pcstable[] = {
			{ 0, TRUE },
			{ 0, FALSE },
			{ 1, TRUE },
			{ 1, FALSE }
		};
		tmpval = GetProfileInt(intlString, iCurrency, -1);
		if (tmpval < 4) {
			localeInfo.posSpaceSeparation = pcstable[tmpval].spce;
			localeInfo.posCurrencyPrecedes = pcstable[tmpval].curr;
		}
		// ???? posSignPrecedes = 1;
		// ???? positiveSign
		// ???? negativeSign
		static struct {
			int spce;
			int curr;
			int sign;
		} ncstable[] = {
			{ 0, 1, 0 },	// 0
			{ 0, 1, 1 },	// 1
			{ 0, 1, 3 },	// 2
			{ 0, 1, 2 },	// 3
			{ 0, 0, 0 },	// 4
			{ 0, 0, 1 },	// 5
			{ 0, 0, 4 },	// 6
			{ 0, 0, 2 },	// 7
			{ 1, 0, 1 },	// 8
			{ 1, 1, 1 },	// 9
			{ 1, 0, 2 }		// 10
		};
		tmpval = GetProfileInt(intlString, iNegCurr, -1);
		if (tmpval < 11) {
			localeInfo.negSpaceSeparation = ncstable[tmpval].spce;
			localeInfo.negCurrencyPrecedes = ncstable[tmpval].curr;
			localeInfo.negSignPrecedes = ncstable[tmpval].sign;
		}
		localeInfo.fractionDigits =
			GetProfileInt(intlString, iCurrDigits, localeInfo.fractionDigits);
		localeInfo.intFractionDigits = localeInfo.fractionDigits;
		// iDate and sDate should be replaced with sShortDate
/* START BLOCK COMMENT
**			switch (GetProfileInt(intlString, iDate, 0))
**			{
**				case 0:
**					localeInfo.defaultDateFlags = DTF_US_FORMAT;
**					break;
**				case 1:
**					localeInfo.defaultDateFlags = DTF_EUROPEAN_FORMAT;
**					break;
**				case 2:
**					localeInfo.defaultDateFlags = DTF_ASIAN_FORMAT;
**					break;
**			}
**			switch (GetProfileInt(intlString, iTime, 0))
**			{
**				case 0:
**	 				localeInfo.defaultTimeFlags = TMF_TWELVE_HOUR;
**					break;
**				case 1:
**					localeInfo.defaultTimeFlags = TMF_TWENTY_FOUR_HOUR;
**					break;
**			}
END BLOCK COMMENT */

	}
#endif
	return true;
}
