//	Zinc Application Framework - W_FILDLG.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_fildlg.hpp>
#include <z_string.hpp>

ZafFileDialog::ZafFileDialog(int left, int top, int width, int height) :
	ZafDialogWindow(left, top, width, height)
{
	directory[0] = file[0] = filter[0] = 0;
}

ZafEventType ZafFileDialog::GetFile(ZafFileDialogRequest request)
{
	ZafEventType ccode = S_DLG_CANCEL;

	if (ZafMSWindowsApp::convertText)
	{
		char winDirectory[ZAF_MAXPATHLEN];
		char winFile[ZAF_MAXPATHLEN];
		char winFileTitle[ZAF_MAXPATHLEN];
		char winFilter[ZAF_MAXPATHLEN];

		char *osText = zafCodeSet->ConvertToOSString(directory);
		strcpy((char *)winDirectory, osText);
		delete []osText;

		osText = zafCodeSet->ConvertToOSString(file);
		strcpy((char *)winFile, osText);
		strcpy((char *)winFileTitle, osText);
		delete []osText;

		osText = zafCodeSet->ConvertToOSString(filter);
		int filterLen = strlen(filter);
		strcpy((char *)winFilter, osText);
		strcpy((char *)winFilter + filterLen + 1, osText);
		winFilter[2 * (filterLen + 1)] = 0;
		delete []osText;

#if defined(ZAF_WIN32)
		OPENFILENAMEA openFileNameStruct;
#else
		OPENFILENAME openFileNameStruct;
#endif
		openFileNameStruct.lStructSize = sizeof(OPENFILENAME);
		openFileNameStruct.hwndOwner = zafWindowManager->First() ? zafWindowManager->First()->OSScreenID(ZAF_FRAMEID) : 0;
		openFileNameStruct.hInstance = 0;
		openFileNameStruct.lpstrFilter = winFilter;
		openFileNameStruct.lpstrCustomFilter = 0;
		openFileNameStruct.nMaxCustFilter = 0;
		openFileNameStruct.nFilterIndex = 0;
		openFileNameStruct.lpstrFile = winFile;
		openFileNameStruct.nMaxFile = ZAF_MAXPATHLEN;
		openFileNameStruct.lpstrFileTitle = winFileTitle;
		openFileNameStruct.nMaxFileTitle = ZAF_MAXPATHLEN;
		openFileNameStruct.lpstrInitialDir = winDirectory[0] ? winDirectory : 0;
		if (request == ZAF_FILE_DIALOG_NEW)
			openFileNameStruct.lpstrTitle = "New";
		else
			openFileNameStruct.lpstrTitle = 0;
		openFileNameStruct.Flags = OFN_HIDEREADONLY;
		openFileNameStruct.nFileOffset = 0;
		openFileNameStruct.nFileExtension = 0;
		openFileNameStruct.lpstrDefExt = 0;
		openFileNameStruct.lCustData = 0;
		openFileNameStruct.lpfnHook = 0;
		openFileNameStruct.lpTemplateName = 0;

#if defined(ZAF_WIN32)
		if (request == ZAF_FILE_DIALOG_NEW || request == ZAF_FILE_DIALOG_OPEN)
		{
			if (GetOpenFileNameA(&openFileNameStruct))
				ccode = S_DLG_OK;
		}
		else if (GetSaveFileNameA(&openFileNameStruct))
			ccode = S_DLG_OK;
#else
		if (request == ZAF_FILE_DIALOG_NEW || request == ZAF_FILE_DIALOG_OPEN)
		{
			if (GetOpenFileName(&openFileNameStruct))
				ccode = S_DLG_OK;
		}
		else if (GetSaveFileName(&openFileNameStruct))
			ccode = S_DLG_OK;
#endif

		if (ccode == S_DLG_OK)
		{
			ZafIChar *zafText = zafCodeSet->ConvertToZafString(winFile);
			strcpy(directory, zafText);
			directory[openFileNameStruct.nFileOffset] = 0;
			delete []zafText;

			zafText = zafCodeSet->ConvertToZafString(winFileTitle);
			strcpy(file, zafText);
			delete []zafText;
		}
	}
#if defined(ZAF_WIN32) || !defined(ZAF_UNICODE)
	else
	{
		ZafIChar winDirectory[ZAF_MAXPATHLEN];
		ZafIChar winFile[ZAF_MAXPATHLEN];
		ZafIChar winFileTitle[ZAF_MAXPATHLEN];
		ZafIChar winFilter[ZAF_MAXPATHLEN];

		strcpy(winDirectory, directory);
		strcpy(winFile, file);
		strcpy(winFileTitle, file);
		int filterLen = strlen(filter);
		strcpy(winFilter, filter);
		strcpy(winFilter + filterLen + 1, filter);
		winFilter[2 * (filterLen + 1)] = 0;

		OPENFILENAME openFileNameStruct;
		openFileNameStruct.lStructSize = sizeof(OPENFILENAME);
		openFileNameStruct.hwndOwner = zafWindowManager->First() ? zafWindowManager->First()->OSScreenID(ZAF_FRAMEID) : 0;
		openFileNameStruct.hInstance = 0;
		openFileNameStruct.lpstrFilter = winFilter;
		openFileNameStruct.lpstrCustomFilter = 0;
		openFileNameStruct.nMaxCustFilter = 0;
		openFileNameStruct.nFilterIndex = 0;
		openFileNameStruct.lpstrFile = winFile;
		openFileNameStruct.nMaxFile = ZAF_MAXPATHLEN;
		openFileNameStruct.lpstrFileTitle = winFileTitle;
		openFileNameStruct.nMaxFileTitle = ZAF_MAXPATHLEN;
		openFileNameStruct.lpstrInitialDir = winDirectory[0] ? winDirectory : 0;
		if (request == ZAF_FILE_DIALOG_NEW)
			openFileNameStruct.lpstrTitle = ZAF_ITEXT("New");
		else
			openFileNameStruct.lpstrTitle = 0;
		openFileNameStruct.Flags = OFN_HIDEREADONLY;
		openFileNameStruct.nFileOffset = 0;
		openFileNameStruct.nFileExtension = 0;
		openFileNameStruct.lpstrDefExt = 0;
		openFileNameStruct.lCustData = 0;
		openFileNameStruct.lpfnHook = 0;
		openFileNameStruct.lpTemplateName = 0;

		if (request == ZAF_FILE_DIALOG_NEW || request == ZAF_FILE_DIALOG_OPEN)
		{
			if (GetOpenFileName(&openFileNameStruct))
				ccode = S_DLG_OK;
		}
		else if (GetSaveFileName(&openFileNameStruct))
			ccode = S_DLG_OK;

		if (ccode == S_DLG_OK)
		{
			strcpy(directory, winFile);
			directory[openFileNameStruct.nFileOffset] = 0;
			strcpy(file, winFileTitle);
		}

	}
#endif

	return ccode;
}

ZafEventType ZafFileDialog::Event(const ZafEventStruct &event)
{
	return ZafDialogWindow::Event(event);
}

OSWindowID ZafFileDialog::OSScreenID(ZafScreenIDType) const
{
	return 0;
}

void ZafFileDialog::OSRegisterObject(void)
{
}

void ZafFileDialog::OSSize(void)
{
}
