//	Zinc Application Framework - M_EVTMGR.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_evtmgr.hpp>
#include "w_app.hpp"

// ----- ZAF_EVENT_STRUCT_MANAGER ---------------------------------------------------

int ZafEventManager::Get(ZafEventStruct &event, ZafQFlags flags)
{
	int error = 0;
	bool finished = false;
	while (!finished && !error)
	{
		// Allow devices (and Windows) to place events in the Zinc queue.
		if (PollDevices(flags))
		{
			// Get a Windows message.
			// Block (wait for a windows message) only if queue is empty
			// and the Q_NO_BLOCK flag is not set.
			MSG msg;
			if ((Blocked(flags) && !queueBlock.First()) ||
				(!queueBlock.Full() && PeekMessage(&msg, 0, 0, 0, PM_NOREMOVE)))
			{
				// Get a Windows message and place it in the Zinc event queue.
				GetMessage(&msg, 0, 0, 0);
				Put(ZafEventStruct(E_MSWINDOWS, &msg));
			}

			// Poll all devices for events.
			for (ZafDevice *device = First(); device; device = device->Next())
				device->Poll();
		}

		// Get the event off of the Zinc queue.
		ZafQueueElement *element = ReadFromEnd(flags) ? queueBlock.Last() :
			queueBlock.First();
		if (element)
		{
			// Copy the event.
			event = element->event;

			// Remove the event from the queue.
			if (DestroyEvent(flags))
				queueBlock.Subtract((ZafElement *)element);

			finished = true;	// Processing is finished.
		}
		else if (!Blocked(flags))
			error = -2;			// No events were in the queue.
	};

	// Return the error status.
	return (error);
}
