//	Zinc Application Framework - W_DLGWIN.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "w_app.hpp"
#include <z_dlgwin.hpp>

// ----- ZafDialogWindow --------------------------------------------------

void ZafDialogWindow::OSRegisterObject(void)
{
	// Find decorations and set style bits accordingly.
	DWORD dwFrameStyle = WS_CLIPSIBLINGS | WS_CLIPCHILDREN;
	DWORD dwClientStyle = WS_VISIBLE | WS_CHILD;
	for (ZafWindowObject *object = SupportFirst(); object; object = object->Next())
	{
		if (object->SystemObject())
			;
		else if (object->NumberID() == ZAF_NUMID_BORDER)
			dwFrameStyle |= WS_DLGFRAME;
		else if (object->NumberID() == ZAF_NUMID_MAXIMIZE)
			dwFrameStyle |= WS_MAXIMIZEBOX;
		else if (object->NumberID() == ZAF_NUMID_MINIMIZE)
			dwFrameStyle |= WS_MINIMIZEBOX;
		else if (object->NumberID() == ZAF_NUMID_TITLE)
			dwFrameStyle |= WS_CAPTION;
		else if (object->NumberID() == ZAF_NUMID_HZ_SCROLL)
			dwClientStyle |= WS_HSCROLL;
		else if (object->NumberID() == ZAF_NUMID_VT_SCROLL)
			dwClientStyle |= WS_VSCROLL;
		else if (object->NumberID() == ZAF_NUMID_SYSTEM)
			dwFrameStyle |= WS_SYSMENU;
	}

	if (Bordered() && !(dwFrameStyle & WS_DLGFRAME))
		dwFrameStyle |= WS_BORDER;

	if (!parent && !(dwFrameStyle & WS_CAPTION))
		dwFrameStyle |= WS_POPUP;

	if (visible)
		dwFrameStyle |= WS_VISIBLE; 
	if (parent)
		dwFrameStyle |= WS_CHILD;

	// Create the dialog.
	OSWindowID frameID = ZafMSWindowsApp::CreateSubclassedWindow(this, (ZafIChar *)WC_DIALOG, dwFrameStyle, ZAF_NULLP(ZafIChar), 0, WS_EX_DLGMODALFRAME);

	// Re-direct the dialog's "window procedure."
	SetWindowLong(frameID, GWL_WNDPROC, (LONG)ZafMSWindowsApp::FrameJumpProc);

	// Create the client window.
	screenID = ZafMSWindowsApp::CreateSubclassedWindow(this, NULL, dwClientStyle, ZAF_NULLP(ZafIChar), frameID);
}
