# Zinc Application Framework 5.0 convert makefile
# Uses Watcom C/C++ 10.6 and 11.0 with Watcom WMAKE.EXE (excluding QNX)
#
# Builds Zinc convert utility for 32 bit DOS (using DOS4GW), Windows 16,
#  Windows 32, OS2, DESQview/X (using Motif toolkit), QNX (Motif).
#    wmake -f watcom.mak dos32
#    wmake -f watcom.mak win16
#    wmake -f watcom.mak win32
#    wmake -f watcom.mak os2
#    wmake -f watcom.mak dvx
#    make -f watcom.mak qnx
#
# Be sure to set the LIB and INCLUDE environment variables for Zinc, e.g.:
# DOS 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# WIN 16:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\WIN;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB286\WIN;C:\WATCOM\LIB286;C:\ZINC\LIB\WCCPP
# WIN 32:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\NT;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\NT;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# OS/2:
#    set INCLUDE=.;C:\WATCOM\H;C:\WATCOM\H\OS2;C:\ZINC\INCLUDE
#    set LIB=.;C:\WATCOM\LIB386\OS2;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
# DESQView/X:
#    set INCLUDE=.;C:\DVX\INCLUDE;C:\WATCOM\H;C:\ZINC\INCLUDE
#    set LIB=.;C:\DVX\LIB\C386;C:\WATCOM\LIB386\DOS;C:\WATCOM\LIB386;C:\ZINC\LIB\WCCPP
#
# ----- General Definitions -------------------------------------------------
VERSION=watcom

ZAF_ROOT=..\..

!include $(ZAF_ROOT)\include\optswat.mak

# ----- Usage ---------------------------------------------------------------
usage: .SYMBOLIC
	@echo This makefile supports Watcom 10.6 and 11.0
	@echo ...........
	@echo ...........
	@echo To generate the library modules for specific environments type:
	@echo wmake -f watcom.mak dos32
	@echo wmake -f watcom.mak win16
	@echo wmake -f watcom.mak win32
	@echo wmake -f watcom.mak os2
	@echo wmake -f watcom.mak dvx
	@echo make -f watcom.mak qnx
	@echo ...........
	@echo ...........

# ----- Clean ---------------------------------------------------------------
clean: .SYMBOLIC
	z_clean

# ----- DOS 32 bit (DOS4GW extender) Convert --------------------------------
# This is pending.

# ----- Windows 16 bit Convert ----------------------------------------------
win16: wcnvrt16.exe

WIN_OBJS_PRG=convert.ob1,convert1.ob1,convert2.ob1,convert3.ob1,convert4.ob1 &
	,convert5.ob1,c_store.ob1,c_store1.ob1,c_storer.ob1,c_direct.ob1 &
	,c_file.ob1,c_file1.ob1,c_path.ob1

wcnvrt16.exe: convert.ob1 convert1.ob1 convert2.ob1 convert3.ob1 convert4.ob1 convert5.ob1 &
	c_store.ob1 c_store1.ob1 c_storer.ob1 c_direct.ob1 c_file.ob1 c_file1.ob1 c_path.ob1
	%write win_zaf.rsp $(WIN_LINK_OPTS) N wcnvrt16 &
	F $(WIN_OBJS_PRG) L $(WIN_LIBS)
	$(WIN_LINK) @win_zaf.rsp
  	del win_zaf.rsp

# ----- Windows 32 bit Convert ----------------------------------------------
win32: wcnvrt32.exe

W32_OBJS_PRG=convert.obw,convert1.obw,convert2.obw,convert3.obw,convert4.obw &
	,convert5.obw,c_store.obw,c_store1.obw,c_storer.obw,c_direct.obw &
	,c_file.obw,c_file1.obw,c_path.obw

wcnvrt32.exe: convert.obw convert1.obw convert2.obw convert3.obw convert4.obw convert5.obw &
	c_store.obw c_store1.obw c_storer.obw c_direct.obw c_file.obw c_file1.obw c_path.obw
	%write w32_zaf.rsp $(W32_LINK_OPTS) N wcnvrt32 &
	F $(W32_OBJS_PRG) L $(W32_LIBS)
	$(W32_LINK) @w32_zaf.rsp
  	del w32_zaf.rsp

# ----- Windows 32 bit dll Convert ------------------------------------------
win32dll: wconvert.exe

W32_DLL_OBJS_PRG=convert.obi,convert1.obi,convert2.obi,convert3.obi,convert4.obi &
	,convert5.obi,c_store.obi,c_store1.obi,c_storer.obi,c_direct.obi &
	,c_file.obi,c_file1.obi,c_path.obi

wconvert.exe: convert.obi convert1.obi convert2.obi convert3.obi convert4.obi convert5.obi &
	c_store.obi c_store1.obi c_storer.obi c_direct.obi c_file.obi c_file1.obi c_path.obi
	%write w32_zaf.rsp $(W32_DLL_IMPORT_LINK_OPTS) N wconvert &
	F $(W32_DLL_OBJS_PRG) L $(W32_DLL_IMPORT_LIBS)
	$(W32_LINK) @w32_zaf.rsp
  	del w32_zaf.rsp

# ----- OS/2 Convert --------------------------------------------------------
# This is pending.

# ----- DESQview/X Convert --------------------------------------------------
dvx: mconvert.exe

DVX_OBJS1=convert.obm,convert1.obm,convert2.obm,convert3.obm,convert4.obm,convert5.obm
DVX_OBJS2=c_store.obm,c_store1.obm,c_storer.obm,c_direct.obm,c_file.obm,c_file1.obm,c_path.obm

mconvert.exe: convert.obm convert1.obm convert2.obm convert3.obm convert4.obm convert5.obm &
	c_store.obm c_store1.obm c_storer.obm c_direct.obm c_file.obm c_file1.obm c_path.obm
	%create dvx_zaf.rsp
	@%append dvx_zaf.rsp $(DVX_LINK_OPTS)
	@%append dvx_zaf.rsp N mconvert
	@%append dvx_zaf.rsp F $(DVX_OBJS1),$(DVX_OBJS2)
	@%append dvx_zaf.rsp L $(DVX_LIBS)
	$(DVX_LINK) @dvx_zaf.rsp
  	del dvx_zaf.rsp

# ----- QNX Motif Convert ---------------------------------------------------
qnx: mconvert

QNX_OBJS= convert.o convert1.o convert2.o convert3.o convert4.o convert5.o \
	c_store.o c_store1.o c_storer.o c_direct.o c_file.o c_file1.o c_path.o

mconvert: $(QNX_OBJS)
	$(QNX_LINK) $(QNX_LINK_OPTS) -o $@ $(QNX_OBJS) $(QNX_LIB_DIRS) $(QNX_LIBS)

qclean:
	rm -f *.o core mconvert

