//	Zinc Application Framework - C_STORER.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(C_STORER_HPP)
#	define C_STORER_HPP
#	include "c_store.hpp"
#	include <z_objid.hpp>
#	include <z_lang.hpp>
#	include <z_cset.hpp>
#	include "c_path.hpp"

// ----- Private class definition. Do not use! ------------------------------
struct ZafSignature
{
	char copyrightNotice[64];
  	ZafUInt8 majorVersion;
	ZafUInt8 minorVersion;
	ZafUInt16 magicNumber;
};

// ----- Private class definition. Do not use! ------------------------------
struct ZafInode
{
	// Note: fragments are currently unsupported
	ZafInt32 size; // size of the object
	ZafUInt32 createTime; // create time of the object
	ZafUInt32 modifyTime; // last modify time of the object
	ZafDiskAddress direct[21]; // pointers to the first 21 blocks of object
	ZafDiskAddress sIndirect; // pointer to a block of 128? pointers to blocks of object
	ZafDiskAddress dIndirect; // pointer to a block of 128? pointers to blocks of 128? pointers to blocks of object
	ZafDiskAddress fragmentBlock; // this is used as a free list pointer
	ZafUInt16 useCount; // if this is 0 then this inode is unused
	ZafUInt16 fragmentIndex; // this is also used as the free list
};

// ----- Private class definition. Do not use! ------------------------------
struct ZafCacheData
{
	ZafUInt16 pos; // position of data buffer
	ZafDiskAddress blknum; // absolute block number on disk
	ZafUInt8 dirty; // 1 if block needs to be written
	ZafUInt8 used; // 1 if this block is being used
};
	
// ----- Private class definition. Do not use! ------------------------------
struct ZafOpenObject
{
	int openCount; // number of times the file is open
	bool modified; // if the modifyTime needs updating
	ZafINodeNumber inum; // inode number
	struct ZafInode inode; // inode of this file
	ZafUInt16 revision;
	ZafUInt16 country;
};

// ----- Private class definition. Do not use! ------------------------------
struct OldDirectoryEntry
{
	ZafINodeNumber inum; // inode number
	ZafClassID classID;
	ZafUInt16 revision;
	ZafUInt16 country;
	ZafIChar stringID[ZAF_MAXNAMELEN];
};

// ----- Private class definition. Do not use! ------------------------------
struct ZafSuperBlock
{
	ZafSignature signature;
	ZafUInt32 createTime; // create time for file
	ZafUInt32 modifyTime; // last modify time for file
//	ZafUInt32 unused;
	ZafUInt16 blockSize;
	ZafUInt16 indirectBlockSize;
	ZafUInt16 freeInodeListHi; // upper half of free inode list
	ZafUInt16 revision;
	ZafUInt16 freeInodeListLo; // lower half of free inode list
	ZafDiskAddress freeDataList;
	ZafDiskAddress inodeDirect[82]; // 82 pointers to inode blocks
	ZafDiskAddress inodeSIndirect; // pointer to block of 128? pointers to inode blocks
	ZafDiskAddress inodeDIndirect; // pointer to block of 128? pointers to blocks of 128? pointers to inode blocks
};

// ----- Private definitions. Do not use! -----------------------------------
const int NEW_INC = 5;
const int BYTES_PER_INODE_BLOCK_4X = 1024;
const int INODES_PER_INODE_BLOCK_4X = (BYTES_PER_INODE_BLOCK_4X / sizeof(struct ZafInode));
const int DISK_ADDR_PER_INODE_BLOCK_4X = (BYTES_PER_INODE_BLOCK_4X / sizeof(ZafDiskAddress));
const int INODE_INDIRECT_SIZE_4X = (DISK_ADDR_PER_INODE_BLOCK_4X*sizeof(ZafDiskAddress));

// ----- For versioin 5.0 and later -----------------------------------------
const int INODE_INDIRECT_SIZE = 256;

#if !defined(_SUNOS4)
#	define BUFFTYPE		void
#else
#	define BUFFTYPE		char
#endif
#define	NAMETYPE
#define LENGTHOF(x)	(sizeof(x)/sizeof((x)[0]))
#define SET_FRAGMENT_WITH_INUM(index, block, inum) \
		(index) = (ZafUInt16)((inum) & 0xFFFF), \
		(block) = (ZafUInt16)(((inum) >> 16) & 0xFFFF);
#define SET_INUM_WITH_FRAGMENT(inum, index, block) \
		(inum) = ((ZafINodeNumber)(block) << 16) | (index);

#if defined(ZAF_BIGENDIAN)
	extern void SwapDiskAddr(ZafDiskAddress *datum);
	extern void SwapUZAF_INT16(ZafUInt16 *datum);
	extern void SwapInumt(ZafINodeNumber *datum);
	extern void SwapInode(ZafInode *di);
	extern void SwapSuperBlock(ZafSuperBlock *ds);
#else
#	define SwapDiskAddr(x)
#	define SwapUZAF_INT16(x)
#	define SwapInumt(x)
#	define SwapInode(x)
#	define SwapSuperBlock(x)
#endif

#define CheckStorageError(x)	if (error != 0) return x;
#define CheckStorageErrorNull()	if (error != 0) return;
#define CheckObjectError(x)	if (error != 0) return x;
#define CheckObjectErrorNull()	if (error != 0) return;
		
// --------------------------------------------------------------------------
// ----- ZafStatsStruct -----------------------------------------------------
// --------------------------------------------------------------------------

struct ZafStatsStruct
{
	ZafInt32 size;
	ZafInt32 createTime;
	ZafInt32 modifyTime;
	ZafUInt16 useCount;
	ZafUInt16 revision;
	ZafUInt16 countryID;
	ZafINodeNumber inum;

	bool Directory(void) const { return ((useCount & ZAF_DIRECTORY_TAG) ? true : false); }
};

// --------------------------------------------------------------------------
// ----- OldStorageReadOnly -------------------------------------------------
// --------------------------------------------------------------------------

class OldStorageObjectReadOnly;
class OldStorageDirectory;

class OldStorageReadOnly : public OldDirectory
{
public:
	// --- General members ---
	static int cacheSize;
	static ZafPath *searchPath;
	static ZafIChar *bakName;

	OldStorageReadOnly(void);
	OldStorageReadOnly(const ZafIChar *name);
	virtual ~OldStorageReadOnly(void);
	virtual OldFile *AllocateFile(const ZafIChar *pathName,
		const ZafClassName className = 0, ZafClassID classID = 0);
	ZafUInt16 BlockSize();
	virtual int ChDir(const ZafIChar *pathName);
	OldStorageObjectReadOnly *CurrentDirectory(void) { return (currentDirectory); }
	virtual void FreeFile(OldFile *file);
	long GetBlockPos(ZafDiskAddress blknum); 
	virtual int GetCWD(ZafIChar *pathName, int pathLength);
	ZafUInt16 IndirectBlockSize();
	virtual int MkDir(const ZafIChar *pathName,
		const ZafClassName className = 0, ZafClassID classID = 0);
	OldStorageDirectory *OpenDir(const ZafIChar *name);
	ZafStatsStruct *Stats(void);

	virtual ZafIChar *FindFirst(const ZafIChar *searchName, ZafClassID *searchID = ZAF_NULLP(ZafClassID));
	virtual ZafIChar *FindFirst(ZafClassID searchID);
	virtual ZafIChar *FindNext(ZafClassID *searchID = ZAF_NULLP(ZafClassID));

	void StorageName(ZafIChar *buff) { AppendFullPath(buff, pname, fname); }
	static void AppendFullPath(ZafIChar *fullPath,
		const ZafIChar *pathName = ZAF_NULLP(ZafIChar),
		const ZafIChar *fileName = ZAF_NULLP(ZafIChar),
		const ZafIChar *extension = ZAF_NULLP(ZafIChar));
	static void ChangeExtension(ZafIChar *name, const ZafIChar *newExtension);
	static void StripFullPath(const ZafIChar *fullPath,
		ZafIChar *pathName = ZAF_NULLP(ZafIChar),
		ZafIChar *fileName = ZAF_NULLP(ZafIChar),
		ZafIChar *objectName = ZAF_NULLP(ZafIChar),
		ZafIChar *objectPathName = ZAF_NULLP(ZafIChar));
	static void TempName(ZafIChar *tempname);
	static bool ValidName(const ZafIChar *name, bool createStorage = false);

#	if defined(ZAF_MACINTOSH)
	static OSType fileCreator;
	static OSType fileType;
#	endif

protected:
	friend class OldStorageObject;
	friend class OldStorageObjectReadOnly;
	friend class OldStorageSupport;

	int openLen;
	ZafOpenObject *openObjects;
	OldStorageObjectReadOnly *currentDirectory;
#if defined(ZAF_MACINTOSH)
	short fd;
#else
	FILE *fd;
#endif
	ZafIChar pname[ZAF_MAXPATHLEN + 1];
	ZafIChar fname[ZAF_MAXPATHLEN + 1];
	bool modified; // Unused in RO part
	ZafSuperBlock *sb;
	int cacheLen;
	ZafCacheData *cd;
	char *cache;

	virtual ZafDiskAddress AllocData(void);
	virtual ZafDiskAddress AppendInode(ZafINodeNumber inum);
	void ChDirRoot(void);
	int CheckOpen(ZafINodeNumber inum);
	long FindInode(ZafINodeNumber inum);
	int FindSlot(void);
	bool InMemory(ZafDiskAddress blknum);
	static void MakeFullPath(ZafIChar *tmppath);
	bool SearchPath(ZafIChar *tmp);
	int ReadAt(long pos, void *buf, int len);
	void *ReadData(ZafDiskAddress blknum);
	virtual int RWInode(ZafINodeNumber inum, ZafInode *ientry, int direction);
	void SetUpLocalData(void);
	void ValidateZincFile(void);
	void WalkPartialPath(const ZafIChar *pathname,
		OldStorageObjectReadOnly **parentdir,
		const ZafIChar **filename);
	OldStorageObjectReadOnly *WalkPath(const ZafIChar *name,
		bool stripLast);
	virtual int WriteAt(long pos, void *buf, int len);
	void WriteData(void *data, bool modified);
};

// --------------------------------------------------------------------------
// ----- OldStorageObjectReadOnly -------------------------------------------
// --------------------------------------------------------------------------

class OldStorageObjectReadOnly : public ZafBufferObject
{
	friend class OldStorageDirectory;
public:
	// --- General members ---
	ZafClassID classID;
	ZafIChar *stringID;

	OldStorageObjectReadOnly(void);
	OldStorageObjectReadOnly(OldStorageReadOnly &file, const ZafIChar *name, ZafClassID classID);
	virtual ~OldStorageObjectReadOnly(void);
	ZafStatsStruct *Stats(void);
	OldStorageReadOnly *Storage(void) { return (file); }

	// --- Read functions ---
	virtual int Read(ZafInt8 &value) { return (ZafBufferObject::Read(value)); }
	virtual int Read(ZafUInt8 &value) { return (ZafBufferObject::Read(value)); }
	virtual int Read(ZafInt16 &value) { return (ZafBufferObject::Read(value)); }
	virtual int Read(ZafUInt16 &value) { return (ZafBufferObject::Read(value)); }
#if (ZAF_WORD_SIZE != 64)
	virtual int Read(int &value) { return (ZafBufferObject::Read(value)); }
#endif
	virtual int Read(ZafInt32 &value) { return (ZafBufferObject::Read(value)); }
	virtual int Read(ZafUInt32 &value) { return (ZafBufferObject::Read(value)); }
	virtual int Read(double &value) { return (ZafBufferObject::Read(value)); }
	virtual int Read(ZafIChar *text, int textLength) { return (ZafBufferObject::Read(text, textLength)); }
	virtual int Read(ZafIChar **text) { return (ZafBufferObject::Read(text)); }
	virtual int Read(void *readBuffer, int readSize, int readLength)
		{ return (ZafBufferObject::Read(readBuffer, readSize, readLength)); }
	// special read function.
	virtual int Read(OldDirectoryEntry *dirent);

	// --- Write functions ---
	virtual int Write(ZafInt8 value) { return (ZafBufferObject::Write(value)); }
	virtual int Write(ZafUInt8 value) { return (ZafBufferObject::Write(value)); }
	virtual int Write(ZafInt16 value) { return (ZafBufferObject::Write(value)); }
	virtual int Write(ZafUInt16 value) { return (ZafBufferObject::Write(value)); }
#if (ZAF_WORD_SIZE != 64)
	virtual int Write(int value) { return (ZafBufferObject::Write(value)); }
#endif
	virtual int Write(ZafInt32 value) { return (ZafBufferObject::Write(value)); }
	virtual int Write(ZafUInt32 value) { return (ZafBufferObject::Write(value)); }
	virtual int Write(double value) { return (ZafBufferObject::Write(value)); }
	virtual int Write(const ZafIChar *text) { return (ZafBufferObject::Write(text)); }
	virtual int Write(void *writeBuffer, int writeSize, int writeLength)
		{ return (ZafBufferObject::Write(writeBuffer, writeSize, writeLength)); }
	// special write function.
	virtual int Write(const OldDirectoryEntry *dirent);

protected:
	friend class OldStorage;
	friend class OldStorageObject;
	friend class OldStorageReadOnly;

	OldStorageReadOnly *file;
	int inodeIndex;
	ZafDiskAddress *cachedBlknum;
	ZafDiskAddress *cachedBlkptr;

	ZafOpenObject *CheckObject(void);
	bool FindName(const ZafIChar *name);
	ZafDiskAddress GetBlockPtr(ZafDiskAddress blknum);
	void OpenTheObject(OldStorageReadOnly &pfile, OldDirectoryEntry *dentry,
		ZafInode *ientry, bool truncate);
	void ReadObjectData(ZafInode *ientry);
};

// --------------------------------------------------------------------------
// ----- OldStorageDirectory ------------------------------------------------
// --------------------------------------------------------------------------

class OldStorageDirectory
{
	friend class OldStorageReadOnly;
public:
	// --- General members ---
	virtual ~OldStorageDirectory(void);
	OldDirectoryEntry *ReadDir(void);
	void RewindDir(void);
	void SeekDir(ZafUInt16 _position) { position = _position; }
	ZafUInt16 TellDir(void) { return (position); }

private:
	OldStorageDirectory(OldStorageObjectReadOnly *_directory);
	void PartialConstruct(OldStorageObjectReadOnly *_directory);
	OldDirectoryEntry current;
	ZafUInt8 *directoryBuffer;
	ZafUInt16 position;
	ZafUInt16 size;
	OldStorageObjectReadOnly *directory;
};

#endif // C_STORER_HPP

