//	Zinc Application Framework - C_DIRECT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(C_DIRECT_HPP)
#	define C_DIRECT_HPP
#	include "c_file.hpp"

// --------------------------------------------------------------------------
// ----- OldDirectory -------------------------------------------------------
// --------------------------------------------------------------------------

class OldDirectory
{
public:
	static ZafIChar *rootDirectoryName;
	static ZafIChar *parentDirectoryName;
	static ZafIChar *currentDirectoryName;

	// --- General members ---
	OldDirectory(const ZafIChar *pathName, ZafFileMode mode);
	virtual ~OldDirectory(void);
	virtual OldFile *AllocateFile(const ZafIChar *pathName,
		const ZafClassName className = 0, ZafClassID classID = 0);
	virtual int ChDir(const ZafIChar *newPath);
	virtual ZafIChar *FindFirst(const ZafIChar *searchName, ZafClassID *searchID = ZAF_NULLP(ZafClassID));
	virtual ZafIChar *FindFirst(ZafClassID searchID);
	virtual ZafIChar *FindNext(ZafClassID *searchID = ZAF_NULLP(ZafClassID));
	virtual void FreeFile(OldFile *file);
	virtual int GetCWD(ZafIChar *pathName, int pathLength);
	virtual int MkDir(const ZafIChar *pathName,
		const ZafClassName className = 0, ZafClassID classID = 0);

	// --- Attributes & data access ---
	// get
	bool BinaryMode(void) const;
	bool Copy(void) const;
	bool Create(void) const;
	ZafError Error(void) const;
	bool OpenCreate(void) const;
	bool ReadOnly(void) const;
	bool ReadWrite(void) const;
	bool Temporary(void) const;
	bool TextMode(void) const;
	ZafVersion Version(void) const;
	// set
	virtual ZafError SetError(ZafError error);
	virtual ZafVersion SetVersion(ZafVersion version);

protected:
	// --- General class members ---
	ZafError error;
	ZafFileMode mode;
	ZafVersion version;

	ZafIChar *pathName;
};

// --- inline functions ---
inline bool OldDirectory::BinaryMode(void) const { return (mode & ZAF_FILE_BINARY); }
inline bool OldDirectory::Copy(void) const { return (mode & ZAF_FILE_COPY); }
inline bool OldDirectory::Create(void) const { return (mode & ZAF_FILE_CREATE); }
inline ZafError OldDirectory::Error(void) const { return (error); }
inline bool OldDirectory::OpenCreate(void) const { return (mode & ZAF_FILE_OPENCREATE); }
inline bool OldDirectory::ReadOnly(void) const { return (mode & ZAF_FILE_READ); }
inline bool OldDirectory::ReadWrite(void) const { return (mode & ZAF_FILE_READWRITE); }
inline bool OldDirectory::Temporary(void) const { return (mode & ZAF_FILE_TEMPORARY); }
inline bool OldDirectory::TextMode(void) const { return (mode & ZAF_FILE_TEXT); }
inline ZafVersion OldDirectory::Version(void) const { return (version); }

#endif // ZAF_DIRECT_HPP


