//	Zinc Application Framework - C_DIRECT.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include "c_direct.hpp"
#include <z_unistd.hpp>
#include <z_utils.hpp>

// ----- OldDirectory -------------------------------------------------------

ZafIChar *OldDirectory::rootDirectoryName = ZAF_ITEXT("~");
ZafIChar *OldDirectory::parentDirectoryName = ZAF_ITEXT("..");
ZafIChar *OldDirectory::currentDirectoryName = ZAF_ITEXT(".");

OldDirectory::OldDirectory(const ZafIChar *tPathName, ZafFileMode zMode) :
	error(ZAF_ERROR_NONE), mode(zMode), version(0)
{
	// Set the pathname.
	pathName = tPathName ? strdup(tPathName) : ZAF_NULLP(ZafIChar);
}

OldDirectory::~OldDirectory(void)
{
	// Delete the pathname.
	if (pathName)
		delete []pathName;
}

int OldDirectory::ChDir(const ZafIChar *newPath)
{
	// Move to the new directory.
	return (chdir(newPath));
}

OldFile *OldDirectory::AllocateFile(const ZafIChar *name, const ZafClassName, ZafClassID)
{
	// Return a pointer to the current file.
	return (new OldFile(name, mode));
}

ZafIChar *OldDirectory::FindFirst(const ZafIChar *, ZafClassID *)
{
	return (ZAF_NULLP(ZafIChar));
}

ZafIChar *OldDirectory::FindFirst(ZafClassID)
{
	return (ZAF_NULLP(ZafIChar));
}

ZafIChar *OldDirectory::FindNext(ZafClassID *)
{
	return (ZAF_NULLP(ZafIChar));
}

int OldDirectory::GetCWD(ZafIChar *pathName, int pathLength)
{
	// Get the current working directory.
	return (getcwd(pathName, pathLength) ? 0 : -1);
}

int OldDirectory::MkDir(const ZafIChar *pathName, const ZafClassName, ZafClassID)
{
#if defined(ZAF_POSIX)
	return (mkdir(pathName, 0666));
#elif defined(ZAF_MACINTOSH)
	// Not implemented.
	return (-1);
#else
	return (mkdir(pathName));
#endif
}

void OldDirectory::FreeFile(OldFile *file)
{
	// Delete the file.
	if (file)
		delete file;
}

ZafError OldDirectory::SetError(ZafError newError)
{
	// Reset the error.
	error = newError;
	return (error);
}

ZafVersion OldDirectory::SetVersion(ZafVersion newVersion)
{
	// Reset the version number.
	version = newVersion;
	return (version);
}

