//	Zinc Application Framework - CONVERT1.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#define OSBignum ZafConvertWindow
#define OSBorder ZafConvertWindow
#define OSButton ZafConvertWindow
#define OSComboBox ZafConvertWindow
#define OSDate ZafConvertWindow
#define OSFormattedString ZafConvertWindow
#define OSGroup ZafConvertWindow
#define OSHzList ZafConvertWindow
#define OSIcon ZafConvertWindow
#define OSInteger ZafConvertWindow
#define OSMaximizeButton ZafConvertWindow
#define OSMinimizeButton ZafConvertWindow
#define OSNotebook ZafConvertWindow
#define OSPopUpMenu ZafConvertWindow
#define OSPopUpItem ZafConvertWindow
#define OSPrompt ZafConvertWindow
#define OSPullDownMenu ZafConvertWindow
#define OSPullDownItem ZafConvertWindow
#define OSReal ZafConvertWindow
#define OSScrollBar ZafConvertWindow
#define OSSpinControl ZafConvertWindow
#define OSStatusBar ZafConvertWindow
#define OSString ZafConvertWindow
#define OSSystemButton ZafConvertWindow
#define OSText ZafConvertWindow
#define OSTable ZafConvertWindow
#define OSTableRecord ZafConvertWindow
#define OSTableHeader ZafConvertWindow
#define OSTime ZafConvertWindow
#define OSTitle ZafConvertWindow
#define OSToolBar ZafConvertWindow
#define OSVtList ZafConvertWindow
#define OSWindow ZafConvertWindow
#define OSWindowObject ZafConvertWindow

#include <z_stdlib.hpp>
#include <z_appall.hpp>
#include "c_storer.hpp"

#include "convert.hpp"
#include "convert1.hpp"
#include <z_winall.hpp>
#include <z_string.hpp>
#include <z_utils.hpp>

// Static members of ZafConvertWindow used to determine information about 
// derived Window classes.
bool ZafConvertWindow::destroyable = false;
ZafMDIType ZafConvertWindow::mdiType;
int ZafConvertWindow::scrollWidth;
int ZafConvertWindow::scrollHeight;
DerivedWindowType ZafConvertWindow::derivedWindowType;
ZafList ZafConvertWindow::helpList;

static ZafIChar *deriveName = ZAF_ITEXT("~DERIVE_TABLE");
static ZafClassID IdDerivedStart = 3500;

// ----- ZafConvertWindow ---------------------------------------------------

ZafConvertWindow::ZafConvertWindow(const ZafIChar *name, OldDirectory *directory,
	ZafObjectPersistence *persist) :
	ZafWindow(0, 0, 0, 0)
{
	// Create the read object.
	directory->ChDir("~UIW_WINDOW");
	OldFile *file = directory->AllocateFile(name);
	SetStringID(name);

	ZafInt32 value1, value2, value3, value4;
	*file >> value1 >> value2 >> value3 >> value4;
	if (zafDisplay)
	{
		int miniNumeratorX = (int)zafDisplay->miniNumeratorX;
		int miniDenominatorX = (int)zafDisplay->miniDenominatorX;
		int miniNumeratorY = (int)zafDisplay->miniNumeratorY;
		int miniDenominatorY = (int)zafDisplay->miniDenominatorY;

		zafDisplay->miniNumeratorX = (int)value1;
		zafDisplay->miniDenominatorX = (int)value2;
		zafDisplay->miniNumeratorY = (int)value3;
		zafDisplay->miniDenominatorY = (int)value4;

		// Initialize the base information.
		Read_WINDOW(this, directory, file, persist);

		zafDisplay->miniNumeratorX = miniNumeratorX;
		zafDisplay->miniDenominatorX = miniDenominatorX;
		zafDisplay->miniNumeratorY = miniNumeratorY;
		zafDisplay->miniDenominatorY = miniDenominatorY;
	}
	else
		Read_WINDOW(this, directory, file, persist);

	// Destroy the read object.
	directory->FreeFile(file);
}

// ----- ZafWindow ---------------------------------------------------------
ZafWindowObject *ZafConvertWindow::ConvertWindow(const ZafIChar *name, OldDirectory *directory,
	ZafObjectPersistence *persist)
{
	// Create the read object.
	directory->ChDir("~UIW_WINDOW");
	OldFile *file = directory->AllocateFile(name);

	ZafWindowObject *returnValue;

	ZafInt32 value1, value2, value3, value4;
	*file >> value1 >> value2 >> value3 >> value4;

	ZafOffset originalOffset = file->Tell();

	int miniNumeratorX;
	int miniDenominatorX;
	int miniNumeratorY;
	int miniDenominatorY;

	if (zafDisplay)
	{
		miniNumeratorX = (int)zafDisplay->miniNumeratorX;
		miniDenominatorX = (int)zafDisplay->miniDenominatorX;
		miniNumeratorY = (int)zafDisplay->miniNumeratorY;
		miniDenominatorY = (int)zafDisplay->miniDenominatorY;

		zafDisplay->miniNumeratorX = (int)value1;
		zafDisplay->miniDenominatorX = (int)value2;
		zafDisplay->miniNumeratorY = (int)value3;
		zafDisplay->miniDenominatorY = (int)value4;

	}

	returnValue = Read_WINDOW(0, directory, file, persist);
	if (!returnValue)
	{
		file->Seek(originalOffset, ZAF_SEEK_START);

		switch (derivedWindowType)
		{
			case MDI:
			{
				mdiType = ZAF_MDI_PARENT;
				returnValue = ReadMDIWindow(0, directory, file, persist);
			}
			break;

			case Dialog:
			{
				returnValue = ReadDialogWindow(0, directory, file, persist);
			}
			break;
		}
	}

	if (zafDisplay)
	{
		zafDisplay->miniNumeratorX = miniNumeratorX;
		zafDisplay->miniDenominatorX = miniDenominatorX;
		zafDisplay->miniNumeratorY = miniNumeratorY;
		zafDisplay->miniDenominatorY = miniDenominatorY;
	}

	// Destroy the read object.
	directory->FreeFile(file);

	// The geometry manager needs the S_INITIALIZE in order to get the pointers.
	returnValue->Event(S_INITIALIZE); 

	return returnValue;
}



// ----- ZafWindow ---------------------------------------------------------

typedef ZafFlags WNF_FLAGS;
const WNF_FLAGS WNF_NO_FLAGS			= 0x0000;
const WNF_FLAGS WNF_NO_WRAP				= 0x0001;
const WNF_FLAGS WNF_SELECT_MULTIPLE		= 0x0002;
const WNF_FLAGS WNF_BITMAP_CHILDREN		= 0x0004;
const WNF_FLAGS WNF_OWNERDRAW_CHILDREN	= 0x0004;
const WNF_FLAGS WNF_AUTO_SORT			= 0x0008;
const WNF_FLAGS WNF_CONTINUE_SELECT		= 0x0010;
const WNF_FLAGS WNF_AUTO_SELECT			= 0x0020;
const WNF_FLAGS WNF_MOVE_FORWARD		= 0x0040;
const WNF_FLAGS WNF_MOVE_REVERSE		= 0x0080;
const WNF_FLAGS WNF_NO_SCROLL			= 0x0100;

ZafWindowObject *ZafConvertWindow::Read_WINDOW(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Create a list of derived object equivalences
	ZafDerivedList deriveList;
	ZafIChar deriveObjectName[64];
	ZafClassID deriveID, baseID;

	OldFile *deriveObject = directory->AllocateFile(deriveName);
	if (deriveObject)
		while (deriveObject->Read(deriveID) && deriveID >= IdDerivedStart)
		{
			*deriveObject >> baseID >> deriveObjectName;
			deriveList.Add(new ZafDerivedElement(deriveID, baseID));
		}
	directory->FreeFile(deriveObject);

	bool destroyable = false;
	ZafOffset originalOffset = file->Tell();
	// Initialize the base information.
	if (!object)
	{
		object = new ZafWindow(0, 0, 0, 0);
		destroyable = true;
	}

	bool saveDestroyable = ZafConvertWindow::destroyable;
	ZafConvertWindow::destroyable = destroyable;
	ZafWindowObject *returnObject = Read_WINDOW_OBJECT(object, directory, file, persist);
	ZafConvertWindow::destroyable = saveDestroyable;

	// Stopped and read another window class instead.
	if (returnObject != object) 
		return returnObject;

	// Convert the window information.
	ZafWindow *window = DynamicPtrCast(object, ZafWindow);

	// Set the clientRegion member of window.
	if (window)
		window->clientRegion = window->zafRegion;

	// child objects
 	ZafInt16 noOfObjects;
	*file >> noOfObjects;

	ZafOffset childOffset;
	ZafWindowObject *addObject;

	for (int i = 0; i < noOfObjects; i++)
	{
		ZafClassID saveID;
		*file >> saveID;
		// Check for a derived object.
		if (saveID < IdDerivedStart)
		{
			for (int j = 0; convert[j].classID != ID_END; j++)
				if (saveID == convert[j].classID)
				{
					childOffset = file->Tell();
					addObject = (convert[j].function)(0, directory, file, persist);
					if (!addObject && saveID == ID_ZAF_WINDOW)
					{
						file->Seek(childOffset, ZAF_SEEK_START);
						mdiType = ZAF_MDI_CHILD;
						addObject = ReadMDIWindow(0, directory, file, persist);
					}
					window->Add(addObject);
					break;
				}
		}
		// Load a derived object if one is in the file.
		else
			for (ZafDerivedElement *derived = deriveList.First(); derived; derived = derived->Next())
				if (saveID == derived->DeriveID())
				{
					for (int j = 0; convertDerived[j].classID != ID_END; j++)
						if (derived->BaseID() == convertDerived[j].classID)
						{
							addObject = (convertDerived[j].function)(derived->DeriveID(), directory, file, persist);
							window->Add(addObject);
							break;
						}
				}
	}
	// window flags.
	WNF_FLAGS wnFlags;
	*file >> wnFlags;
	window->SetSelectionType((wnFlags & WNF_SELECT_MULTIPLE) ? ZAF_MULTIPLE_SELECTION : ZAF_SINGLE_SELECTION);
	window->SetOSDraw((wnFlags & WNF_OWNERDRAW_CHILDREN) ? false : true);
	ZafVtList *vtList;
	ZafHzList *hzList;
	ZafGroup *group;
	ZafComboBox *combobox;
	ZafToolBar *tbar;
	ZafTreeList *tree;
	ZafTreeItem *treeItem;
	if ((vtList = DynamicPtrCast(object, ZafVtList)) != ZAF_NULLP(ZafVtList))
		vtList->SetAutoSortData((wnFlags & WNF_AUTO_SORT) ? true : false);
	else if ((hzList = DynamicPtrCast(object, ZafHzList)) != ZAF_NULLP(ZafHzList))
		hzList->SetAutoSortData((wnFlags & WNF_AUTO_SORT) ? true : false);
	else if ((group = DynamicPtrCast(object, ZafGroup)) != ZAF_NULLP(ZafGroup))
		group->SetAutoSelect((wnFlags & WNF_AUTO_SELECT) ? true : false);
	else if ((combobox = DynamicPtrCast(object, ZafComboBox)) != ZAF_NULLP(ZafComboBox))
		combobox->SetAutoSortData((wnFlags & WNF_AUTO_SORT) ? true : false);
	else if ((tbar = DynamicPtrCast(object, ZafToolBar)) != ZAF_NULLP(ZafToolBar))
		tbar->SetWrapChildren((wnFlags & WNF_NO_WRAP) ? true : false);
	else if ((tree = DynamicPtrCast(object, ZafTreeList)) != ZAF_NULLP(ZafTreeList))
		tree->SetAutoSortData((wnFlags & WNF_AUTO_SORT) ? true : false);
	else if ((treeItem = DynamicPtrCast(object, ZafTreeItem)) != ZAF_NULLP(ZafTreeItem))
		treeItem->SetAutoSortData((wnFlags & WNF_AUTO_SORT) ? true : false);
	if (!(wnFlags & WNF_NO_SCROLL) && destroyable)
	{
		ZafScrollBar *vScroll = window->VerticalScrollBar();
		ZafScrollBar *hScroll = window->HorizontalScrollBar();
		if (vScroll || hScroll)
		{
			// Calculate the maximum X & Y values.
			long maxX = 0;
			long maxY = 0;
			long temp;
			ZafCoordinateType coordType = object->zafRegion.coordinateType;
			ZafWindowObject *child;
			for (child = window->First();child; child = child->Next())
			{
				ZafRegionStruct region = child->zafRegion;
				temp = child->zafRegion.ConvertXValue(region.right + 1,
					region.coordinateType, coordType);
				if (temp > maxX)
					maxX = temp;
				temp = child->zafRegion.ConvertYValue(region.bottom + 1,
					region.coordinateType, coordType);
				if (temp > maxY)
					maxY = temp;
			}
			ZafConvertWindow::scrollWidth = (int)maxX;
			ZafConvertWindow::scrollHeight = (int)maxY;
			file->Seek(originalOffset, ZAF_SEEK_START);
			delete object;
			object = ReadScrolledWindow(0, directory, file, persist);
			return object;
		}
	}

	ZafIChar *compareFunctionName;
	*file >> &compareFunctionName;
	if (compareFunctionName)
	{
		if (persist)
			window->compareFunction = persist->GetCompareFunction(compareFunctionName);
		delete []compareFunctionName;
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafGeometryManager -----------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_GEOMETRY_MANAGER(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafGeometryManager();

	Read_WINDOW_OBJECT(object, directory, file, persist);

	ZafGeometryManager *geometry = DynamicPtrCast(object, ZafGeometryManager);
	// child objects
 	ZafInt16 noOfObjects;
	*file >> noOfObjects;

	ZafConstraint *constraint;
	for (int i = 0; i < noOfObjects; i++)
	{
		ZafClassID saveID;
		*file >> saveID;
		for (int j = 0; convertGeometry[j].classID != ID_END; j++)
			if (saveID == convertGeometry[j].classID)
			{
				constraint = (convertGeometry[j].function)(0, directory, file, persist);
				geometry->Add(constraint);
				break;
			}
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafAttachment ----------------------------------------------------

ZafConstraint *ZafConvertWindow::Read_ATTACHMENT(
	ZafConstraint *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafAttachment(ZAF_NULLP(ZafWindowObject), ZAF_ATCF_LEFT);

	Read_CONSTRAINT(object, directory, file, persist);

	ZafAttachment *attach = DynamicPtrCast(object, ZafAttachment);

	ZafNumberID tNumberID;
	ZafUInt16 value;
	ZafInt16 tOffset;

	*file>>tNumberID>>value>>tOffset;

	if (value & 0x0001)
		attach->SetType(ZAF_ATCF_LEFT);
	else if (value & 0x0002)
		attach->SetType(ZAF_ATCF_TOP);
	else if (value & 0x0004)
		attach->SetType(ZAF_ATCF_RIGHT);
	else if (value & 0x0008)
		attach->SetType(ZAF_ATCF_BOTTOM);

	attach->SetOppositeSide(value & 0x0010 ? true : false);
	attach->SetStretch(value & 0x0020 ? true : false);

	int offset = tOffset;
	attach->SetOffset(offset);
	attach->SetReferenceNumberID(tNumberID);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafRelativeConstraint ----------------------------------------------------

ZafConstraint *ZafConvertWindow::Read_RELATIVE_CONSTRAINT(
	ZafConstraint *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafRelativeConstraint(ZAF_NULLP(ZafWindowObject), ZAF_RLCF_LEFT);

	Read_CONSTRAINT(object, directory, file, persist);

	ZafRelativeConstraint *constraint = DynamicPtrCast(object, ZafRelativeConstraint);

	ZafUInt16 value;
	ZafInt16 numerator;
	ZafInt16 denominator;
	ZafInt16 offset;

	*file>>value>>numerator>>denominator>>offset;

	if (value & 0x0001)
		constraint->SetType(ZAF_RLCF_LEFT);
	else if (value & 0x0002)
		constraint->SetType(ZAF_RLCF_TOP);
	else if (value & 0x0004)
		constraint->SetType(ZAF_RLCF_RIGHT);
	else if (value & 0x0008)
		constraint->SetType(ZAF_RLCF_BOTTOM);

	constraint->SetOppositeSide((value & 0x0010) ? true : false);
	constraint->SetStretch((value & 0x0020) ? true : false);

	if (value & 0x0100 && (value & 0x001 || value & 0x0004)) // Horizontal centering.
		constraint->SetCenter(true);
	else if (value & 0x0200 && (value & 0x002 || value & 0x0008)) // Vertical centering.
		constraint->SetCenter(true);
	else
		constraint->SetCenter(false);


	int ratio = (100 * numerator) / denominator;
	constraint->SetRatio(ratio);

	if (!offset)
		offset++;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafDimensionConstraint ----------------------------------------------------

ZafConstraint *ZafConvertWindow::Read_DIMENSION_CONSTRAINT(
	ZafConstraint*object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafDimensionConstraint(ZAF_NULLP(ZafWindowObject), ZAF_DNCF_WIDTH);

	Read_CONSTRAINT(object, directory, file, persist);

	ZafDimensionConstraint *constraint = DynamicPtrCast(object, ZafDimensionConstraint);

	ZafUInt16 value;
	ZafInt16 max;
	ZafInt16 min;

	*file>>value>>max>>min;

	if (value & 0x0001)
		constraint->SetType(ZAF_DNCF_HEIGHT);
	else if (value & 0x0002)
		constraint->SetType(ZAF_DNCF_WIDTH);

	int temp;
	temp = max;
	constraint->SetMaximum(temp);
	temp = min;
	constraint->SetMinimum(temp);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafConstraint -------------------------------------------------------------

ZafConstraint *ZafConvertWindow::Read_CONSTRAINT(
	ZafConstraint *object, OldDirectory *, OldFile *file,
	ZafObjectPersistence *)
{
	ZafNumberID tNumberID;

	*file>>tNumberID;

	object->SetObjNumberID(tNumberID);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafMDIWindow -----------------------------------------------------

ZafWindowObject *ZafConvertWindow::ReadMDIWindow(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	if (!object)
		object = new ZafMDIWindow(0, 0, 0, 0, mdiType);
	return Read_WINDOW(object, directory, file, persist);
}

// ----- ZafScrolledWindow -----------------------------------------------------

ZafWindowObject *ZafConvertWindow::ReadScrolledWindow(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	if (!object)
		object = new ZafScrolledWindow(0, 0, 0, 0, ZafConvertWindow::scrollWidth,
			ZafConvertWindow::scrollHeight);
	return Read_WINDOW(object, directory, file, persist);
}

// ----- ZafDialogWindow -----------------------------------------------------

ZafWindowObject *ZafConvertWindow::ReadDialogWindow(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	if (!object)
		object = new ZafDialogWindow(0, 0, 0, 0);
	return Read_WINDOW(object, directory, file, persist);
}

// ----- ZafWindowObject --------------------------------------------------

typedef ZafFlags WOF_FLAGS;
const WOF_FLAGS WOF_NO_FLAGS			= 0x0000;
const WOF_FLAGS WOF_JUSTIFY_CENTER		= 0x0001;
const WOF_FLAGS WOF_JUSTIFY_RIGHT		= 0x0002;
const WOF_FLAGS WOF_BORDER				= 0x0004;
const WOF_FLAGS WOF_NO_ALLOCATE_DATA	= 0x0008;
const WOF_FLAGS WOF_VIEW_ONLY			= 0x0010;
const WOF_FLAGS WOF_SUPPORT_OBJECT		= 0x0020;
const WOF_FLAGS WOF_MINICELL			= 0x0040;
const WOF_FLAGS WOF_UNANSWERED			= 0x0080;
const WOF_FLAGS WOF_INVALID				= 0x0100;
const WOF_FLAGS WOF_NON_FIELD_REGION	= 0x0200;
const WOF_FLAGS WOF_NON_SELECTABLE		= 0x0400;
const WOF_FLAGS WOF_AUTO_CLEAR			= 0x0800;
const WOF_FLAGS WOF_PIXEL				= 0x1000;

typedef ZafFlags WOAF_FLAGS;
const WOAF_FLAGS WOAF_NO_FLAGS			= 0x0000;
const WOAF_FLAGS WOAF_OUTSIDE_REGION	= 0x0001;
const WOAF_FLAGS WOAF_NON_CURRENT		= 0x0002;
const WOAF_FLAGS WOAF_TEMPORARY			= 0x0004;
const WOAF_FLAGS WOAF_NO_DESTROY		= 0x0010;
const WOAF_FLAGS WOAF_NORMAL_HOT_KEYS	= 0x0020;
const WOAF_FLAGS WOAF_NO_SIZE			= 0x0040;
const WOAF_FLAGS WOAF_NO_MOVE			= 0x0080;
const WOAF_FLAGS WOAF_MODAL				= 0x0100;
const WOAF_FLAGS WOAF_LOCKED			= 0x0200;
const WOAF_FLAGS WOAF_COPY_DRAG_OBJECT	= 0x0400;
const WOAF_FLAGS WOAF_ACCEPTS_DROP		= 0x1000;
const WOAF_FLAGS WOAF_MOVE_DRAG_OBJECT	= 0x2000;
const WOAF_FLAGS WOAF_MDI_OBJECT		= 0x4000;
const WOAF_FLAGS WOAF_DIALOG_OBJECT		= 0x8000;

ZafWindowObject *ZafConvertWindow::Read_WINDOW_OBJECT(
	ZafWindowObject *object, OldDirectory *, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the window object information.
	ZafNumberID tNumberID;
	ZafIChar tStringID[ZAF_MAXNAMELEN];
	WOF_FLAGS woFlags;
	WOAF_FLAGS woAdvancedFlags;
	*file >> tNumberID >> tStringID >> woFlags >> woAdvancedFlags;
	object->SetNumberID(tNumberID);
	object->SetStringID(tStringID);

	object->SetBordered((woFlags & WOF_BORDER) ? true : false);
	object->SetSupportObject((woFlags & WOF_SUPPORT_OBJECT) ? true : false);
	if (woFlags & WOF_MINICELL)
		object->SetCoordinateType(ZAF_MINICELL);
	else if (woFlags & WOF_PIXEL)
		object->SetCoordinateType(ZAF_PIXEL);
	else
		object->SetCoordinateType(ZAF_CELL);
	if (woFlags & WOF_NON_FIELD_REGION)
		object->SetRegionType(ZAF_AVAILABLE_REGION);
	else if (woAdvancedFlags & WOAF_OUTSIDE_REGION)
		object->SetRegionType(ZAF_OUTSIDE_REGION);
	else
		object->SetRegionType(ZAF_INSIDE_REGION);
	object->SetDisabled((woFlags & WOF_NON_SELECTABLE) ? true : false);
	object->SetNoncurrent((woAdvancedFlags & WOAF_NON_CURRENT) ? true : false);
	object->SetCopyDraggable((woAdvancedFlags & WOAF_COPY_DRAG_OBJECT) ? true : false);
	object->SetAcceptDrop((woAdvancedFlags & WOAF_ACCEPTS_DROP) ? true : false);
	object->SetMoveDraggable((woAdvancedFlags & WOAF_MOVE_DRAG_OBJECT) ? true : false);

	ZafWindow *window = DynamicPtrCast(object, ZafWindow);
	if (window)
	{
		window->SetDestroyable((woAdvancedFlags & WOAF_NO_DESTROY) ? false : true);
		window->SetMoveable((woAdvancedFlags & WOAF_NO_MOVE) ? false : true);
//		window->SetNormalHotKeys((woAdvancedFlags & WOAF_NORMAL_HOT_KEYS) ? true : false);
		window->SetSizeable((woAdvancedFlags & WOAF_NO_SIZE) ? false : true);
		window->SetTemporary((woAdvancedFlags & WOAF_TEMPORARY) ? true : false);
		ZafDialogWindow *dialog = DynamicPtrCast(object, ZafDialogWindow);
		if (dialog)
			dialog->SetModal((woAdvancedFlags & WOAF_MODAL) ? true : false);
		window->SetLocked((woAdvancedFlags & WOAF_LOCKED) ? true : false);
		if ((woAdvancedFlags & WOAF_MDI_OBJECT) && ZafConvertWindow::destroyable)
		{
			ZafConvertWindow::derivedWindowType = MDI;
			delete window;
			return 0;
		}
		else if (woAdvancedFlags & WOAF_DIALOG_OBJECT && ZafConvertWindow::destroyable)
		{
			ZafConvertWindow::derivedWindowType = Dialog;
			delete window;
			return 0;
		}
//		else
//			window->SetWindowType(ZAF_NORMAL_WINDOW);
	}

	ZafString *string = DynamicPtrCast(object, ZafString);
	if (string)
	{
		string->SetViewOnly((woFlags & WOF_VIEW_ONLY) ? true : false);
		if (woFlags & WOF_JUSTIFY_CENTER)
			string->SetHzJustify(ZAF_HZ_CENTER);
		else if (woFlags & WOF_JUSTIFY_RIGHT)
			string->SetHzJustify(ZAF_HZ_RIGHT);
		else
			string->SetHzJustify(ZAF_HZ_LEFT);
		string->SetUnanswered((woFlags & WOF_UNANSWERED) ? true : false);
		string->SetInvalid((woFlags & WOF_INVALID) ? true : false);
		string->SetAutoClear((woFlags & WOF_AUTO_CLEAR) ? true : false);
	}

	ZafText *text = DynamicPtrCast(object, ZafText);
	if (text)
	{
		text->SetViewOnly((woFlags & WOF_VIEW_ONLY) ? true : false);
		if (woFlags & WOF_JUSTIFY_CENTER)
			text->SetHzJustify(ZAF_HZ_CENTER);
		else if (woFlags & WOF_JUSTIFY_RIGHT)
			text->SetHzJustify(ZAF_HZ_RIGHT);
		else
			text->SetHzJustify(ZAF_HZ_LEFT);
		text->SetUnanswered((woFlags & WOF_UNANSWERED) ? true : false);
		text->SetInvalid((woFlags & WOF_INVALID) ? true : false);
		text->SetAutoClear((woFlags & WOF_AUTO_CLEAR) ? true : false);
	}

	ZafPrompt *prompt = DynamicPtrCast(object, ZafPrompt);
	if (prompt)
	{
		if (woFlags & WOF_JUSTIFY_CENTER)
			prompt->SetHzJustify(ZAF_HZ_CENTER);
		else if (woFlags & WOF_JUSTIFY_RIGHT)
			prompt->SetHzJustify(ZAF_HZ_RIGHT);
		else
			prompt->SetHzJustify(ZAF_HZ_LEFT);
	}

	ZafButton *button = DynamicPtrCast(object, ZafButton);
	if (button)
	{
		if (woFlags & WOF_JUSTIFY_CENTER)
			button->SetHzJustify(ZAF_HZ_CENTER);
		else if (woFlags & WOF_JUSTIFY_RIGHT)
			button->SetHzJustify(ZAF_HZ_RIGHT);
		else
			button->SetHzJustify(ZAF_HZ_LEFT);
	}

	ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
	if (spin)
		spin->SetViewOnly((woFlags & WOF_VIEW_ONLY) ? true : false);

	ZafComboBox *combo = DynamicPtrCast(object, ZafComboBox);
	if (combo)
		combo->SetViewOnly((woFlags & WOF_VIEW_ONLY) ? true : false);

	ZafInt16 value;
	*file >> value;
	object->zafRegion.left = value;
	*file >> value;
	object->zafRegion.top = value;
	*file >> value;
	object->zafRegion.right = value;
	*file >> value;
	object->zafRegion.bottom = value;

	// For objects with saveRegion save zafRegion in the saveRegion.
	object->SetRegion(object->zafRegion);

	*file >> value;
	ZafElement *helpElement;
	if (value)
	{
		for (helpElement = helpList.First(); helpElement; helpElement = helpElement->Next())
			if (value == helpElement->NumberID())
			{
				object->SetHelpContext(helpElement->StringID());
				break;
			}
	}

	ZafIChar *userObjectName, *userCallbackName;
	*file >> object->userFlags >> object->userStatus >> &userObjectName >> &userCallbackName;
	if (userObjectName)
	{
		if (persist)
			object->userObject = persist->GetUserObject(userObjectName);
		delete []userObjectName;
	}
	if (userCallbackName)
	{
		if (persist)
			object->userFunction = persist->GetUserCallback(userCallbackName);
		delete []userCallbackName;
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafBignum ---------------------------------------------------------

typedef ZafFlags NMF_FLAGS;
const NMF_FLAGS NMF_NO_FLAGS			= 0x0000;
const NMF_FLAGS NMF_CURRENCY 			= 0x0002;
const NMF_FLAGS NMF_CREDIT 				= 0x0004;
const NMF_FLAGS NMF_COMMAS 				= 0x0008;
const NMF_FLAGS NMF_PERCENT 			= 0x0010;
const NMF_FLAGS NMF_SCIENTIFIC 			= 0x0020;
const NMF_FLAGS NMF_DECIMAL_FLAGS		= 0xFF00;

ZafWindowObject *ZafConvertWindow::Read_BIGNUM(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafBignum(0, 0, 0, ZAF_NULLP(ZafBignumData));
	Read_STRING(object, directory, file, persist);

	// Convert the bignum information.
	ZafBignum *bignum = DynamicPtrCast(object, ZafBignum);
	NMF_FLAGS nmFlags;
	ZafIChar *range;
	*file >> nmFlags >> &range;
	if (range)
	{
		bignum->SetRange(range);
		delete []range;
	}

	if (nmFlags)
	{
		int decimal = ((nmFlags & NMF_DECIMAL_FLAGS) >> 8) - 1;
		ZafIChar precision[6];
		ZafIChar formatStr[32];
		formatStr[0] = 0;

		strcat(formatStr, ZAF_ITEXT("%"));

		if (nmFlags & NMF_CURRENCY)
			strcat(formatStr, ZAF_ITEXT("$"));

		if (nmFlags & NMF_CREDIT)
			strcat(formatStr, ZAF_ITEXT("@"));

		if (nmFlags & NMF_COMMAS)
			strcat(formatStr, ZAF_ITEXT(","));

		if (decimal >= 0)
		{
			sprintf(precision, ZAF_ITEXT(".%d"), decimal);
			strcat(formatStr, precision);
		}

		strcat(formatStr, ZAF_ITEXT("B"));

		if (nmFlags & NMF_PERCENT)
			strcat(formatStr, ZAF_ITEXT("%%"));

		bignum->SetOutputFormat(formatStr);
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafBorder ---------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_BORDER(
	ZafWindowObject *object, OldDirectory *, OldFile *,
	ZafObjectPersistence *)
{
	// Initialize the base information.
	if (!object)
		object = new ZafBorder;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafButton ---------------------------------------------------------

typedef ZafFlags BTF_FLAGS;
const BTF_FLAGS BTF_NO_FLAGS			= 0x0000;
const BTF_FLAGS BTF_NO_TOGGLE			= 0x0001;
const BTF_FLAGS BTF_DOWN_CLICK			= 0x0002;
const BTF_FLAGS BTF_REPEAT				= 0x0008;
const BTF_FLAGS BTF_DOUBLE_CLICK		= 0x0010;
const BTF_FLAGS BTF_AUTO_SIZE			= 0x0020;
const BTF_FLAGS BTF_NO_3D				= 0x0040;
const BTF_FLAGS BTF_CHECK_BOX			= 0x0080;
const BTF_FLAGS BTF_RADIO_BUTTON		= 0x0100;
const BTF_FLAGS BTF_SEND_MESSAGE		= 0x0200;
const BTF_FLAGS BTF_STATIC_BITMAPARRAY	= 0x0400;
const BTF_FLAGS BTF_DEFAULT_BUTTON      = 0x0800;

ZafWindowObject *ZafConvertWindow::Read_BUTTON(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafButton(0, 0, 0, 0, ZAF_NULLP(ZafStringData), ZAF_NULLP(ZafBitmapData), ZAF_NATIVE_BUTTON);
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the button information.
	ZafButton *button = DynamicPtrCast(object, ZafButton);
	// button flags
	BTF_FLAGS btFlags; *file >> btFlags;
	button->SetAllowToggling((btFlags & BTF_NO_TOGGLE) ? false : true);
	button->SetSelectOnDownClick((btFlags & BTF_DOWN_CLICK) ? true : false);
	button->SetAutoRepeatSelection((btFlags & BTF_REPEAT) ? true : false);
	button->SetSelectOnDoubleClick((btFlags & BTF_DOUBLE_CLICK) ? true : false);
	button->SetSelectOnDownClick((btFlags & BTF_NO_3D) ? true : false);
	if (btFlags & BTF_CHECK_BOX)
		button->SetButtonType(ZAF_CHECK_BOX);
	else if (btFlags & BTF_RADIO_BUTTON)
		button->SetButtonType(ZAF_RADIO_BUTTON);
	else if (btFlags & BTF_NO_3D)
		button->SetButtonType(ZAF_FLAT_BUTTON);
	button->SetAutoSize((btFlags & BTF_AUTO_SIZE) ? true : false);
	button->SetSendMessageWhenSelected((btFlags & BTF_SEND_MESSAGE) ? true : false);
//	button->SetDefaultButton((btFlags & BTF_DEFAULT_BUTTON) ? true : false);
	button->SetSelectOnDownClick((btFlags & BTF_STATIC_BITMAPARRAY) ? true : false);
	// value, depth
	ZafInt16 value, depth;
	ZafIChar *text, *bitmapName;
	*file >> value >> depth >> &text >> &bitmapName;
	button->SetValue(value);
	if (btFlags & BTF_NO_3D)
		button->SetDepth(0);
	else
		button->SetDepth(depth);
	if (text)
	{
		int index;
		ZafIChar hotkey;
		StripHotkey(text, hotkey, index);

		button->SetText(text);
		button->SetHotKey(hotkey, index);

		delete []text;
	}
	if (bitmapName)
	{
		directory->ChDir("~UI_BITMAP");
		OldFile *subObject = directory->AllocateFile(bitmapName);
		if (subObject && !subObject->Error())
		{
			ZafImageStruct image;
			ZafInt16 value;
			*subObject >> value;
			image.width = value;
			*subObject >> value;
			image.height = value;
			image.staticArray = false;
			image.array = new ZafLogicalColor[image.width * image.height];
			subObject->Read(image.array, sizeof(ZafLogicalColor), image.width * image.height);
			ZafBitmapData *imageData = new ZafBitmapData(image);
			imageData->SetStringID(bitmapName);
			button->SetBitmapData(imageData);
			delete []image.array;
		}
		directory->FreeFile(subObject);
		delete []bitmapName;
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafComboBox ------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_COMBO_BOX(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafComboBox(0, 0, 0, 0);
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the combo-box information.
	ZafComboBox *comboBox = DynamicPtrCast(object, ZafComboBox);
	Read_VT_LIST(comboBox->list, directory, file, persist);
	comboBox->SetOSDraw(comboBox->list->OSDraw());

	// Return a pointer to the object.
	return (object);
}

// ----- ZafDate -----------------------------------------------------------

typedef ZafFlags DTF_FLAGS;
const DTF_FLAGS DTF_NO_FLAGS			= 0x0000;
const DTF_FLAGS DTF_US_FORMAT		 	= 0x0001;
const DTF_FLAGS DTF_EUROPEAN_FORMAT		= 0x0002;
const DTF_FLAGS DTF_JAPANESE_FORMAT		= 0x0004;
const DTF_FLAGS DTF_ASIAN_FORMAT		= 0x0004;
const DTF_FLAGS DTF_MILITARY_FORMAT		= 0x0008;
const DTF_FLAGS DTF_DASH				= 0x0010;
const DTF_FLAGS DTF_SLASH				= 0x0020;
const DTF_FLAGS DTF_ALPHA_MONTH			= 0x0040;
const DTF_FLAGS DTF_DAY_OF_WEEK			= 0x0080;
const DTF_FLAGS DTF_UPPER_CASE			= 0x0100;
const DTF_FLAGS DTF_SHORT_YEAR			= 0x0200;
const DTF_FLAGS DTF_SHORT_MONTH			= 0x0400;
const DTF_FLAGS DTF_SHORT_DAY			= 0x0800;
const DTF_FLAGS DTF_ZERO_FILL			= 0x1000;
const DTF_FLAGS DTF_SYSTEM				= 0x4000;

static ZafIChar _yStr[] = ZAF_ITEXT("%y"); // Short year
static ZafIChar YStr[] = ZAF_ITEXT("%Y");  // Long year
static ZafIChar _bStr[] = ZAF_ITEXT("%b"); // short month
static ZafIChar BStr[] = ZAF_ITEXT("%B");  // Alphabetic month
static ZafIChar _gStr[] = ZAF_ITEXT("%g"); // Short military month
static ZafIChar GStr[] = ZAF_ITEXT("%G");  // Short military day
static ZafIChar vStr[] = ZAF_ITEXT("%v");  // numeric month 
static ZafIChar mZStr[] = ZAF_ITEXT("%m"); // Month zero fill
static ZafIChar _aStr[] = ZAF_ITEXT("%a "); // Short day of week
static ZafIChar AStr[] = ZAF_ITEXT("%A "); // Alphabetic day of week
static ZafIChar dStr[] = ZAF_ITEXT("%e"); // numeric day
static ZafIChar dZStr[] = ZAF_ITEXT("%d"); // numeric day zero fill
static ZafIChar _dateBlankSeparator[] 	= ZAF_ITEXT(" ");
static ZafIChar _dateDashSeparator[] 	= ZAF_ITEXT("-");
static ZafIChar _dateSlashSeparator[] 	= ZAF_ITEXT("/");
static ZafIChar _dateCommaSeparator[] 	= ZAF_ITEXT(",");

static ZafIChar canonicalDateFormat[]		= ZAF_ITEXT("%Y-%m-%d");
ZafWindowObject *ZafConvertWindow::Read_DATE(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafDate(0, 0, 0, ZAF_NULLP(ZafDateData));

	ZafDate *date = DynamicPtrCast(object, ZafDate);
	// We have to set the format before reading in the date
	date->SetOutputFormat(canonicalDateFormat);

	Read_STRING(object, directory, file, persist);

	date->SetOutputFormat(ZAF_NULLP(ZafIChar));

	// Convert the date information.
	DTF_FLAGS dtFlags;
	ZafIChar *range;
	*file >> dtFlags >> &range;
	if (range)
	{
		date->SetRange(range);
		delete []range;
	}

	if (dtFlags)
	{
		const ZafIChar *yearSeparator, *monthSeparator, *daySeparator;
		if (dtFlags & DTF_MILITARY_FORMAT)
		{
			dtFlags &= (DTF_MILITARY_FORMAT | DTF_SHORT_MONTH | DTF_SHORT_YEAR |
				DTF_SYSTEM | DTF_UPPER_CASE | DTF_ZERO_FILL);
			dtFlags |= DTF_ALPHA_MONTH;
			if (dtFlags & (DTF_SHORT_MONTH | DTF_SHORT_YEAR))
				dtFlags |= DTF_SHORT_MONTH | DTF_SHORT_YEAR;
			yearSeparator=monthSeparator=daySeparator= _dateBlankSeparator;
		}
		else if (dtFlags & DTF_DASH)
			yearSeparator=monthSeparator=daySeparator= _dateDashSeparator;
		else if (dtFlags & DTF_SLASH)
			yearSeparator=monthSeparator=daySeparator= _dateSlashSeparator;
		else if ((dtFlags & (DTF_ALPHA_MONTH | DTF_SHORT_MONTH)) &&
		 	(!(dtFlags & DTF_ASIAN_FORMAT) &&
		  	(dtFlags & (DTF_EUROPEAN_FORMAT|DTF_US_FORMAT))))
		{
			yearSeparator = zafLocale->dateSeparator;
			daySeparator = _dateCommaSeparator;
			monthSeparator = _dateBlankSeparator;
		}
		else
			yearSeparator = monthSeparator = daySeparator = zafLocale->dateSeparator;

		int doZeroFill = (dtFlags & DTF_ZERO_FILL);

		// Determine the year value.
		ZafIChar *yearStr = (dtFlags & DTF_SHORT_YEAR) ? _yStr : YStr;

		// Determine the month value.
		ZafIChar *monthStr = ((dtFlags & DTF_SHORT_MONTH) ?
			     	((dtFlags & DTF_MILITARY_FORMAT) ? _gStr : _bStr):
			     	(dtFlags & DTF_ALPHA_MONTH) ? BStr :
			      	(doZeroFill ? mZStr : vStr));

		// Add the day of week value to the date.
		ZafIChar *dayStr = ((dtFlags & DTF_SHORT_DAY) ?
			   	((dtFlags & DTF_MILITARY_FORMAT) ?GStr:_aStr) :
			   	((dtFlags & DTF_DAY_OF_WEEK) ? AStr : ZafLanguageData::blankString));

		ZafIChar tmpFormat[256];
		strcpy(tmpFormat, dayStr);
		// Format the date according to the country information.
		if (dtFlags & DTF_ASIAN_FORMAT)
		{
			strcat(tmpFormat, yearStr);
			strcat(tmpFormat, yearSeparator);
			strcat(tmpFormat, monthStr);
			strcat(tmpFormat, monthSeparator);
			strcat(tmpFormat, (doZeroFill ? dZStr : dStr));
		}
		else if (dtFlags & (DTF_EUROPEAN_FORMAT | DTF_MILITARY_FORMAT))
		{
			strcat(tmpFormat, (doZeroFill ? dZStr : dStr));
			strcat(tmpFormat, monthSeparator);
			strcat(tmpFormat, monthStr);
			strcat(tmpFormat, daySeparator);
			strcat(tmpFormat, yearStr);
		}
		else if (dtFlags & DTF_US_FORMAT)
		{
			strcat(tmpFormat, monthStr);
			strcat(tmpFormat, monthSeparator);
			strcat(tmpFormat, (doZeroFill ? dZStr : dStr));
			strcat(tmpFormat, daySeparator);
			strcat(tmpFormat, yearStr);
		}
		else
			strcat(tmpFormat, zafLocale->dateStringOutputFormat);

		date->SetOutputFormat(tmpFormat);
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafFormattedString -----------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_FORMATTED_STRING(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafFormattedString(0, 0, 0, ZAF_NULLP(ZafStringData), ZAF_NULLP(ZafStringData), ZAF_NULLP(ZafStringData));
	Read_STRING(object, directory, file, persist);

	// Convert the bignum information.
	ZafFormattedString *formattedString = DynamicPtrCast(object, ZafFormattedString);
	ZafIChar *compressedText, *format, *deleteText;
	*file >> &compressedText >> &format >> &deleteText;
	if (format)
	{
		formattedString->SetOutputFormat(format);
		formattedString->SetInputFormat(format);
		delete []format;
	}
	if (deleteText)
	{
		formattedString->SetDeleteText(deleteText);
		delete []deleteText;
	}
	if (!compressedText)
		compressedText = ParseCompressedText(deleteText, format);
	formattedString->SetCompressedText(compressedText);
	delete []compressedText;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafGroup ----------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_GROUP(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafGroup(0, 0, 0, 0, ZAF_NULLP(ZafStringData));
	Read_WINDOW(object, directory, file, persist);

	// Convert the group information.
	ZafGroup *group = DynamicPtrCast(object, ZafGroup);
	ZafIChar *text;
	*file >> &text;
	if (text)
	{
		int index;
		ZafIChar hotkey;
		StripHotkey(text, hotkey, index);

		group->SetText(text);
		group->SetHotKey(hotkey, index);

		delete []text;
	}

	group->SetBordered(true);

	for (ZafWindowObject *child = group->First(); child; child = child->Next())
	{
		int offset;
		if (child->CoordinateType() == ZAF_CELL)
			offset = 1;
		else if (child->CoordinateType() == ZAF_MINICELL)
			offset = (int)(display->cellHeight * display->miniNumeratorY / display->miniDenominatorY);
		else
			offset = display->cellHeight;
		child->zafRegion.top -= offset;
		child->zafRegion.bottom -= offset;
		child->SetRegion(child->zafRegion);
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafHzList --------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_HZ_LIST(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafHzList(0, 0, 0, 0, 0, 0);
	Read_WINDOW(object, directory, file, persist);

	// Convert the hz-list information.
	ZafHzList *hzList = DynamicPtrCast(object, ZafHzList);
	ZafInt16 value;
	*file >> value;
	hzList->cellWidth = value;
	*file >> value;
	hzList->cellHeight = value;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafIcon -----------------------------------------------------------

typedef ZafFlags ICF_FLAGS;
const ICF_FLAGS ICF_NO_FLAGS			= 0x0000;
const ICF_FLAGS ICF_DOUBLE_CLICK		= 0x0001;
const ICF_FLAGS ICF_MINIMIZE_OBJECT		= 0x0002;
const ICF_FLAGS ICF_STATIC_ICONARRAY	= 0x0400;

ZafWindowObject *ZafConvertWindow::Read_ICON(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafIcon(0, 0, ZAF_NULLP(ZafStringData), ZAF_NULLP(ZafIconData), ZAF_NATIVE_ICON);
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the icon information.
	ZafIcon *icon = DynamicPtrCast(object, ZafIcon);
	ICF_FLAGS icFlags;
	ZafIChar *text, *iconName;
	*file >> icFlags >> &text >> &iconName;
	icon->SetSelectOnDoubleClick((icFlags & ICF_DOUBLE_CLICK) ? true : false);
	if (icFlags & ICF_MINIMIZE_OBJECT)
		icon->SetIconType(ZAF_MINIMIZE_ICON);
	else
		icon->SetIconType(ZAF_NATIVE_ICON);
	if (text)
	{
		int index;
		ZafIChar hotkey;
		StripHotkey(text, hotkey, index);

		icon->SetText(text);
		icon->SetHotKey(hotkey, index);

		delete []text;
	}
	if (iconName)
	{
		// Check the icon table.
		bool foundInTable = false;
		for (int i = 0; icon->imageTable[i]; i++)
		{
			if (!strcmp(icon->imageTable[i]->StringID(), iconName))
			{
				icon->SetIconData(icon->imageTable[i]);
				foundInTable = true;
				break;
			}
		}

		if (!foundInTable)
		{
			directory->ChDir("~UI_ICON");
			OldFile *subObject = directory->AllocateFile(iconName);
			if (subObject && !subObject->Error())
			{
				ZafImageStruct image;
				ZafInt16 value;
				*subObject >> value;
				image.width = value;
				*subObject >> value;
				image.height = value;
				image.staticArray = false;
				image.array = new ZafLogicalColor[image.width * image.height];
				subObject->Read(image.array, sizeof(ZafLogicalColor), image.width * image.height);
				ZafIconData *imageData = new ZafIconData(image);
				imageData->SetStringID(iconName);
				icon->SetIconData(imageData);
				delete []image.array;
			}
			directory->FreeFile(subObject);
		}
		delete []iconName;
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafInteger --------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_INTEGER(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafInteger(0, 0, 0, ZAF_NULLP(ZafIntegerData));
	Read_STRING(object, directory, file, persist);

	// Convert the integer information.
	ZafInteger *integer = DynamicPtrCast(object, ZafInteger);
	NMF_FLAGS nmFlags;
	ZafIChar *range;
	*file >> nmFlags >> &range;
	if (range)
	{
		integer->SetRange(range);
		delete []range;
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafMaximizeButton ------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_MAXIMIZE_BUTTON(
	ZafWindowObject *object, OldDirectory *, OldFile *,
	ZafObjectPersistence *)
{
	// Initialize the base information.
	if (!object)
		object = new ZafMaximizeButton;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafMinimizeButton ------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_MINIMIZE_BUTTON(
	ZafWindowObject *object, OldDirectory *, OldFile *,
	ZafObjectPersistence *)
{
	// Initialize the base information.
	if (!object)
		object = new ZafMinimizeButton;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafNotebook -------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_NOTEBOOK(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafNotebook(0, 0, 0, 0);
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the window information.
	ZafNotebook *notebk = DynamicPtrCast(object, ZafNotebook);
	WNF_FLAGS wnFlags;
	ZafIChar *compareFunctionName;
	*file >> wnFlags >> &compareFunctionName;
	if (compareFunctionName)
		delete []compareFunctionName;

	// Load the notebook pages.
 	ZafInt16 noOfObjects;
	*file >> noOfObjects;

	for (int i = 0; i < noOfObjects; i++)
	{
		ZafClassID saveID;
		*file >> saveID;
		for (int j = 0; convert[j].classID != ID_END; j++)
			if (saveID == convert[j].classID)
			{
				notebk->Add((convert[j].function)(0, directory, file, persist));
				break;
			}
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafPopUpMenu ----------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_POP_UP_MENU(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafPopUpMenu(0, 0);
	Read_WINDOW(object, directory, file, persist);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafPopUpItem ----------------------------------------------------

typedef ZafFlags MNIF_FLAGS;
const MNIF_FLAGS MNIF_NO_FLAGS			= 0x0000;
const MNIF_FLAGS MNIF_SEPARATOR			= 0x0001;
const MNIF_FLAGS MNIF_MAXIMIZE			= 0x0002;
const MNIF_FLAGS MNIF_MINIMIZE			= 0x0004;
const MNIF_FLAGS MNIF_MOVE				= 0x0008;
const MNIF_FLAGS MNIF_SIZE				= 0x0010;
const MNIF_FLAGS MNIF_SWITCH			= 0x0020;
const MNIF_FLAGS MNIF_RESTORE			= 0x0040;
const MNIF_FLAGS MNIF_CLOSE				= 0x0080;
const MNIF_FLAGS MNIF_CHECK_MARK		= 0x0100;
const MNIF_FLAGS MNIF_SEND_MESSAGE		= 0x0200;
const MNIF_FLAGS MNIF_NON_SELECTABLE	= 0x0400;
const MNIF_FLAGS MNIF_ABOUT				= 0x0800;

ZafWindowObject *ZafConvertWindow::Read_POP_UP_ITEM(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafPopUpItem(ZAF_NULLP(ZafStringData), ZAF_NORMAL_ITEM);
	Read_BUTTON(object, directory, file, persist);

	// Convert the window information.
	ZafPopUpItem *popupItem = DynamicPtrCast(object, ZafPopUpItem);
	MNIF_FLAGS mniFlags;
	*file >> mniFlags;
	const ZafIChar *text = popupItem->Text();
	if (mniFlags & MNIF_MAXIMIZE)
		popupItem->SetItemType(ZAF_MAXIMIZE_OPTION);
	else if (mniFlags & MNIF_MINIMIZE)
		popupItem->SetItemType(ZAF_MINIMIZE_OPTION);
	else if (mniFlags & MNIF_MOVE)
		popupItem->SetItemType(ZAF_MOVE_OPTION);
	else if (mniFlags & MNIF_SIZE)
		popupItem->SetItemType(ZAF_SIZE_OPTION);
	else if (mniFlags & MNIF_SWITCH)
		popupItem->SetItemType(ZAF_SWITCH_OPTION);
	else if (mniFlags & MNIF_RESTORE)
		popupItem->SetItemType(ZAF_RESTORE_OPTION);
	else if (mniFlags & MNIF_CLOSE)
		popupItem->SetItemType(ZAF_CLOSE_OPTION);
	else if (mniFlags & MNIF_ABOUT)
		popupItem->SetItemType(ZAF_ABOUT_OPTION);
	else if (mniFlags & MNIF_SEPARATOR || !text || !text[0])
		popupItem->SetItemType(ZAF_SEPARATOR);
	else
		popupItem->SetItemType(ZAF_NORMAL_ITEM);
	popupItem->SetAllowToggling((mniFlags & MNIF_CHECK_MARK) ? true : false);
	popupItem->SetSendMessageWhenSelected((mniFlags & MNIF_SEND_MESSAGE) ? true : false);
	popupItem->SetDisabled((mniFlags & MNIF_NON_SELECTABLE) ? true : false);
	Read_POP_UP_MENU(&popupItem->menu, directory, file, persist);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafPrompt ---------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_PROMPT(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafPrompt(0, 0, 0, ZAF_NULLP(ZafStringData));
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the prompt information.
	ZafPrompt *prompt = DynamicPtrCast(object, ZafPrompt);

	// Set disabled to the original (4.x) intent.
	prompt->SetDisabled(false);

	ZafIChar *text;
	*file >> &text;
	if (text)
	{
		int index;
		ZafIChar hotkey;
		StripHotkey(text, hotkey, index);

		prompt->SetText(text);
		prompt->SetHotKey(hotkey, index);

		delete []text;
	}

	// Set automatic variables.
	prompt->noncurrent = true;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafPullDownMenu -------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_PULL_DOWN_MENU(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafPullDownMenu;
	Read_WINDOW(object, directory, file, persist);
	object->SetNumberID(ZAF_NUMID_PULL_DOWN_MENU);
	object->SetStringID(ZAF_ITEXT("ZAF_NUMID_PULL_DOWN_MENU"));

	// Return a pointer to the object.
	return (object);
}

// ----- ZafPullDownItem -------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_PULL_DOWN_ITEM(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafPullDownItem(ZAF_NULLP(ZafStringData));
	Read_BUTTON(object, directory, file, persist);

	// Convert the window information.
	ZafPullDownItem *pulldownItem = DynamicPtrCast(object, ZafPullDownItem);
	Read_POP_UP_MENU(&pulldownItem->menu, directory, file, persist);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafReal -----------------------------------------------------------
//#define	NMF_DECIMAL(decimal)			(((decimal) + 1) << 8)
#define	NMF_DIGITS(flags)				((((int)(flags) >> 8) & 0xFF) - 1)

static ZafIChar scientificFormat[] = ZAF_ITEXT("%e");
static ZafIChar realFormat[] = ZAF_ITEXT("g");

ZafWindowObject *ZafConvertWindow::Read_REAL(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafReal(0, 0, 0, ZAF_NULLP(ZafRealData));
	Read_STRING(object, directory, file, persist);

	// Convert the real information.
	ZafReal *real = DynamicPtrCast(object, ZafReal);
	NMF_FLAGS nmFlags;
	ZafIChar *range;
	*file >> nmFlags >> &range;
	if (range)
	{
		real->SetRange(range);
		delete []range;
	}

	if (nmFlags)
	{
		ZafIChar format[16];
		format[0] = 0;
		int len;

		if (nmFlags & NMF_SCIENTIFIC)
			strcat(format, scientificFormat);
		else
		{
			strcat(format, ZAF_ITEXT("%"));

			if (NMF_DIGITS(nmFlags) >= 0)
			{
				len = strlen(format);
				sprintf(&format[len], ZAF_ITEXT(".%d"), NMF_DIGITS(nmFlags));
			}
			strcat(format, realFormat);
		}

		real->SetOutputFormat(format);
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafScrollBar -----------------------------------------------------

typedef ZafFlags SBF_FLAGS;
const SBF_FLAGS SBF_NO_FLAGS			= 0x0000;
const SBF_FLAGS SBF_CORNER				= 0x0001;
const SBF_FLAGS SBF_VERTICAL			= 0x0002;
const SBF_FLAGS SBF_HORIZONTAL			= 0x0004;
const SBF_FLAGS SBF_SLIDER				= 0x0008;
const SBF_FLAGS SBF_SCALE				= 0x0008;
const SBF_FLAGS SBF_SIZEGRIP			= 0x0010;

ZafWindowObject *ZafConvertWindow::Read_SCROLL_BAR(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData), ZAF_VERTICAL_SCROLL);
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the scroll-bar information.
	ZafScrollBar *scrollBar = DynamicPtrCast(object, ZafScrollBar);
	SBF_FLAGS sbFlags;
	*file >> sbFlags;
	if (sbFlags == SBF_CORNER)
		scrollBar->SetScrollType(ZAF_CORNER_SCROLL);
	else if (sbFlags == (SBF_VERTICAL | SBF_SLIDER))
		scrollBar->SetScrollType(ZAF_VERTICAL_SLIDER);
	else if (sbFlags == ZAF_VERTICAL_SCROLL)
		scrollBar->SetScrollType(ZAF_VERTICAL_SCROLL);
	else if (sbFlags == (SBF_HORIZONTAL | SBF_SLIDER))
		scrollBar->SetScrollType(ZAF_HORIZONTAL_SLIDER);
	else if (sbFlags == SBF_HORIZONTAL)
		scrollBar->SetScrollType(ZAF_HORIZONTAL_SCROLL);
	// SBF_SIZEGRIP

	ZafScrollStruct scroll;
	scroll.delta = scroll.showing = 1;
	ZafInt16 value;
	*file >> value;
	scroll.minimum = value;
	*file >> value;
	scroll.maximum = value;
	*file >> value;
	scroll.current = value;
	scrollBar->ScrollData()->SetScroll(scroll);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafSpinControl ---------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_SPIN_CONTROL(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafSpinControl(0, 0, 0, ZAF_NULLP(ZafFormatData));
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the scroll-bar information.
	ZafSpinControl *spin = DynamicPtrCast(object, ZafSpinControl);
	ZafClassID saveID;
	*file >> saveID;
	for (int j = 0; convert[j].classID != ID_END; j++)
		if (saveID == convert[j].classID)
		{
			spin->Add((convert[j].function)(0, directory, file, persist));
			break;
		}
	WNF_FLAGS wnFlags;
	ZafInt32 delta;
	*file >> wnFlags >> delta;
	switch (saveID)
	{
	case ID_ZAF_BIGNUM:
		spin->delta = new ZafBignumData((long)delta);
		break;
	case ID_ZAF_DATE:
		spin->delta = new ZafDateData(0, 0, (int)delta);
		break;
	case ID_ZAF_INTEGER:
		spin->delta = new ZafIntegerData(delta);
		break;
	case ID_ZAF_REAL:
		spin->delta = new ZafRealData(delta);
		break;
	case ID_ZAF_TIME:
		spin->delta = new ZafTimeData(0, 0, (int)delta, 0);
		break;
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafStatusBar -----------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_STATUS_BAR(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafStatusBar(0, 0, 0, 0);
	Read_WINDOW(object, directory, file, persist);

	// Convert the status-bar information.
	ZafStatusBar *statusBar = DynamicPtrCast(object, ZafStatusBar);
	ZafInt16 height;
	*file >> height;
	statusBar->zafRegion.bottom = statusBar->zafRegion.top + height - 1;
	statusBar->SetRegion(statusBar->zafRegion);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafString ---------------------------------------------------------

typedef ZafFlags STF_FLAGS;
const STF_FLAGS STF_NO_FLAGS			= 0x0000;
const STF_FLAGS STF_VARIABLE_NAME		= 0x0001;
const STF_FLAGS STF_LOWER_CASE			= 0x0002;
const STF_FLAGS STF_UPPER_CASE			= 0x0004;
const STF_FLAGS STF_PASSWORD			= 0x0008;

ZafWindowObject *ZafConvertWindow::Read_STRING(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafString(0, 0, 0, ZAF_NULLP(ZafStringData));
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the string information.
	ZafString *string = DynamicPtrCast(object, ZafString);
	STF_FLAGS stFlags;
	ZafInt16 maxLength;
	ZafIChar *value;
	*file >> stFlags >> maxLength >> &value;
	string->SetVariableName((stFlags & STF_VARIABLE_NAME) ? true : false);
	string->SetLowerCase((stFlags & STF_LOWER_CASE) ? true : false);
	string->SetUpperCase((stFlags & STF_UPPER_CASE) ? true : false);
	string->SetPassword((stFlags & STF_PASSWORD) ? true : false);
	string->StringData()->SetText(value, maxLength);
	if (value)
		delete []value;

	// Return a pointer to the object.
	return (object);
}

// ----- ZafSystemButton --------------------------------------------------

typedef ZafFlags SYF_FLAGS;
const SYF_FLAGS SYF_NO_FLAGS			= 0x0000;
const SYF_FLAGS SYF_GENERIC				= 0x0001;

ZafWindowObject *ZafConvertWindow::Read_SYSTEM_BUTTON(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafSystemButton(ZAF_NATIVE_SYSTEM_BUTTON);

	// Convert the string information.
	ZafSystemButton *sysButton = DynamicPtrCast(object, ZafSystemButton);
	SYF_FLAGS syFlags;
	*file >> syFlags;
	if (syFlags & SYF_GENERIC)
		sysButton->SetSystemButtonType(ZAF_NATIVE_SYSTEM_BUTTON);
	else
	{
		sysButton->SetSystemButtonType(ZAF_EMPTY_SYSTEM_BUTTON);
		Read_POP_UP_MENU(&sysButton->menu, directory, file, persist);
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafTable ----------------------------------------------------------

typedef ZafFlags TBLF_FLAGS;
const TBLF_FLAGS TBLF_NO_FLAGS			= 0x0000;
const TBLF_FLAGS TBLF_GRID				= 0x0001;

ZafWindowObject *ZafConvertWindow::Read_TABLE(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafTable(0, 0, 0, 0);
	Read_WINDOW(object, directory, file, persist);

	ZafTable *table = DynamicPtrCast(object, ZafTable);
	if (table)
	{
		ZafTableRecord *tableRec = table->First();

		table->Subtract(tableRec);

		table->SetVirtualRecord(tableRec);
	}

	ZafInt16 tblFlags, columns, recordSize;
	*file >> tblFlags >> columns >> recordSize;
	table->SetGrid((tblFlags & TBLF_GRID) ? true : false);

	// Return a pointer to the object.
	return (object);
}

typedef ZafFlags THF_FLAGS;
const THF_FLAGS THF_NO_FLAGS			= 0x0000;
const THF_FLAGS THF_GRID				= 0x0001;
const THF_FLAGS THF_CORNER_HEADER		= 0x0002;
const THF_FLAGS THF_COLUMN_HEADER		= 0x0004;
const THF_FLAGS THF_ROW_HEADER			= 0x0008;

ZafWindowObject *ZafConvertWindow::Read_TABLE_HEADER(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafTableHeader(1, 1, ZAF_COLUMN_HEADER);
	Read_TABLE(object, directory, file, persist);

	object->SetOSDraw(false);

	// Convert the table header information.
	ZafTableHeader *tableHeader = DynamicPtrCast(object, ZafTableHeader);
	THF_FLAGS thFlags;
	*file >> thFlags;

	// In 5.0 table records aren't used as children of headers.
	ZafWindowObject *firstRecord = tableHeader->First();
	ZafTableRecord *record = DynamicPtrCast(firstRecord, ZafTableRecord);
	tableHeader->Subtract(record);
	while (record->First())
	{
		ZafWindowObject *child = record->First();
		record->Subtract(child);
		tableHeader->Add(child);
	}
  	delete record;

	if (thFlags & THF_COLUMN_HEADER)
		tableHeader->headerType = ZAF_COLUMN_HEADER;
	else if (thFlags & THF_ROW_HEADER)
	{

		tableHeader->headerType = ZAF_ROW_HEADER;

		// Take care of sizing differences between 4.x and 5.0.
		ZafRegionStruct temp;
		temp.right = 3;
		temp.coordinateType = ZAF_CELL;
		temp.ConvertCoordinates(tableHeader->zafRegion.coordinateType);
		tableHeader->zafRegion.right += temp.right + 1;
		ZafWindowObject *virtualField = tableHeader->First();
		tableHeader->Subtract(virtualField);
		tableHeader->SetVirtualField(virtualField);
		tableHeader->SetRegion(tableHeader->zafRegion);
	}
	else
	{
		tableHeader->headerType = ZAF_CORNER_HEADER;
		// Take care of sizing differences between 4.x and 5.0.
		ZafRegionStruct temp;
		temp.right = 3;
		temp.coordinateType = ZAF_CELL;
		temp.ConvertCoordinates(tableHeader->zafRegion.coordinateType);
		tableHeader->zafRegion.right += temp.right + 1;
		tableHeader->SetRegion(tableHeader->zafRegion);
	}

	// Return a pointer to the object.
	return (object);
}

ZafWindowObject *ZafConvertWindow::Read_TABLE_RECORD(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafTableRecord(1, 1);
	Read_WINDOW(object, directory, file, persist);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafText -----------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_TEXT(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafText(0, 0, 0, 0, ZAF_NULLP(ZafStringData));
	Read_WINDOW_OBJECT(object, directory, file, persist);

	// Convert the string information.
	ZafText *text = DynamicPtrCast(object, ZafText);
	ZafInt16 maxLength;
	ZafIChar *value;
	*file >> maxLength >> &value;
	text->StringData()->SetText(value, maxLength);
	if (value)
		delete []value;

	ZafInt16 noOfObjects;
	*file >> noOfObjects;

	for (int i = 0; i < noOfObjects; i++)
	{
		ZafClassID saveID;
		*file >> saveID;
		for (int j = 0; convert[j].classID != ID_END; j++)
			if (saveID == convert[j].classID)
			{
				text->Add((convert[j].function)(0, directory, file, persist));
				break;
			}
	}

	WNF_FLAGS wnFlags;
	*file >> wnFlags;
	text->SetOSDraw((wnFlags & WNF_OWNERDRAW_CHILDREN) ? false : true);
	text->SetWordWrap((wnFlags & WNF_NO_WRAP) ? true : false);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafTime -----------------------------------------------------------

typedef ZafFlags TMF_FLAGS;
const TMF_FLAGS TMF_NO_FLAGS			= 0x0000;
const TMF_FLAGS TMF_SECONDS 			= 0x0001;
const TMF_FLAGS TMF_HUNDREDTHS			= 0x0002;
const TMF_FLAGS TMF_NO_HOURS			= 0x0004;
const TMF_FLAGS TMF_NO_MINUTES			= 0x0008;
const TMF_FLAGS TMF_TWELVE_HOUR			= 0x0010;
const TMF_FLAGS TMF_TWENTY_FOUR_HOUR	= 0x0020;
const TMF_FLAGS TMF_ZERO_FILL			= 0x0040;
const TMF_FLAGS TMF_COLON_SEPARATOR		= 0x0080;
const TMF_FLAGS TMF_NO_SEPARATOR		= 0x0100;
const TMF_FLAGS TMF_UPPER_CASE			= 0x0200;
const TMF_FLAGS TMF_LOWER_CASE			= 0x0400;
const TMF_FLAGS TMF_SYSTEM				= 0x0800;

static ZafIChar hStr[] = ZAF_ITEXT("%h"); // 24 hour
static ZafIChar HStr[] = ZAF_ITEXT("%H"); // 24 hour zero fill
static ZafIChar iStr[] = ZAF_ITEXT("%i"); // 12 hour
static ZafIChar IStr[] = ZAF_ITEXT("%I"); // 12 hour zero fill
static ZafIChar mStr[] = ZAF_ITEXT("%M"); // minutes
static ZafIChar sStr[] = ZAF_ITEXT("%S"); // seconds
static ZafIChar kStr[] = ZAF_ITEXT("%k"); // hundredths
static ZafIChar pStr[] = ZAF_ITEXT("%p"); // AM/PM

static ZafIChar canonicalTimeFormat[] = ZAF_ITEXT("%H:%M");

ZafWindowObject *ZafConvertWindow::Read_TIME(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafTime(0, 0, 0, ZAF_NULLP(ZafTimeData));

	ZafTime *time = DynamicPtrCast(object, ZafTime);
	//We need to set the format before the object is read in
	time->SetOutputFormat(canonicalTimeFormat);

	Read_STRING(object, directory, file, persist);
	
	time->SetOutputFormatData(ZAF_NULLP(ZafStringData));

	// Convert the time information.
	TMF_FLAGS tmFlags;
	ZafIChar *range;
	*file >> tmFlags >> &range;
	if (range)
	{
		time->SetRange(range);
		delete []range;
	}

	ZafIChar formatString[64];
	formatString[0] = '\0';
	
	int doZeroFill = (tmFlags & TMF_ZERO_FILL);
	int needSeparator = false;
	int needAmPm = false;

	if (tmFlags)
	{
		const ZafIChar *separator = (tmFlags & TMF_COLON_SEPARATOR) ? ZAF_ITEXT(":") :
			zafLocale->timeSeparator;
		
		if (tmFlags & TMF_NO_SEPARATOR)
			separator = ZAF_ITEXT("");

		if (!(tmFlags & TMF_NO_HOURS))
		{
			if (tmFlags & TMF_TWENTY_FOUR_HOUR)
				strcat(formatString, (doZeroFill ? HStr : hStr));
			else
			{
				strcat(formatString, (doZeroFill ? IStr : iStr));
				needAmPm = true;
			}
			needSeparator = true;
		}

		if (!(tmFlags & TMF_NO_MINUTES))
		{
			if (needSeparator)
				strcat(formatString, separator);

			strcat(formatString, mStr);
			needSeparator = true;
		}

		if (tmFlags & TMF_SECONDS)
		{
			if (needSeparator)
				strcat(formatString, separator);

			strcat(formatString, sStr);
			needSeparator = true;
		}

		if (tmFlags & TMF_HUNDREDTHS)
		{
			if (needSeparator)
				strcat(formatString, zafLocale->decimalSeparator);

			strcat(formatString, kStr);
			needSeparator = true;
		}

		if (needAmPm)
		{
			if (needSeparator)
				strcat(formatString, ZAF_ITEXT(" "));

			strcat(formatString, pStr);
		}

		time->SetOutputFormat(formatString);
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafTitle ----------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_TITLE(
	ZafWindowObject *object, OldDirectory *, OldFile *file,
	ZafObjectPersistence *)
{
	// Initialize the base information.
	if (!object)
		object = new ZafTitle(new ZafStringData);

	// Convert the title information.
	ZafTitle *title = DynamicPtrCast(object, ZafTitle);
	ZafIChar *text;
	*file >> &text;
	if (text)
	{
		title->SetText(text);
		delete []text;
	}

	// Return a pointer to the object.
	return (object);
}

// ----- ZafToolBar -------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_TOOL_BAR(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafToolBar(0, 0, 0, 0);
	Read_WINDOW(object, directory, file, persist);
	ZafToolBar *toolbar = DynamicPtrCast(object, ZafToolBar);
// TEMPORARY
	toolbar->SetNoncurrent(true);
	toolbar->SetSupportObject(true);
	toolbar->SetRegionType(ZAF_AVAILABLE_REGION);

	// Return a pointer to the object.
	return (object);
}

// ----- ZafVtList --------------------------------------------------------

ZafWindowObject *ZafConvertWindow::Read_VT_LIST(
	ZafWindowObject *object, OldDirectory *directory, OldFile *file,
	ZafObjectPersistence *persist)
{
	// Initialize the base information.
	if (!object)
		object = new ZafVtList(0, 0, 0, 0);
	Read_WINDOW(object, directory, file, persist);

	// Return a pointer to the object.
	return (object);
}

// ----- Derived item support -----------------------------------------------

ZafDerivedElement::ZafDerivedElement(ZafClassID tDeriveID, ZafClassID tBaseID) :
	ZafElement(), deriveID(tDeriveID), baseID(tBaseID)
{
}

ZafDerivedElement::~ZafDerivedElement()
{
}

ZafDerivedList::ZafDerivedList(): ZafList()
{
}

ZafDerivedList::~ZafDerivedList()
{
}

ZafDerivedElement *ZafDerivedList::Add(ZafDerivedElement *newElement)
{
	return (ZafDerivedElement *)ZafList::Add(newElement);
}

ZafIChar *ZafConvertWindow::ParseCompressedText(const ZafIChar *deleteText, const ZafIChar *formatText)
{
	if (!deleteText || !formatText)
		return (ZAF_NULLP(ZafIChar));

	int length = strlen(deleteText);
	ZafIChar *compressedText = new ZafIChar[length + 1];

	int i = 0;
	while (*deleteText && *formatText)
	{
		if (*formatText != 'L')
		{
			compressedText[i] = *deleteText;
			i++;
		}
		deleteText++;
		formatText++;
	}
	compressedText[i] = '\0';

	return (compressedText);
}

const ZafIChar oldHotChar = '&';
const ZafIChar oldHotChar1 = '~';

void ZafConvertWindow::StripHotkey(ZafIChar *text, ZafIChar &hotkey, int &index)
{
	// Set the values in case there is no hotkey

	hotkey = 0;
	index = -1;
	
	if (!text)
		return;

	ZafIChar *position = text;
	bool found = false;

	while (position)
	{
		while (*position && *position != oldHotChar && *position != oldHotChar1)
			position++;
		if (!*position)
			position = 0;

		if (position)
		{
			int length = strlen(position);

			if (position[0] != position[1] && !found)
			{
				memmove(position, position + 1, length * sizeof(*position));
				index = (int)(position - text) / sizeof(*position);
				hotkey = *position;
				// continue searching for "&&"
				found = true;
			}
			else
			{
				memmove(position, position + 1, length * sizeof(*position));
				position++;
			}
		}
	}
}
