//	Zinc Application Framework - CONVERT.HPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#if !defined(Z_CONVRT_HPP)
#	define Z_CONVRT_HPP
#	include <z_win.hpp>
#	include <z_gmgr.hpp>
#	include <z_winall.hpp>

enum DerivedWindowType
{
	MDI = 0, Dialog
};

class ZafConvertWindow : public ZafWindow
{
public:
//	struct ZAF_EXPORT ZafConvertStruct
	struct ZafConvertStruct
	{
		ZafClassID classID;
		ZafWindowObject *(*function)(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	};

//	struct ZAF_EXPORT ZafConvertGeometryStruct
	struct ZafConvertGeometryStruct
	{
		ZafClassID classID;
		ZafConstraint *(*function)(ZafConstraint *constraint, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	};

//	struct ZAF_EXPORT ZafConvertDerivedStruct
	struct ZafConvertDerivedStruct
	{
		ZafClassID classID;
		ZafWindowObject *(*function)(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	};

	static bool printStatus; //???
	ZafConvertWindow(const ZafIChar *name, OldDirectory *directory, ZafObjectPersistence *persist);

	// Static function for reading window to take care of the fact that ZafScrolledWindow
	// and ZafMDIWindow are now classes.
	static ZafWindowObject *ConvertWindow(const ZafIChar *name, OldDirectory *directory, ZafObjectPersistence *persist);

	// Static members for holding information about derived window classes.
	static bool destroyable;
	static ZafMDIType mdiType;
	static int scrollWidth;
	static int scrollHeight;
	static DerivedWindowType derivedWindowType;
	static ZafList helpList;

	static ZafIChar *ParseCompressedText(const ZafIChar *deleteText, const ZafIChar *formatText);
	static void StripHotkey(ZafIChar *text, ZafIChar &hotkey, int &index);

private:
	friend class ZafWindow;

	static ZAF_FARDATA ZafConvertStruct convert[];
	static ZAF_FARDATA ZafConvertGeometryStruct convertGeometry[];
	static ZAF_FARDATA ZafConvertDerivedStruct convertDerived[];

	static ZafWindowObject *Read_BIGNUM(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_BORDER(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_BUTTON(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_COMBO_BOX(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_DATE(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_FORMATTED_STRING(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_GROUP(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_HZ_LIST(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_ICON(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_INTEGER(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_MAXIMIZE_BUTTON(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_MINIMIZE_BUTTON(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_NOTEBOOK(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_POP_UP_MENU(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_POP_UP_ITEM(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_PROMPT(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_PULL_DOWN_MENU(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_PULL_DOWN_ITEM(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_REAL(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_SCROLL_BAR(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_SPIN_CONTROL(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_STATUS_BAR(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_STRING(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_SYSTEM_BUTTON(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_TABLE(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_TABLE_HEADER(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_TABLE_RECORD(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_TEXT(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_TIME(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_TITLE(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_TOOL_BAR(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_VT_LIST(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_WINDOW(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadMDIWindow(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDialogWindow(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadScrolledWindow(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_WINDOW_OBJECT(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *Read_GEOMETRY_MANAGER(ZafWindowObject *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafConstraint *Read_CONSTRAINT(ZafConstraint *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafConstraint *Read_ATTACHMENT(ZafConstraint *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafConstraint *Read_DIMENSION_CONSTRAINT(ZafConstraint *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafConstraint *Read_RELATIVE_CONSTRAINT(ZafConstraint *object, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);

	// For reading in derived objects
	static ZafWindowObject *ReadDerivedBignum(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedBorder(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedButton(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedComboBox(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedDate(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedFormattedString(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedGroup(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedHzList(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedIcon(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedInteger(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedMaximizeButton(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedMinimizeButton(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedNotebook(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedPopUpMenu(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedPopUpItem(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedPrompt(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedPullDownMenu(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedPullDownItem(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedReal(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedScrollBar(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedSpinControl(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedStatusBar(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedString(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedSystemButton(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedTable(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedTableHeader(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedTableRecord(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedText(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedTime(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedTitle(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedToolBar(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedVtList(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedWindow(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
	static ZafWindowObject *ReadDerivedWindowObject(ZafClassID saveID, OldDirectory *directory, OldFile *file, ZafObjectPersistence *persist);
};

class ZafDerivedElement : public ZafElement
{
public:
	ZafDerivedElement(ZafClassID deriveID, ZafClassID baseID);
	~ZafDerivedElement();
	ZafDerivedElement *Next() const { return (ZafDerivedElement *)next; }
	ZafDerivedElement *Previous() const { return (ZafDerivedElement *)previous; }
	ZafClassID DeriveID() const { return deriveID; }
	ZafClassID BaseID() const { return baseID; }
protected:
	ZafClassID deriveID, baseID;
};

class ZafDerivedList : public ZafList
{
public:
	ZafDerivedList();
	~ZafDerivedList();
	ZafDerivedElement *First() const { return (ZafDerivedElement *)first; }
	ZafDerivedElement *Last() const { return (ZafDerivedElement *)last; }
	ZafDerivedElement *Current() const { return (ZafDerivedElement *)current; }
	ZafDerivedElement *Add(ZafDerivedElement *newElement);
};

#endif // Z_CONVRT_HPP

