//	Zinc Application Framework - TRITM.CPP
//	COPYRIGHT (C) 1990-1997.  All Rights Reserved.
//	Zinc Software Incorporated.  Pleasant Grove, Utah  USA

#include <z_stdlib.hpp>
#include <z_utils.hpp>
#include "maintest.hpp"

// This table contains the list of all attributes that can be set on this 
// object.  AttributeTable.count gets updated by GenericTestWin::Event().
// This list is used to create the attribute chack boxes in the attribute 
// list.
ListEntry ZAF_FARDATA GenericTestWin::AttributeTable[] =
{
	// ZafTreeItem
	{ ZAF_ITEXT("Expandable"),        0, TST_TOGGLE_EXPANDABLE },
	{ ZAF_ITEXT("Expanded *"),        0, TST_TOGGLE_EXPANDED },
	{ ZAF_ITEXT("Normal bitmap"),     0, TST_TOGGLE_NORMAL_BITMAP },
	{ ZAF_ITEXT("Selected bitmap"),   0, TST_TOGGLE_SELECTED_BITMAP },

	// ZafWindowObject
//	{ ZAF_ITEXT("Bordered"),          0, TST_TOGGLE_BORDERED },
	{ ZAF_ITEXT("Visible *"),         0, TST_TOGGLE_VISIBLE },
//	{ ZAF_ITEXT("Accept drop *"),     0, TST_TOGGLE_ACCEPT_DROP },
	{ ZAF_ITEXT("Auto update *"),     0, TST_TOGGLE_AUTOMATIC_UPDATE },
//	{ ZAF_ITEXT("Changed *"),         0, TST_TOGGLE_CHANGED },
//	{ ZAF_ITEXT("Copy Draggable *"),  0, TST_TOGGLE_COPY_DRAGGABLE },
//	{ ZAF_ITEXT("Link Draggable *"),  0, TST_TOGGLE_LINK_DRAGGABLE },
//	{ ZAF_ITEXT("Move Draggable *"),  0, TST_TOGGLE_MOVE_DRAGGABLE },
	{ ZAF_ITEXT("Focus *"),           0, TST_TOGGLE_FOCUS },
	{ ZAF_ITEXT("Noncurrent *"),     0, TST_TOGGLE_NONCURRENT },
	{ ZAF_ITEXT("Disabled *"),        0, TST_TOGGLE_DISABLED },
	{ ZAF_ITEXT("OSdraw"),            0, TST_TOGGLE_OSDRAW },
//	{ ZAF_ITEXT("Parentdraw border"), 0, TST_TOGGLE_PARENTDRAW_BORDER },
	{ ZAF_ITEXT("Parent palette"),    0, TST_TOGGLE_PARENTPALETTE },
	{ ZAF_ITEXT("Parentdraw focus"),  0, TST_TOGGLE_PARENTDRAW_FOCUS },
	{ ZAF_ITEXT("Selected *"),       0, TST_TOGGLE_SELECTED },
	{ ZAF_ITEXT("Edit mode"),       0, TST_TOGGLE_EDIT_MODE },
	{ ZAF_NULLP(ZafIChar),            0, 0 }
};

static ZafLogicalColor normalBitmapArray[16][16] =
{
	{ 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
	{ 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2 },
	{ 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3 },
	{ 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4 },
	{ 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5 },
	{ 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6 },
	{ 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7 },
	{ 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8 },
	{ 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9 },
	{ 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10 },
	{ 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11 },
	{ 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12 },
	{ 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13, 13 },
	{ 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14 },
	{ 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15 }
};

static ZafImageStruct normalBitmapInfo = 
{
	16, 16, (ZafLogicalColor *)normalBitmapArray
};

static ZafBitmapData normalBitmapData(normalBitmapInfo);

static ZafLogicalColor selectedBitmapArray[16][16] =
{
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 },
	{ 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 }
};

static ZafImageStruct selectedBitmapInfo = 
{
	16, 16, (ZafLogicalColor *)selectedBitmapArray
};

static ZafBitmapData selectedBitmapData(selectedBitmapInfo);

ZafEventType TreeItemCallback(ZafWindowObject *, ZafEventStruct &, ZafEventType ccode)
{
	if (ccode == L_SELECT)
		ZafErrorSystem::Beep();
	else if (ccode == L_DOUBLE_CLICK)
	{
		ZafErrorSystem::Beep();
		ZafErrorSystem::Beep();
	}

	return (0);
}

int CompareDescending(void *object1, void *object2)
{
	return (stricmp(((ZafWindowObject *)object2)->Text(), ((ZafWindowObject *)object1)->Text()));
}

// ---- Derived test object -------------------------------------------------

class TestObj : public ZafTreeItem
{
public:
  	TestObj();
	ZafEventType Event(const ZafEventStruct &event);
};

TestObj::TestObj() : ZafTreeItem(&normalBitmapData, &selectedBitmapData,
	new ZafStringData("Base1"))
{
	normalBitmapData.SetDestroyable(false);
	selectedBitmapData.SetDestroyable(false);

	// !!! MUST BE "TEST_OBJECT" so can initialize testObject pointer !!!
	SetStringID(ZAF_ITEXT("TEST_OBJECT"));
}

ZafEventType TestObj::Event(const ZafEventStruct &event)
{
	// Log the event and then pass to base class to be handled.
	ZafEventType ccode = LogicalEvent(event);
	GenericTestWin *testWin = DynamicPtrCast(parent->parent, GenericTestWin);
	testWin->LogEvent(ccode);

	ccode = ZafTreeItem::Event(event);

	if (ccode == S_CURRENT || ccode == S_NON_CURRENT)
	{
		ZafVtList *attrList= DynamicPtrCast(testWin->GetObject(ZAF_ITEXT("ATTR_LIST")), ZafVtList);
		attrList->GetObject((ZafNumberID)TST_TOGGLE_FOCUS)->SetSelected(Focus());
	}

	return (ccode);
}

// ---- Derived test window -------------------------------------------------

ObjectTestWin::ObjectTestWin() : GenericTestWin(1, 1, 80, 12)
{
	// The test object can place settings tree boxes, etc. in the area
	// 1, 8 (left, top) 47, 9 (right, bottom).

	// Test objects can be placed in the area to the right of the divider 
	// line.  So an area of 50, 1 (left, top) to 78, 9 (right, bottom) can
	// be used.  This area can be bigger or smaller simply by adjusting 
	// the size passed to the GenericTestWin constructor above.

	// Set the title text.
	SetText(ZAF_ITEXT("Treeitem"));

	// Add settings objects.

	// Create sort type combo box.
	ZafComboBox *sortTypeCombo = new ZafComboBox(1, 9, 20, 3);
	sortTypeCombo->SetStringID(ZAF_ITEXT("SORT_COMBO"));
	sortTypeCombo->SetViewOnly(true);
	sortTypeCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	ZafButton *attr = new ZafButton(0, 0, 15, 1, new ZafStringData("No sort *"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SORT_NONE);
	attr->SetNumberID((ZafNumberID)TST_SET_SORT_NONE);
	sortTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Auto sort *"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SORT_AUTO);
	attr->SetNumberID((ZafNumberID)TST_SET_SORT_AUTO);
	sortTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Reverse sort *"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SORT_REVERSE);
	attr->SetNumberID((ZafNumberID)TST_SET_SORT_REVERSE);
	sortTypeCombo->Add(attr);

	Add(sortTypeCombo);

	// Create selection type combo box.
	ZafComboBox *selectionTypeCombo = new ZafComboBox(27, 9, 20, 3);
	selectionTypeCombo->SetViewOnly(true);
	selectionTypeCombo->SetStringID(ZAF_ITEXT("SELECTION_TYPE_COMBO"));
	selectionTypeCombo->Add(new ZafScrollBar(0, 0, 0, 0, ZAF_NULLP(ZafScrollData)));
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Single Selection"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SELECTION_SINGLE);
	attr->SetNumberID((ZafNumberID)TST_SET_SELECTION_SINGLE);
	selectionTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Multiple Selection"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SELECTION_MULTIPLE);
	attr->SetNumberID((ZafNumberID)TST_SET_SELECTION_MULTIPLE);
	selectionTypeCombo->Add(attr);
	attr = new ZafButton(0, 0, 15, 1, new ZafStringData("Extended Selection"));
	attr->SetButtonType(ZAF_FLAT_BUTTON);
	attr->SetHzJustify(ZAF_HZ_LEFT);
	attr->SetSendMessageWhenSelected(true);
	attr->SetValue(TST_SET_SELECTION_EXTENDED);
	attr->SetNumberID((ZafNumberID)TST_SET_SELECTION_EXTENDED);
	selectionTypeCombo->Add(attr);

	Add(selectionTypeCombo);

	// Add the test object.
	testObject = new TestObj;
	ZafTreeList *tree = new ZafTreeList(50, 1, 28, 4);
	tree->Add(new ZafScrollBar(0, 0, 0, 0));
	ZafTreeItem *baseItem1 = DynamicPtrCast(testObject, ZafTreeItem);
	baseItem1->SetExpandable(true);
	tree->Add(baseItem1);
	ZafTreeItem *baseItem2 = new ZafTreeItem(0, 0, new ZafStringData("Base2"));
	baseItem2->SetExpandable(true);
	tree->Add(baseItem2);

	int i;
	ZafIChar string[256];
	for (i = 0; i < 10; i++)
	{
		sprintf(string, ZAF_ITEXT("Item %d"), i);
		ZafTreeItem *item = new ZafTreeItem(&normalBitmapData,
			&selectedBitmapData, new ZafStringData(string));
		item->SetExpandable(true);
		for (int j = 0; j < 10; j++)
		{
			sprintf(string, ZAF_ITEXT("Sub-item %d.%d"), i, j);
			ZafTreeItem *subItem = new ZafTreeItem(&normalBitmapData,
				&selectedBitmapData, new ZafStringData(string));
			subItem->SetExpandable(true);
			for (int k = 0; k < 10; k++)
			{
				sprintf(string, ZAF_ITEXT("Leaf-item %d.%d.%d"), i, j, k);
				ZafTreeItem *leafItem = new ZafTreeItem(0, 0, new ZafStringData(string));
				leafItem->SetUserFunction(TreeItemCallback);
				subItem->Add(leafItem);
			}
			item->Add(subItem);
		}
		baseItem1->Add(item);
	}
	for (i = 0; i < 10; i++)
	{
		sprintf(string, ZAF_ITEXT("Item %d"), i);
		ZafTreeItem *item = new ZafTreeItem(&normalBitmapData,
			&selectedBitmapData, new ZafStringData(string));
		item->SetExpandable(true);
		for (int j = 0; j < 10; j++)
		{
			sprintf(string, ZAF_ITEXT("Sub-item %d.%d"), i, j);
			ZafTreeItem *subItem = new ZafTreeItem(&normalBitmapData,
				&selectedBitmapData, new ZafStringData(string));
			subItem->SetExpandable(true);
			for (int k = 0; k < 10; k++)
			{
				sprintf(string, ZAF_ITEXT("Leaf-item %d.%d.%d"), i, j, k);
				ZafTreeItem *leafItem = new ZafTreeItem(0, 0, new ZafStringData(string));
				leafItem->SetUserFunction(TreeItemCallback);
				subItem->Add(leafItem);
			}
			item->Add(subItem);
		}
		baseItem2->Add(item);
	}
	tree->Add(testObject);

	Add(tree);

	// Add other objects needed to test the object.
	tree = new ZafTreeList(50, 5, 28, 4);
	tree->SetCopyDraggable(true);
	tree->SetMoveDraggable(true);
	tree->SetLinkDraggable(true);
	tree->Add(new ZafScrollBar(0, 0, 0, 0));
	baseItem1 = new ZafTreeItem(0, 0, new ZafStringData("Base1"));
	baseItem1->SetExpandable(true);
	tree->Add(baseItem1);

	for (i = 0; i < 10; i++)
	{
		sprintf(string, ZAF_ITEXT("Item %d"), i);
		ZafTreeItem *item = new ZafTreeItem(&normalBitmapData,
			&selectedBitmapData, new ZafStringData(string));
		item->SetExpandable(true);
		for (int j = 0; j < 10; j++)
		{
			sprintf(string, ZAF_ITEXT("Sub-item %d.%d"), i, j);
			ZafTreeItem *subItem = new ZafTreeItem(&normalBitmapData,
				&selectedBitmapData, new ZafStringData(string));
			subItem->SetExpandable(true);
			for (int k = 0; k < 10; k++)
			{
				sprintf(string, ZAF_ITEXT("Leaf-item %d.%d.%d"), i, j, k);
				ZafTreeItem *leafItem = new ZafTreeItem(0, 0, new ZafStringData(string));
				leafItem->SetUserFunction(TreeItemCallback);
				subItem->Add(leafItem);
			}
			item->Add(subItem);
		}
		baseItem1->Add(item);
	}
	Add(tree);
}

ZafEventType ObjectTestWin::Event(const ZafEventStruct &event)
{
	ZafTreeItem *treeItem = DynamicPtrCast(testObject, ZafTreeItem);

	ZafEventType ccode = event.type;
	switch (ccode)
	{
	// TST_TOGGLE_*** sets testObject's attribute to the selected status of
	// the attribute check box.  It then updates the attribute check box
	// using the attribute accessor function to test if the attribute was
	// successfully set.
	case TST_TOGGLE_EXPANDABLE:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_EXPANDABLE);
			treeItem->SetExpandable(attr->Selected());
			attr->SetSelected(treeItem->Expandable());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_EXPANDED:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_EXPANDED);
			treeItem->SetExpanded(attr->Selected());
			attr->SetSelected(treeItem->Expanded());

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_NORMAL_BITMAP:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_NORMAL_BITMAP);
			if (attr->Selected())
				treeItem->SetNormalBitmap(new ZafBitmapData(normalBitmapData));
			else
				treeItem->SetNormalBitmap(ZAF_NULLP(ZafBitmapData));

			attr->SetSelected(treeItem->NormalBitmap() ? true : false);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_TOGGLE_SELECTED_BITMAP:
		{
			ZafWindowObject *attr = attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTED_BITMAP);
			if (attr->Selected())
				treeItem->SetSelectedBitmap(new ZafBitmapData(selectedBitmapData));
			else
				treeItem->SetSelectedBitmap(ZAF_NULLP(ZafBitmapData));

			attr->SetSelected(treeItem->SelectedBitmap() ? true : false);

			// Make sure counts get updated.
			GenericTestWin::Event(event);
		}
		break;

	case TST_SET_SORT_NONE:
	case TST_SET_SORT_AUTO:
	case TST_SET_SORT_REVERSE:
		{
			if (ccode == TST_SET_SORT_NONE)
			{
				treeItem->SetCompareFunction(ZAF_NULLF(ZafCompareFunction));
				treeItem->SetAutoSortData(false);
			}
			else if (ccode == TST_SET_SORT_AUTO)
			{
				treeItem->SetAutoSortData(true);
				treeItem->Sort();
			}
			else if (ccode == TST_SET_SORT_REVERSE)
			{
				treeItem->SetCompareFunction((ZafCompareFunction)CompareDescending);
				treeItem->SetAutoSortData(false);
				treeItem->Sort();
			}

			ZafComboBox *sortCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SORT_COMBO")), ZafComboBox);
			if (!treeItem->AutoSortData() && !treeItem->CompareFunction())
				sortCombo->GetObject((ZafNumberID)TST_SET_SORT_NONE)->SetSelected(true);
			else if (treeItem->AutoSortData())
				sortCombo->GetObject((ZafNumberID)TST_SET_SORT_AUTO)->SetSelected(true);
			else if (treeItem->CompareFunction() == (ZafCompareFunction)CompareDescending)
				sortCombo->GetObject((ZafNumberID)TST_SET_SORT_REVERSE)->SetSelected(true);
		}
		break;

	case TST_SET_SELECTION_SINGLE:
	case TST_SET_SELECTION_MULTIPLE:
	case TST_SET_SELECTION_EXTENDED:
		{
			if (ccode == TST_SET_SELECTION_SINGLE)
				treeItem->SetSelectionType(ZAF_SINGLE_SELECTION);
			else if (ccode == TST_SET_SELECTION_MULTIPLE)
				treeItem->SetSelectionType(ZAF_MULTIPLE_SELECTION);
			else if (ccode == TST_SET_SELECTION_EXTENDED)
				treeItem->SetSelectionType(ZAF_EXTENDED_SELECTION);

			ZafComboBox *selectionCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SELECTION_TYPE_COMBO")), ZafComboBox);
			switch (treeItem->SelectionType())
			{
			case ZAF_SINGLE_SELECTION:
				selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_SINGLE)->SetSelected(true);
				break;

			case ZAF_MULTIPLE_SELECTION:
				selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_MULTIPLE)->SetSelected(true);
				break;

			case ZAF_EXTENDED_SELECTION:
				selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_EXTENDED)->SetSelected(true);
				break;
			}
		}
		break;

	default:
		ccode = GenericTestWin::Event(event);
		break;
	}

	return (ccode);
}

void ObjectTestWin::SynchronizeAttributes()
{
	ZafTreeItem *treeItem = DynamicPtrCast(testObject, ZafTreeItem);
 
	// Preset attributes according to test object's settings.
	attrList->GetObject((ZafNumberID)TST_TOGGLE_EXPANDABLE)->SetSelected(treeItem->Expandable());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_EXPANDED)->SetSelected(treeItem->Expanded());
	attrList->GetObject((ZafNumberID)TST_TOGGLE_NORMAL_BITMAP)->SetSelected(treeItem->NormalBitmap() ? true : false);
	attrList->GetObject((ZafNumberID)TST_TOGGLE_SELECTED_BITMAP)->SetSelected(treeItem->SelectedBitmap() ? true : false);

	ZafComboBox *sortCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SORT_COMBO")), ZafComboBox);
	if (!treeItem->AutoSortData() && !treeItem->CompareFunction())
		sortCombo->GetObject((ZafNumberID)TST_SET_SORT_NONE)->SetSelected(true);
	else if (treeItem->AutoSortData())
		sortCombo->GetObject((ZafNumberID)TST_SET_SORT_AUTO)->SetSelected(true);
	else if (treeItem->CompareFunction() == (ZafCompareFunction)CompareDescending)
		sortCombo->GetObject((ZafNumberID)TST_SET_SORT_REVERSE)->SetSelected(true);

	ZafComboBox *selectionCombo = DynamicPtrCast(GetObject(ZAF_ITEXT("SELECTION_TYPE_COMBO")), ZafComboBox);
	switch (treeItem->SelectionType())
	{
	case ZAF_SINGLE_SELECTION:
		selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_SINGLE)->SetSelected(true);
		break;

	case ZAF_MULTIPLE_SELECTION:
		selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_MULTIPLE)->SetSelected(true);
		break;

	case ZAF_EXTENDED_SELECTION:
		selectionCombo->GetObject((ZafNumberID)TST_SET_SELECTION_EXTENDED)->SetSelected(true);
		break;
	}

	GenericTestWin::SynchronizeAttributes();

}
